/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.auth;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWS3Signer;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWS4Signer;
import net.snowflake.client.jdbc.internal.amazonaws.auth.NoOpSigner;
import net.snowflake.client.jdbc.internal.amazonaws.auth.QueryStringSigner;
import net.snowflake.client.jdbc.internal.amazonaws.auth.ServiceAwareSigner;
import net.snowflake.client.jdbc.internal.amazonaws.auth.Signer;
import net.snowflake.client.jdbc.internal.amazonaws.internal.config.InternalConfig;
import net.snowflake.client.jdbc.internal.amazonaws.internal.config.SignerConfig;

public final class SignerFactory {
    private static final String QUERY_STRING_SIGNER = "QueryStringSignerType";
    private static final String VERSION_THREE_SIGNER = "AWS3SignerType";
    private static final String VERSION_FOUR_SIGNER = "AWS4SignerType";
    private static final String NO_OP_SIGNER = "NoOpSignerType";
    private static final Map<String, Class<? extends Signer>> SIGNERS = new ConcurrentHashMap<String, Class<? extends Signer>>();

    private SignerFactory() {
    }

    public static void registerSigner(String signerType, Class<? extends Signer> signerClass) {
        if (signerType == null) {
            throw new IllegalArgumentException("signerType cannot be null");
        }
        if (signerClass == null) {
            throw new IllegalArgumentException("signerClass cannot be null");
        }
        SIGNERS.put(signerType, signerClass);
    }

    public static Signer getSigner(String serviceName, String regionName) {
        return SignerFactory.lookupAndCreateSigner(serviceName, regionName);
    }

    public static Signer getSignerByTypeAndService(String signerType, String serviceName) {
        return SignerFactory.createSigner(signerType, serviceName);
    }

    private static Signer lookupAndCreateSigner(String serviceName, String regionName) {
        InternalConfig config = InternalConfig.Factory.getInternalConfig();
        SignerConfig signerConfig = config.getSignerConfig(serviceName, regionName);
        String signerType = signerConfig.getSignerType();
        return SignerFactory.createSigner(signerType, serviceName);
    }

    private static Signer createSigner(String signerType, String serviceName) {
        Signer signer;
        Class<? extends Signer> signerClass = SIGNERS.get(signerType);
        if (signerClass == null) {
            throw new IllegalArgumentException("unknown signer type: " + signerType);
        }
        try {
            signer = signerClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new IllegalStateException("Cannot create an instance of " + signerClass.getName(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot create an instance of " + signerClass.getName(), ex);
        }
        if (signer instanceof ServiceAwareSigner) {
            ((ServiceAwareSigner)signer).setServiceName(serviceName);
        }
        return signer;
    }

    static {
        SIGNERS.put(QUERY_STRING_SIGNER, QueryStringSigner.class);
        SIGNERS.put(VERSION_THREE_SIGNER, AWS3Signer.class);
        SIGNERS.put(VERSION_FOUR_SIGNER, AWS4Signer.class);
        SIGNERS.put(NO_OP_SIGNER, NoOpSigner.class);
    }
}

