/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.io.SerializedString;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.AnnotationIntrospector;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.ClassUtil;

public final class EnumValues {
    private final Class<Enum<?>> _enumClass;
    private final EnumMap<?, SerializedString> _values;

    private EnumValues(Class<Enum<?>> clazz, Map<Enum<?>, SerializedString> map) {
        this._enumClass = clazz;
        this._values = new EnumMap(map);
    }

    public static EnumValues construct(Class<Enum<?>> clazz, AnnotationIntrospector annotationIntrospector) {
        return EnumValues.constructFromName(clazz, annotationIntrospector);
    }

    public static EnumValues constructFromName(Class<Enum<?>> clazz, AnnotationIntrospector annotationIntrospector) {
        Class<Enum<?>> clazz2 = ClassUtil.findEnumType(clazz);
        Enum<?>[] enumArray = clazz2.getEnumConstants();
        if (enumArray != null) {
            HashMap hashMap = new HashMap();
            for (Enum<?> enum_ : enumArray) {
                String string = annotationIntrospector.findEnumValue(enum_);
                hashMap.put(enum_, new SerializedString(string));
            }
            return new EnumValues(clazz, hashMap);
        }
        throw new IllegalArgumentException("Can not determine enum constants for Class " + clazz.getName());
    }

    public static EnumValues constructFromToString(Class<Enum<?>> clazz, AnnotationIntrospector annotationIntrospector) {
        Class<Enum<?>> clazz2 = ClassUtil.findEnumType(clazz);
        Enum<?>[] enumArray = clazz2.getEnumConstants();
        if (enumArray != null) {
            HashMap hashMap = new HashMap();
            for (Enum<?> enum_ : enumArray) {
                hashMap.put(enum_, new SerializedString(enum_.toString()));
            }
            return new EnumValues(clazz, hashMap);
        }
        throw new IllegalArgumentException("Can not determine enum constants for Class " + clazz.getName());
    }

    public SerializedString serializedValueFor(Enum<?> enum_) {
        return this._values.get(enum_);
    }

    public Collection<SerializedString> values() {
        return this._values.values();
    }

    public EnumMap<?, SerializedString> internalMap() {
        return this._values;
    }

    public Class<Enum<?>> getEnumClass() {
        return this._enumClass;
    }
}

