/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonParser;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonToken;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.DeserializationContext;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.SettableBeanProperty;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.TokenBuffer;

public class ExternalTypeHandler {
    private final ExtTypedProperty[] _properties;
    private final HashMap<String, Integer> _nameToPropertyIndex;
    private final String[] _typeIds;
    private final TokenBuffer[] _tokens;

    protected ExternalTypeHandler(ExtTypedProperty[] extTypedPropertyArray, HashMap<String, Integer> hashMap, String[] stringArray, TokenBuffer[] tokenBufferArray) {
        this._properties = extTypedPropertyArray;
        this._nameToPropertyIndex = hashMap;
        this._typeIds = stringArray;
        this._tokens = tokenBufferArray;
    }

    protected ExternalTypeHandler(ExternalTypeHandler externalTypeHandler) {
        this._properties = externalTypeHandler._properties;
        this._nameToPropertyIndex = externalTypeHandler._nameToPropertyIndex;
        int n = this._properties.length;
        this._typeIds = new String[n];
        this._tokens = new TokenBuffer[n];
    }

    public ExternalTypeHandler start() {
        return new ExternalTypeHandler(this);
    }

    public boolean handleTypePropertyValue(JsonParser jsonParser, DeserializationContext deserializationContext, String string, Object object) throws IOException, JsonProcessingException {
        boolean bl;
        Integer n = this._nameToPropertyIndex.get(string);
        if (n == null) {
            return false;
        }
        int n2 = n;
        ExtTypedProperty extTypedProperty = this._properties[n2];
        if (!extTypedProperty.hasTypePropertyName(string)) {
            return false;
        }
        String string2 = jsonParser.getText();
        boolean bl2 = bl = object != null && this._tokens[n2] != null;
        if (bl) {
            this._deserializeAndSet(jsonParser, deserializationContext, object, n2, string2);
            this._tokens[n2] = null;
        } else {
            this._typeIds[n2] = string2;
        }
        return true;
    }

    public boolean handlePropertyValue(JsonParser jsonParser, DeserializationContext deserializationContext, String string, Object object) throws IOException, JsonProcessingException {
        Object object2;
        boolean bl;
        Integer n = this._nameToPropertyIndex.get(string);
        if (n == null) {
            return false;
        }
        int n2 = n;
        ExtTypedProperty extTypedProperty = this._properties[n2];
        if (extTypedProperty.hasTypePropertyName(string)) {
            this._typeIds[n2] = jsonParser.getText();
            jsonParser.skipChildren();
            bl = object != null && this._tokens[n2] != null;
        } else {
            object2 = new TokenBuffer(jsonParser);
            ((TokenBuffer)object2).copyCurrentStructure(jsonParser);
            this._tokens[n2] = object2;
            boolean bl2 = bl = object != null && this._typeIds[n2] != null;
        }
        if (bl) {
            object2 = this._typeIds[n2];
            this._typeIds[n2] = null;
            this._deserializeAndSet(jsonParser, deserializationContext, object, n2, (String)object2);
            this._tokens[n2] = null;
        }
        return true;
    }

    public Object complete(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException, JsonProcessingException {
        int n = this._properties.length;
        for (int i = 0; i < n; ++i) {
            Object object2;
            String string = this._typeIds[i];
            if (string == null) {
                object2 = this._tokens[i];
                if (object2 == null) continue;
                JsonToken jsonToken = ((TokenBuffer)object2).firstToken();
                if (jsonToken != null && jsonToken.isScalarValue()) {
                    JsonParser jsonParser2 = ((TokenBuffer)object2).asParser(jsonParser);
                    jsonParser2.nextToken();
                    SettableBeanProperty settableBeanProperty = this._properties[i].getProperty();
                    Object object3 = TypeDeserializer.deserializeIfNatural(jsonParser2, deserializationContext, settableBeanProperty.getType());
                    if (object3 != null) {
                        settableBeanProperty.set(object, object3);
                        continue;
                    }
                    if (!this._properties[i].hasDefaultType()) {
                        throw deserializationContext.mappingException("Missing external type id property '" + this._properties[i].getTypePropertyName() + "'");
                    }
                    string = this._properties[i].getDefaultTypeId();
                }
            } else if (this._tokens[i] == null) {
                object2 = this._properties[i].getProperty();
                throw deserializationContext.mappingException("Missing property '" + ((SettableBeanProperty)object2).getName() + "' for external type id '" + this._properties[i].getTypePropertyName());
            }
            this._deserializeAndSet(jsonParser, deserializationContext, object, i, string);
        }
        return object;
    }

    public Object complete(JsonParser jsonParser, DeserializationContext deserializationContext, PropertyValueBuffer propertyValueBuffer, PropertyBasedCreator propertyBasedCreator) throws IOException, JsonProcessingException {
        Object object;
        int n;
        int n2 = this._properties.length;
        Object[] objectArray = new Object[n2];
        for (n = 0; n < n2; ++n) {
            object = this._typeIds[n];
            if (object == null) {
                if (this._tokens[n] == null) continue;
                if (!this._properties[n].hasDefaultType()) {
                    throw deserializationContext.mappingException("Missing external type id property '" + this._properties[n].getTypePropertyName() + "'");
                }
                object = this._properties[n].getDefaultTypeId();
            } else if (this._tokens[n] == null) {
                SettableBeanProperty settableBeanProperty = this._properties[n].getProperty();
                throw deserializationContext.mappingException("Missing property '" + settableBeanProperty.getName() + "' for external type id '" + this._properties[n].getTypePropertyName());
            }
            objectArray[n] = this._deserialize(jsonParser, deserializationContext, n, (String)object);
        }
        for (n = 0; n < n2; ++n) {
            object = this._properties[n].getProperty();
            if (propertyBasedCreator.findCreatorProperty(((SettableBeanProperty)object).getName()) == null) continue;
            propertyValueBuffer.assignParameter(((SettableBeanProperty)object).getCreatorIndex(), objectArray[n]);
        }
        Object object2 = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
        for (int i = 0; i < n2; ++i) {
            SettableBeanProperty settableBeanProperty = this._properties[i].getProperty();
            if (propertyBasedCreator.findCreatorProperty(settableBeanProperty.getName()) != null) continue;
            settableBeanProperty.set(object2, objectArray[i]);
        }
        return object2;
    }

    protected final Object _deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, int n, String string) throws IOException, JsonProcessingException {
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser);
        tokenBuffer.writeStartArray();
        tokenBuffer.writeString(string);
        JsonParser jsonParser2 = this._tokens[n].asParser(jsonParser);
        jsonParser2.nextToken();
        tokenBuffer.copyCurrentStructure(jsonParser2);
        tokenBuffer.writeEndArray();
        jsonParser2 = tokenBuffer.asParser(jsonParser);
        jsonParser2.nextToken();
        return this._properties[n].getProperty().deserialize(jsonParser2, deserializationContext);
    }

    protected final void _deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, int n, String string) throws IOException, JsonProcessingException {
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser);
        tokenBuffer.writeStartArray();
        tokenBuffer.writeString(string);
        JsonParser jsonParser2 = this._tokens[n].asParser(jsonParser);
        jsonParser2.nextToken();
        tokenBuffer.copyCurrentStructure(jsonParser2);
        tokenBuffer.writeEndArray();
        jsonParser2 = tokenBuffer.asParser(jsonParser);
        jsonParser2.nextToken();
        this._properties[n].getProperty().deserializeAndSet(jsonParser2, deserializationContext, object);
    }

    private static final class ExtTypedProperty {
        private final SettableBeanProperty _property;
        private final TypeDeserializer _typeDeserializer;
        private final String _typePropertyName;

        public ExtTypedProperty(SettableBeanProperty settableBeanProperty, TypeDeserializer typeDeserializer) {
            this._property = settableBeanProperty;
            this._typeDeserializer = typeDeserializer;
            this._typePropertyName = typeDeserializer.getPropertyName();
        }

        public boolean hasTypePropertyName(String string) {
            return string.equals(this._typePropertyName);
        }

        public boolean hasDefaultType() {
            return this._typeDeserializer.getDefaultImpl() != null;
        }

        public String getDefaultTypeId() {
            Class<?> clazz = this._typeDeserializer.getDefaultImpl();
            if (clazz == null) {
                return null;
            }
            return this._typeDeserializer.getTypeIdResolver().idFromValueAndType(null, clazz);
        }

        public String getTypePropertyName() {
            return this._typePropertyName;
        }

        public SettableBeanProperty getProperty() {
            return this._property;
        }
    }

    public static class Builder {
        private final ArrayList<ExtTypedProperty> _properties = new ArrayList();
        private final HashMap<String, Integer> _nameToPropertyIndex = new HashMap();

        public void addExternal(SettableBeanProperty settableBeanProperty, TypeDeserializer typeDeserializer) {
            Integer n = this._properties.size();
            this._properties.add(new ExtTypedProperty(settableBeanProperty, typeDeserializer));
            this._nameToPropertyIndex.put(settableBeanProperty.getName(), n);
            this._nameToPropertyIndex.put(typeDeserializer.getPropertyName(), n);
        }

        public ExternalTypeHandler build() {
            return new ExternalTypeHandler(this._properties.toArray(new ExtTypedProperty[this._properties.size()]), this._nameToPropertyIndex, null, null);
        }
    }
}

