/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.logs.model.transform;

import java.io.StringWriter;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonClientException;
import net.snowflake.client.jdbc.internal.amazonaws.DefaultRequest;
import net.snowflake.client.jdbc.internal.amazonaws.Request;
import net.snowflake.client.jdbc.internal.amazonaws.http.HttpMethodName;
import net.snowflake.client.jdbc.internal.amazonaws.internal.ListWithAutoConstructFlag;
import net.snowflake.client.jdbc.internal.amazonaws.services.logs.model.InputLogEvent;
import net.snowflake.client.jdbc.internal.amazonaws.services.logs.model.PutLogEventsRequest;
import net.snowflake.client.jdbc.internal.amazonaws.transform.Marshaller;
import net.snowflake.client.jdbc.internal.amazonaws.util.StringInputStream;
import net.snowflake.client.jdbc.internal.amazonaws.util.StringUtils;
import net.snowflake.client.jdbc.internal.amazonaws.util.json.JSONWriter;

public class PutLogEventsRequestMarshaller
implements Marshaller<Request<PutLogEventsRequest>, PutLogEventsRequest> {
    @Override
    public Request<PutLogEventsRequest> marshall(PutLogEventsRequest putLogEventsRequest) {
        if (putLogEventsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutLogEventsRequest> request = new DefaultRequest<PutLogEventsRequest>(putLogEventsRequest, "AWSLogs");
        String target = "Logs_20140328.PutLogEvents";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag logEventsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (putLogEventsRequest.getLogGroupName() != null) {
                jsonWriter.key("logGroupName").value(putLogEventsRequest.getLogGroupName());
            }
            if (putLogEventsRequest.getLogStreamName() != null) {
                jsonWriter.key("logStreamName").value(putLogEventsRequest.getLogStreamName());
            }
            if (!((logEventsList = (ListWithAutoConstructFlag)putLogEventsRequest.getLogEvents()) == null || logEventsList.isAutoConstruct() && logEventsList.isEmpty())) {
                jsonWriter.key("logEvents");
                jsonWriter.array();
                for (InputLogEvent logEventsListValue : logEventsList) {
                    if (logEventsListValue == null) continue;
                    jsonWriter.object();
                    if (logEventsListValue.getTimestamp() != null) {
                        jsonWriter.key("timestamp").value(logEventsListValue.getTimestamp());
                    }
                    if (logEventsListValue.getMessage() != null) {
                        jsonWriter.key("message").value(logEventsListValue.getMessage());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (putLogEventsRequest.getSequenceToken() != null) {
                jsonWriter.key("sequenceToken").value(putLogEventsRequest.getSequenceToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

