/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.regions;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonClientException;
import net.snowflake.client.jdbc.internal.amazonaws.ClientConfiguration;
import net.snowflake.client.jdbc.internal.amazonaws.regions.Region;
import net.snowflake.client.jdbc.internal.amazonaws.regions.RegionMetadata;
import net.snowflake.client.jdbc.internal.amazonaws.regions.RegionMetadataParser;
import net.snowflake.client.jdbc.internal.amazonaws.util.HttpUtils;
import net.snowflake.client.jdbc.internal.amazonaws.util.IOUtils;
import net.snowflake.client.jdbc.internal.apache.commons.logging.Log;
import net.snowflake.client.jdbc.internal.apache.commons.logging.LogFactory;

public class RegionUtils {
    private static final String REGIONS_FILE_OVERRIDE = "net.snowflake.client.jdbc.internal.amazonaws.regions.RegionUtils.fileOverride";
    private static final String BUNDLED_ENDPOINTS_RESOURCE_PATH = "/net/snowflake/client/jdbc/internal/amazonaws/regions/regions.xml";
    private static final String OVERRIDE_ENDPOINTS_RESOURCE_PATH = "/net/snowflake/client/jdbc/internal/amazonaws/regions/override/regions.xml";
    private static final Log log = LogFactory.getLog(RegionUtils.class);
    private static String source;
    private static volatile RegionMetadata regionMetadata;

    protected static String getSource() {
        return source;
    }

    public static RegionMetadata getRegionMetadata() {
        RegionMetadata rval = regionMetadata;
        if (rval != null) {
            return rval;
        }
        RegionUtils.initialize();
        return regionMetadata;
    }

    public static List<Region> getRegions() {
        return RegionUtils.getRegionMetadata().getRegions();
    }

    public static List<Region> getRegionsForService(String serviceAbbreviation) {
        return RegionUtils.getRegionMetadata().getRegionsForService(serviceAbbreviation);
    }

    public static Region getRegion(String regionName) {
        return RegionUtils.getRegionMetadata().getRegion(regionName);
    }

    public static Region getRegionByEndpoint(String endpoint) {
        return RegionUtils.getRegionMetadata().getRegionByEndpoint(endpoint);
    }

    public static RegionMetadata loadMetadataFromURI(URI uri) throws IOException {
        return RegionUtils.loadMetadataFromURI(uri, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegionMetadata loadMetadataFromURI(URI uri, ClientConfiguration config) throws IOException {
        InputStream stream = HttpUtils.fetchFile(uri, config);
        try {
            RegionMetadata regionMetadata = RegionUtils.loadMetadataFromInputStream(stream);
            return regionMetadata;
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegionMetadata loadMetadataFromFile(File file) throws IOException {
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
        try {
            RegionMetadata regionMetadata = RegionUtils.loadMetadataFromInputStream(stream);
            return regionMetadata;
        }
        finally {
            ((InputStream)stream).close();
        }
    }

    public static RegionMetadata loadMetadataFromResource(String name) throws IOException {
        return RegionUtils.loadMetadataFromResource(RegionUtils.class, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegionMetadata loadMetadataFromResource(Class<?> clazz, String name) throws IOException {
        InputStream stream = clazz.getResourceAsStream(name);
        if (stream == null) {
            throw new FileNotFoundException("No resource '" + name + "' found.");
        }
        try {
            RegionMetadata regionMetadata = RegionUtils.loadMetadataFromInputStream(stream);
            return regionMetadata;
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegionMetadata loadMetadataFromResource(ClassLoader classLoader, String name) throws IOException {
        InputStream stream = classLoader.getResourceAsStream(name);
        if (stream == null) {
            throw new FileNotFoundException("No resource '" + name + "' found.");
        }
        try {
            RegionMetadata regionMetadata = RegionUtils.loadMetadataFromInputStream(stream);
            return regionMetadata;
        }
        finally {
            stream.close();
        }
    }

    public static RegionMetadata loadMetadataFromInputStream(InputStream stream) throws IOException {
        return RegionMetadataParser.parse(stream);
    }

    @Deprecated
    public static void init() {
        RegionUtils.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initialize() {
        String overrideFilePath = System.getProperty(REGIONS_FILE_OVERRIDE);
        if (overrideFilePath != null) {
            RegionUtils.doInitializeFromFile(new File(overrideFilePath));
            source = overrideFilePath;
            return;
        }
        InputStream override = RegionUtils.class.getResourceAsStream(OVERRIDE_ENDPOINTS_RESOURCE_PATH);
        if (override != null) {
            try {
                RegionUtils.doInitializeFromInputStream(override);
                source = OVERRIDE_ENDPOINTS_RESOURCE_PATH;
                return;
            }
            finally {
                IOUtils.closeQuietly(override, log);
            }
        }
        RegionUtils.doInitializeFromResource(RegionUtils.class, BUNDLED_ENDPOINTS_RESOURCE_PATH);
        source = BUNDLED_ENDPOINTS_RESOURCE_PATH;
    }

    public static synchronized void initializeFromURI(URI uri) {
        RegionUtils.doInitializeFromURI(uri, null);
        source = uri.toASCIIString();
    }

    public static synchronized void initializeFromURI(URI uri, ClientConfiguration config) {
        RegionUtils.doInitializeFromURI(uri, config);
        source = uri.toASCIIString();
    }

    public static synchronized void initializeFromFile(File file) {
        RegionUtils.doInitializeFromFile(file);
        source = file.toString();
    }

    public static synchronized void initializeFromResource(String name) {
        RegionUtils.doInitializeFromResource(RegionUtils.class, name);
        source = name;
    }

    public static synchronized void initializeFromResource(Class<?> clazz, String name) {
        RegionUtils.doInitializeFromResource(clazz, name);
        source = name;
    }

    public static synchronized void initializeFromResource(ClassLoader classLoader, String name) {
        RegionUtils.doInitializeFromResource(classLoader, name);
        source = name;
    }

    public static void initializeWithMetadata(RegionMetadata metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("metadata cannot be null");
        }
        regionMetadata = metadata;
        source = "RegionUtils.initializeWithMetadata(RegionMetadata)";
    }

    private static void doInitializeFromURI(URI uri, ClientConfiguration config) {
        try {
            regionMetadata = RegionUtils.loadMetadataFromURI(uri, config);
        }
        catch (IOException exception) {
            throw new AmazonClientException("Error parsing region metadata from " + uri, exception);
        }
    }

    private static void doInitializeFromFile(File file) {
        try {
            regionMetadata = RegionUtils.loadMetadataFromFile(file);
        }
        catch (IOException exception) {
            throw new AmazonClientException("Error parsing region metadata from " + file, exception);
        }
    }

    private static void doInitializeFromResource(Class<?> clazz, String name) {
        try {
            regionMetadata = RegionUtils.loadMetadataFromResource(clazz, name);
        }
        catch (IOException exception) {
            throw new AmazonClientException("Error parsing region metadata from resource " + name, exception);
        }
    }

    private static void doInitializeFromResource(ClassLoader classLoader, String name) {
        try {
            regionMetadata = RegionUtils.loadMetadataFromResource(classLoader, name);
        }
        catch (IOException exception) {
            throw new AmazonClientException("Error parsing region metadata from resource " + name, exception);
        }
    }

    private static void doInitializeFromInputStream(InputStream stream) {
        try {
            regionMetadata = RegionUtils.loadMetadataFromInputStream(stream);
        }
        catch (IOException exception) {
            throw new AmazonClientException("Error parsing region metadata from input stream", exception);
        }
    }
}

