/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.http.conn;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.snowflake.client.jdbc.internal.amazonaws.http.conn.ClientConnectionRequestFactory;
import net.snowflake.client.jdbc.internal.amazonaws.http.conn.Wrapped;
import net.snowflake.client.jdbc.internal.apache.commons.logging.Log;
import net.snowflake.client.jdbc.internal.apache.commons.logging.LogFactory;
import net.snowflake.client.jdbc.internal.apache.http.conn.ClientConnectionManager;
import net.snowflake.client.jdbc.internal.apache.http.conn.ClientConnectionRequest;
import net.snowflake.client.jdbc.internal.apache.http.pool.ConnPoolControl;

public class ClientConnectionManagerFactory {
    private static final Log log = LogFactory.getLog(ClientConnectionManagerFactory.class);

    public static ClientConnectionManager wrap(ClientConnectionManager orig) {
        if (orig instanceof Wrapped) {
            throw new IllegalArgumentException();
        }
        Class[] interfaces = orig instanceof ConnPoolControl ? new Class[]{ClientConnectionManager.class, ConnPoolControl.class, Wrapped.class} : new Class[]{ClientConnectionManager.class, Wrapped.class};
        return (ClientConnectionManager)Proxy.newProxyInstance(ClientConnectionManagerFactory.class.getClassLoader(), interfaces, (InvocationHandler)new Handler(orig));
    }

    private static class Handler
    implements InvocationHandler {
        private final ClientConnectionManager orig;

        Handler(ClientConnectionManager real) {
            this.orig = real;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Object ret = method.invoke((Object)this.orig, args);
                return ret instanceof ClientConnectionRequest ? ClientConnectionRequestFactory.wrap((ClientConnectionRequest)ret) : ret;
            }
            catch (InvocationTargetException e) {
                log.debug("", e);
                throw e.getCause();
            }
        }
    }
}

