/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerationException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerator;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.BeanProperty;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JavaType;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonSerializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializerProvider;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsontype.TypeSerializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.ContainerSerializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.std.AsArraySerializerBase;

public class CollectionSerializer
extends AsArraySerializerBase<Collection<?>> {
    public CollectionSerializer(JavaType javaType, boolean bl, TypeSerializer typeSerializer, BeanProperty beanProperty, JsonSerializer<Object> jsonSerializer) {
        super(Collection.class, javaType, bl, typeSerializer, beanProperty, jsonSerializer);
    }

    public CollectionSerializer(CollectionSerializer collectionSerializer, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer) {
        super(collectionSerializer, beanProperty, typeSerializer, jsonSerializer);
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
        return new CollectionSerializer(this._elementType, this._staticTyping, typeSerializer, this._property, this._elementSerializer);
    }

    public CollectionSerializer withResolved(BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer) {
        return new CollectionSerializer(this, beanProperty, typeSerializer, jsonSerializer);
    }

    @Override
    public boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    @Override
    public boolean hasSingleElement(Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        iterator.next();
        return !iterator.hasNext();
    }

    @Override
    public void serializeContents(Collection<?> collection, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        if (this._elementSerializer != null) {
            this.serializeContentsUsing(collection, jsonGenerator, serializerProvider, this._elementSerializer);
            return;
        }
        Iterator<?> iterator = collection.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        PropertySerializerMap propertySerializerMap = this._dynamicSerializers;
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        int n = 0;
        try {
            do {
                Object obj;
                if ((obj = iterator.next()) == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                } else {
                    Class<?> clazz = obj.getClass();
                    JsonSerializer<Object> jsonSerializer = propertySerializerMap.serializerFor(clazz);
                    if (jsonSerializer == null) {
                        jsonSerializer = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(propertySerializerMap, serializerProvider.constructSpecializedType(this._elementType, clazz), serializerProvider) : this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
                        propertySerializerMap = this._dynamicSerializers;
                    }
                    if (typeSerializer == null) {
                        jsonSerializer.serialize(obj, jsonGenerator, serializerProvider);
                    } else {
                        jsonSerializer.serializeWithType(obj, jsonGenerator, serializerProvider, typeSerializer);
                    }
                }
                ++n;
            } while (iterator.hasNext());
        }
        catch (Exception exception) {
            this.wrapAndThrow(serializerProvider, (Throwable)exception, collection, n);
        }
    }

    public void serializeContentsUsing(Collection<?> collection, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, JsonSerializer<Object> jsonSerializer) throws IOException, JsonGenerationException {
        Iterator<?> iterator = collection.iterator();
        if (iterator.hasNext()) {
            TypeSerializer typeSerializer = this._valueTypeSerializer;
            int n = 0;
            do {
                Object obj = iterator.next();
                try {
                    if (obj == null) {
                        serializerProvider.defaultSerializeNull(jsonGenerator);
                    } else if (typeSerializer == null) {
                        jsonSerializer.serialize(obj, jsonGenerator, serializerProvider);
                    } else {
                        jsonSerializer.serializeWithType(obj, jsonGenerator, serializerProvider, typeSerializer);
                    }
                    ++n;
                }
                catch (Exception exception) {
                    this.wrapAndThrow(serializerProvider, (Throwable)exception, collection, n);
                }
            } while (iterator.hasNext());
        }
    }
}

