/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.util.UUID;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerationException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerator;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializerProvider;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.TokenBuffer;

public class UUIDSerializer
extends StdScalarSerializer<UUID> {
    static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    public UUIDSerializer() {
        super(UUID.class);
    }

    @Override
    public boolean isEmpty(UUID uUID) {
        if (uUID == null) {
            return true;
        }
        return uUID.getLeastSignificantBits() == 0L && uUID.getMostSignificantBits() == 0L;
    }

    @Override
    public void serialize(UUID uUID, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        if (jsonGenerator.canWriteBinaryNatively() && !(jsonGenerator instanceof TokenBuffer)) {
            jsonGenerator.writeBinary(UUIDSerializer._asBytes(uUID));
            return;
        }
        char[] cArray = new char[36];
        long l = uUID.getMostSignificantBits();
        UUIDSerializer._appendInt((int)(l >> 32), cArray, 0);
        cArray[8] = 45;
        int n = (int)l;
        UUIDSerializer._appendShort(n >>> 16, cArray, 9);
        cArray[13] = 45;
        UUIDSerializer._appendShort(n, cArray, 14);
        cArray[18] = 45;
        long l2 = uUID.getLeastSignificantBits();
        UUIDSerializer._appendShort((int)(l2 >>> 48), cArray, 19);
        cArray[23] = 45;
        UUIDSerializer._appendShort((int)(l2 >>> 32), cArray, 24);
        UUIDSerializer._appendInt((int)l2, cArray, 28);
        jsonGenerator.writeString(cArray, 0, 36);
    }

    private static void _appendInt(int n, char[] cArray, int n2) {
        UUIDSerializer._appendShort(n >> 16, cArray, n2);
        UUIDSerializer._appendShort(n, cArray, n2 + 4);
    }

    private static void _appendShort(int n, char[] cArray, int n2) {
        cArray[n2] = HEX_CHARS[n >> 12 & 0xF];
        cArray[++n2] = HEX_CHARS[n >> 8 & 0xF];
        cArray[++n2] = HEX_CHARS[n >> 4 & 0xF];
        cArray[++n2] = HEX_CHARS[n & 0xF];
    }

    private static final byte[] _asBytes(UUID uUID) {
        byte[] byArray = new byte[16];
        long l = uUID.getMostSignificantBits();
        long l2 = uUID.getLeastSignificantBits();
        UUIDSerializer._appendInt((int)(l >> 32), byArray, 0);
        UUIDSerializer._appendInt((int)l, byArray, 4);
        UUIDSerializer._appendInt((int)(l2 >> 32), byArray, 8);
        UUIDSerializer._appendInt((int)l2, byArray, 12);
        return byArray;
    }

    private static final void _appendInt(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >> 24);
        byArray[++n2] = (byte)(n >> 16);
        byArray[++n2] = (byte)(n >> 8);
        byArray[++n2] = (byte)n;
    }
}

