/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.annotation.JsonInclude;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.AnnotationIntrospector;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.BeanDescription;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JavaType;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonMappingException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonSerializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializationConfig;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializationFeature;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializerProvider;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.annotation.JsonSerialize;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.Annotated;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.AnnotatedMember;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsontype.TypeSerializer;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.Annotations;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.ArrayBuilders;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.NameTransformer;

public class PropertyBuilder {
    protected final SerializationConfig _config;
    protected final BeanDescription _beanDesc;
    protected final JsonInclude.Include _outputProps;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected Object _defaultBean;

    public PropertyBuilder(SerializationConfig serializationConfig, BeanDescription beanDescription) {
        this._config = serializationConfig;
        this._beanDesc = beanDescription;
        this._outputProps = beanDescription.findSerializationInclusion(serializationConfig.getSerializationInclusion());
        this._annotationIntrospector = this._config.getAnnotationIntrospector();
    }

    public Annotations getClassAnnotations() {
        return this._beanDesc.getClassAnnotations();
    }

    @Deprecated
    protected final BeanPropertyWriter buildWriter(BeanPropertyDefinition beanPropertyDefinition, JavaType javaType, JsonSerializer<?> jsonSerializer, TypeSerializer typeSerializer, TypeSerializer typeSerializer2, AnnotatedMember annotatedMember, boolean bl) {
        throw new IllegalStateException();
    }

    protected BeanPropertyWriter buildWriter(SerializerProvider serializerProvider, BeanPropertyDefinition beanPropertyDefinition, JavaType javaType, JsonSerializer<?> jsonSerializer, TypeSerializer typeSerializer, TypeSerializer typeSerializer2, AnnotatedMember annotatedMember, boolean bl) throws JsonMappingException {
        NameTransformer nameTransformer;
        Object object;
        JavaType javaType2 = this.findSerializationType(annotatedMember, bl, javaType);
        if (typeSerializer2 != null) {
            if (javaType2 == null) {
                javaType2 = javaType;
            }
            if ((object = javaType2.getContentType()) == null) {
                throw new IllegalStateException("Problem trying to create BeanPropertyWriter for property '" + beanPropertyDefinition.getName() + "' (of type " + this._beanDesc.getType() + "); serialization type " + javaType2 + " has no content");
            }
            javaType2 = javaType2.withContentTypeHandler(typeSerializer2);
            object = javaType2.getContentType();
        }
        object = null;
        boolean bl2 = false;
        JsonInclude.Include include = this._annotationIntrospector.findSerializationInclusion(annotatedMember, this._outputProps);
        if (include != null) {
            switch (include) {
                case NON_DEFAULT: {
                    object = this.getDefaultValue(beanPropertyDefinition.getName(), annotatedMember);
                    if (object == null) {
                        bl2 = true;
                        break;
                    }
                    if (!object.getClass().isArray()) break;
                    object = ArrayBuilders.getArrayComparator(object);
                    break;
                }
                case NON_EMPTY: {
                    bl2 = true;
                    object = BeanPropertyWriter.MARKER_FOR_EMPTY;
                    break;
                }
                case NON_NULL: {
                    bl2 = true;
                }
                case ALWAYS: {
                    if (!javaType.isContainerType() || this._config.isEnabled(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS)) break;
                    object = BeanPropertyWriter.MARKER_FOR_EMPTY;
                }
            }
        }
        BeanPropertyWriter beanPropertyWriter = new BeanPropertyWriter(beanPropertyDefinition, annotatedMember, this._beanDesc.getClassAnnotations(), javaType, jsonSerializer, typeSerializer, javaType2, bl2, object);
        Object object2 = this._annotationIntrospector.findNullSerializer(annotatedMember);
        if (object2 != null) {
            beanPropertyWriter.assignNullSerializer(serializerProvider.serializerInstance(annotatedMember, object2));
        }
        if ((nameTransformer = this._annotationIntrospector.findUnwrappingNameTransformer(annotatedMember)) != null) {
            beanPropertyWriter = beanPropertyWriter.unwrappingWriter(nameTransformer);
        }
        return beanPropertyWriter;
    }

    protected JavaType findSerializationType(Annotated annotated, boolean bl, JavaType type) {
        JsonSerialize.Typing typing;
        Type type2;
        Class<?> clazz = this._annotationIntrospector.findSerializationType(annotated);
        if (clazz != null) {
            type2 = type.getRawClass();
            if (clazz.isAssignableFrom((Class<?>)type2)) {
                type = type.widenBy(clazz);
            } else {
                if (!((Class)type2).isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException("Illegal concrete-type annotation for method '" + annotated.getName() + "': class " + clazz.getName() + " not a super-type of (declared) class " + ((Class)type2).getName());
                }
                type = this._config.constructSpecializedType((JavaType)type, clazz);
            }
            bl = true;
        }
        if ((type2 = BeanSerializerFactory.modifySecondaryTypesByAnnotation(this._config, annotated, type)) != type) {
            bl = true;
            type = type2;
        }
        if ((typing = this._annotationIntrospector.findSerializationTyping(annotated)) != null && typing != JsonSerialize.Typing.DEFAULT_TYPING) {
            bl = typing == JsonSerialize.Typing.STATIC;
        }
        return bl ? type : null;
    }

    protected Object getDefaultBean() {
        if (this._defaultBean == null) {
            this._defaultBean = this._beanDesc.instantiateBean(this._config.canOverrideAccessModifiers());
            if (this._defaultBean == null) {
                AnnotatedElement annotatedElement = this._beanDesc.getClassInfo().getAnnotated();
                throw new IllegalArgumentException("Class " + ((Class)annotatedElement).getName() + " has no default constructor; can not instantiate default bean value to support 'properties=JsonSerialize.Inclusion.NON_DEFAULT' annotation");
            }
        }
        return this._defaultBean;
    }

    protected Object getDefaultValue(String string, AnnotatedMember annotatedMember) {
        Object object = this.getDefaultBean();
        try {
            return annotatedMember.getValue(object);
        }
        catch (Exception exception) {
            return this._throwWrapped(exception, string, object);
        }
    }

    protected Object _throwWrapped(Exception exception, String string, Object object) {
        Throwable throwable = exception;
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new IllegalArgumentException("Failed to get property '" + string + "' of default " + object.getClass().getName() + " instance");
    }
}

