/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.snowflake.gscommon.core.ResourceBundleManager;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.ErrorCode;

public class SFException
extends Throwable {
    static final Logger logger = Logger.getLogger(SFException.class.getName());
    static final ResourceBundleManager errorResourceBundleManager = ResourceBundleManager.getSingleton("com.snowflake.common_error_messages");
    private Throwable cause = null;
    private String queryId = null;
    private String sqlState;
    private int vendorCode;
    private Object[] params;

    public SFException(ErrorCode errorCode, Object ... params) {
        super(errorResourceBundleManager.getLocalizedMessage(String.valueOf(errorCode.getMessageCode()), params));
        this.sqlState = errorCode.getSqlState();
        this.vendorCode = errorCode.getMessageCode();
        this.params = params;
    }

    public SFException(Throwable cause, ErrorCode errorCode, Object ... params) {
        super(errorResourceBundleManager.getLocalizedMessage(String.valueOf(errorCode.getMessageCode()), params), cause);
        this.sqlState = errorCode.getSqlState();
        this.vendorCode = errorCode.getMessageCode();
        this.params = params;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getSqlState() {
        return this.sqlState;
    }

    public int getVendorCode() {
        return this.vendorCode;
    }

    public Object[] getParams() {
        return this.params;
    }

    @Override
    public String toString() {
        return super.toString() + (this.getQueryId() != null ? ", query id = " + this.getQueryId() : "") + (this.getSqlState() != null ? ", sql state = " + this.getSqlState() : "");
    }
}

