/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.snowflake.gscommon.core.SFBinary;
import com.snowflake.gscommon.core.SFBinaryFormat;
import com.snowflake.gscommon.core.SFTime;
import com.snowflake.gscommon.core.SFTimestamp;
import com.snowflake.gscommon.core.SnowflakeDateTimeFormat;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFResultSetMetaData;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;

public abstract class SFBaseResultSet {
    static final Logger logger = Logger.getLogger(SFBaseResultSet.class.getName());
    protected boolean wasNull = false;
    protected Object[] nextRow = null;
    protected SFResultSetMetaData resultSetMetaData = null;
    protected int row = 0;
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    protected TimeZone timeZone;
    private static TimeZone timeZoneUTC = TimeZone.getTimeZone("UTC");
    protected SnowflakeDateTimeFormat timestampNTZFormatter;
    protected SnowflakeDateTimeFormat timestampLTZFormatter;
    protected SnowflakeDateTimeFormat timestampTZFormatter;
    protected SnowflakeDateTimeFormat dateFormatter;
    protected SnowflakeDateTimeFormat timeFormatter;
    protected boolean honorClientTZForTimestampNTZ = true;
    protected SFBinaryFormat binaryFormatter;
    protected long resultVersion = 0L;
    protected int numberOfBinds = 0;
    protected SFSession session;
    protected boolean isClosed = true;

    public void setSession(SFSession session) {
        this.session = session;
    }

    public boolean next() throws SFException, SnowflakeSQLException {
        logger.log(Level.FINER, "public boolean next()");
        return false;
    }

    public void close() {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Time: " + System.currentTimeMillis() + " public void close()");
        }
        this.resultSetMetaData = null;
        this.isClosed = true;
    }

    public boolean wasNull() {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "public boolean wasNull() returning " + this.wasNull);
        }
        return this.wasNull;
    }

    public String getString(int columnIndex) throws SFException {
        logger.log(Level.FINER, "public String getString(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        int columnType = this.resultSetMetaData.getInternalColumnType(columnIndex);
        switch (columnType) {
            case 16: {
                return ResultUtil.getBooleanAsString(ResultUtil.getBoolean(obj.toString()));
            }
            case 93: 
            case 50000: 
            case 50001: {
                SFTimestamp sfTS = this.getSFTimestamp(columnIndex);
                int columnScale = this.resultSetMetaData.getScale(columnIndex);
                String timestampStr = ResultUtil.getSFTimestampAsString(sfTS, columnType, columnScale, this.timestampNTZFormatter, this.timestampLTZFormatter, this.timestampTZFormatter, this.session);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Converting timestamp to string from: " + obj.toString() + " to: " + timestampStr);
                }
                return timestampStr;
            }
            case 91: {
                Date date = this.getDate(columnIndex, timeZoneUTC);
                if (this.dateFormatter == null) {
                    throw IncidentUtil.generateIncidentWithException(this.session, null, null, ErrorCode.INTERNAL_ERROR, "missing date formatter");
                }
                String dateStr = ResultUtil.getDateAsString(date, this.dateFormatter);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Converting date to string from: " + obj.toString() + " to: " + dateStr);
                }
                return dateStr;
            }
            case 92: {
                SFTime sfTime = this.getSFTime(columnIndex);
                if (this.timeFormatter == null) {
                    throw IncidentUtil.generateIncidentWithException(this.session, null, null, ErrorCode.INTERNAL_ERROR, "missing time formatter");
                }
                int scale = this.resultSetMetaData.getScale(columnIndex);
                String timeStr = ResultUtil.getSFTimeAsString(sfTime, scale, this.timeFormatter);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Converting time to string from: " + obj.toString() + " to: " + timeStr);
                }
                return timeStr;
            }
            case -2: {
                if (this.binaryFormatter == null) {
                    throw IncidentUtil.generateIncidentWithException(this.session, null, null, ErrorCode.INTERNAL_ERROR, "missing binary formatter");
                }
                if (this.binaryFormatter == SFBinaryFormat.HEX) {
                    return obj.toString();
                }
                SFBinary sfb = new SFBinary(this.getBytes(columnIndex));
                return this.binaryFormatter.format(sfb);
            }
        }
        return obj.toString();
    }

    public boolean getBoolean(int columnIndex) throws SFException {
        logger.log(Level.FINER, "public boolean getBoolean(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return ResultUtil.getBoolean(obj.toString());
    }

    public short getShort(int columnIndex) throws SFException {
        logger.log(Level.FINER, "public short getShort(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            return Short.parseShort((String)obj);
        }
        return ((Number)obj).shortValue();
    }

    public int getInt(int columnIndex) throws SFException {
        logger.log(Level.FINER, "public int getInt(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            return Integer.parseInt((String)obj);
        }
        return ((Number)obj).intValue();
    }

    public long getLong(int columnIndex) throws SFException {
        logger.log(Level.FINER, "public long getLong(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0L;
        }
        try {
            if (obj instanceof String) {
                return Long.parseLong((String)obj);
            }
            return ((Number)obj).longValue();
        }
        catch (NumberFormatException nfe) {
            int columnType = this.resultSetMetaData.getInternalColumnType(columnIndex);
            if (4 == columnType || 5 == columnType) {
                SFException sfe = new SFException(ErrorCode.INTERNAL_ERROR, "Invalid long: " + obj.toString());
                IncidentUtil.generateIncident(this.session, "Unable to Convert to Long", null, null, null, sfe);
                throw sfe;
            }
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "LONG", obj);
        }
    }

    public float getFloat(int columnIndex) throws SFException {
        logger.log(Level.FINER, "public float getFloat(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0.0f;
        }
        if (obj instanceof String) {
            return Float.parseFloat((String)obj);
        }
        return ((Number)obj).floatValue();
    }

    public double getDouble(int columnIndex) throws SFException {
        logger.log(Level.FINER, "public double getDouble(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof String) {
            return Double.parseDouble((String)obj);
        }
        return ((Number)obj).doubleValue();
    }

    public byte[] getBytes(int columnIndex) throws SFException {
        logger.log(Level.FINER, "public byte[] getBytes(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        try {
            return SFBinary.fromHex(obj.toString()).getBytes();
        }
        catch (IllegalArgumentException ex) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, "Invalid binary value: " + obj.toString());
        }
    }

    public Date getDate(int columnIndex, TimeZone tz) throws SFException {
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        logger.log(Level.FINER, "public Date getDate(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        int columnType = this.resultSetMetaData.getInternalColumnType(columnIndex);
        if (91 != columnType) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "DATE", obj);
        }
        if (obj == null) {
            return null;
        }
        return ResultUtil.getDate(obj.toString(), tz, this.session);
    }

    public Date getDate(int columnIndex) throws SFException {
        return this.getDate(columnIndex, TimeZone.getDefault());
    }

    public Time getTime(int columnIndex) throws SFException {
        logger.log(Level.FINER, "public Time getTime(int columnIndex)");
        SFTime sfTime = this.getSFTime(columnIndex);
        if (sfTime == null) {
            return null;
        }
        return new Time(sfTime.getFractionalSeconds(3));
    }

    private SFTime getSFTime(int columnIndex) throws SFException {
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        int scale = this.resultSetMetaData.getScale(columnIndex);
        return ResultUtil.getSFTime(obj.toString(), scale, this.session);
    }

    private Timestamp getTimestamp(int columnIndex) throws SFException {
        return this.getTimestamp(columnIndex, TimeZone.getDefault());
    }

    public Timestamp getTimestamp(int columnIndex, TimeZone tz) throws SFException {
        SFTimestamp sfTS = this.getSFTimestamp(columnIndex);
        if (sfTS == null) {
            return null;
        }
        Timestamp res = sfTS.getTimestamp();
        if (res == null) {
            return null;
        }
        if (this.honorClientTZForTimestampNTZ && this.resultSetMetaData.getInternalColumnType(columnIndex) == 93) {
            return sfTS.moveToTimeZone(tz).getTimestamp();
        }
        return res;
    }

    private SFTimestamp getSFTimestamp(int columnIndex) throws SFException {
        logger.log(Level.FINER, "public Timestamp getTimestamp(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        return ResultUtil.getSFTimestamp(obj.toString(), this.resultSetMetaData.getScale(columnIndex), this.resultSetMetaData.getInternalColumnType(columnIndex), this.resultVersion, this.timeZone, this.session);
    }

    public SFResultSetMetaData getMetaData() throws SFException {
        logger.log(Level.FINER, "public ResultSetMetaData getMetaData()");
        return this.resultSetMetaData;
    }

    protected abstract Object getObjectInternal(int var1) throws SFException;

    public Object getObject(int columnIndex) throws SFException {
        logger.log(Level.FINER, "public Object getObject(int columnIndex)");
        int type = this.resultSetMetaData.getColumnType(columnIndex);
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        switch (type) {
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case -2: {
                return this.getBytes(columnIndex);
            }
            case 4: {
                return this.getInt(columnIndex);
            }
            case 3: {
                return this.getBigDecimal(columnIndex);
            }
            case 8: {
                return this.getDouble(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 16: {
                return this.getBoolean(columnIndex);
            }
        }
        throw IncidentUtil.generateIncidentWithException(this.session, null, null, ErrorCode.FEATURE_UNSUPPORTED, "data type: " + type);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SFException {
        logger.log(Level.FINER, "public BigDecimal getBigDecimal(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        return new BigDecimal(obj.toString());
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SFException {
        logger.log(Level.FINER, "public BigDecimal getBigDecimal(int columnIndex)");
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        BigDecimal value = new BigDecimal(obj.toString());
        value = value.setScale(scale, RoundingMode.HALF_UP);
        return value;
    }

    public int getRow() throws SQLException {
        logger.log(Level.FINER, "public int getRow()");
        return this.row;
    }

    public boolean absolute(int row) throws SFException {
        logger.log(Level.FINER, "public boolean absolute(int row)");
        throw new SFException(ErrorCode.FEATURE_UNSUPPORTED, "seek to a specific row");
    }

    public boolean relative(int rows) throws SFException {
        logger.log(Level.FINER, "public boolean relative(int rows)");
        throw new SFException(ErrorCode.FEATURE_UNSUPPORTED, "seek to a row relative to current row");
    }

    public boolean previous() throws SFException {
        logger.log(Level.FINER, "public boolean previous()");
        throw new SFException(ErrorCode.FEATURE_UNSUPPORTED, "seek to a previous row");
    }

    protected int getNumberOfBinds() {
        return this.numberOfBinds;
    }

    public boolean isFirst() {
        logger.log(Level.FINER, "public boolean isFirst()");
        return this.row == 1;
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

