/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.snowflake.gscommon.core.SFBinary;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;

public enum SnowflakeType {
    TEXT,
    CHAR,
    INTEGER,
    FIXED,
    REAL,
    TIMESTAMP,
    TIMESTAMP_LTZ,
    TIMESTAMP_NTZ,
    TIMESTAMP_TZ,
    DATE,
    TIME,
    BOOLEAN,
    ARRAY,
    OBJECT,
    VARIANT,
    BINARY,
    ANY;

    static final SimpleDateFormat sdf;

    public static SnowflakeType fromString(String name) {
        return SnowflakeType.valueOf(name.toUpperCase());
    }

    public static JavaDataType getJavaType(SnowflakeType type) {
        switch (type) {
            case TEXT: {
                return JavaDataType.JAVA_STRING;
            }
            case CHAR: {
                return JavaDataType.JAVA_STRING;
            }
            case INTEGER: {
                return JavaDataType.JAVA_LONG;
            }
            case FIXED: {
                return JavaDataType.JAVA_BIGDECIMAL;
            }
            case REAL: {
                return JavaDataType.JAVA_DOUBLE;
            }
            case TIMESTAMP: 
            case TIME: 
            case TIMESTAMP_LTZ: 
            case TIMESTAMP_NTZ: 
            case TIMESTAMP_TZ: 
            case DATE: {
                return JavaDataType.JAVA_TIMESTAMP;
            }
            case BOOLEAN: {
                return JavaDataType.JAVA_BOOLEAN;
            }
            case ARRAY: 
            case VARIANT: {
                return JavaDataType.JAVA_STRING;
            }
            case OBJECT: {
                return JavaDataType.JAVA_STRING;
            }
            case BINARY: {
                return JavaDataType.JAVA_BYTES;
            }
            case ANY: {
                return JavaDataType.JAVA_OBJECT;
            }
        }
        return JavaDataType.JAVA_STRING;
    }

    public static String lexicalValue(Object o) {
        if (o == null) {
            return "";
        }
        Class<?> c = o.getClass();
        if (c == Timestamp.class) {
            return sdf.format((Timestamp)o);
        }
        if (c == Date.class) {
            return sdf.format((Date)o);
        }
        if (c == Time.class) {
            return sdf.format((Time)o);
        }
        if (c == Double.class) {
            return Double.toHexString((Double)o);
        }
        if (c == Float.class) {
            return Float.toHexString(((Float)o).floatValue());
        }
        if (c == Integer.class) {
            return o.toString();
        }
        if (c == BigDecimal.class) {
            return o.toString();
        }
        if (c == byte[].class) {
            return new SFBinary((byte[])o).toHex();
        }
        String value = String.valueOf(o);
        return value;
    }

    public static String escapeForCSV(String value) {
        if (value.indexOf(34) >= 0 || value.indexOf(10) >= 0 || value.indexOf(44) >= 0 || value.indexOf(92) >= 0) {
            return '\"' + value.replaceAll("\"", "\"\"") + '\"';
        }
        return value;
    }

    public static SnowflakeType javaTypeToSFType(int javaType) throws SnowflakeSQLException {
        switch (javaType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return FIXED;
            }
            case 1: 
            case 12: {
                return TEXT;
            }
            case -2: {
                return BINARY;
            }
            case 6: 
            case 8: {
                return REAL;
            }
            case 91: {
                return DATE;
            }
            case 92: {
                return TIME;
            }
            case 93: {
                return TIMESTAMP;
            }
            case 16: {
                return BOOLEAN;
            }
            case 0: {
                return ANY;
            }
        }
        throw new SnowflakeSQLException("0A000", ErrorCode.DATA_TYPE_NOT_SUPPORTED.getMessageCode(), javaType);
    }

    static {
        sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public static enum JavaDataType {
        JAVA_STRING(String.class),
        JAVA_LONG(Long.class),
        JAVA_DOUBLE(Double.class),
        JAVA_BIGDECIMAL(BigDecimal.class),
        JAVA_TIMESTAMP(Timestamp.class),
        JAVA_BYTES(byte[].class),
        JAVA_BOOLEAN(Boolean.class),
        JAVA_OBJECT(Object.class);

        private Class _class;

        private JavaDataType(Class c) {
            this._class = c;
        }

        public Class getClazz() {
            return this._class;
        }

        public String lexicalValue(Object o) {
            if (o == null) {
                return "";
            }
            switch (this) {
                case JAVA_STRING: 
                case JAVA_BIGDECIMAL: {
                    return (String)o;
                }
                case JAVA_LONG: {
                    return Long.toString((Long)o);
                }
                case JAVA_DOUBLE: {
                    return Double.toHexString((Double)o);
                }
                case JAVA_TIMESTAMP: {
                    return sdf.format((Timestamp)o);
                }
                case JAVA_BYTES: {
                    return new SFBinary((byte[])o).toHex();
                }
                case JAVA_BOOLEAN: {
                    return Boolean.toString((Boolean)o);
                }
                case JAVA_OBJECT: {
                    return o.toString();
                }
            }
            throw new RuntimeException("Invalid method");
        }
    }
}

