/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.std;

import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerator;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.BeanProperty;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JavaType;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonMappingException;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonSerializer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializerProvider;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.Converter;
import java.io.IOException;
import java.lang.reflect.Type;

public class StdDelegatingSerializer
extends StdSerializer<Object>
implements ContextualSerializer,
ResolvableSerializer,
JsonFormatVisitable,
SchemaAware {
    protected final Converter<Object, ?> _converter;
    protected final JavaType _delegateType;
    protected final JsonSerializer<Object> _delegateSerializer;

    public StdDelegatingSerializer(Converter<?, ?> converter) {
        super(Object.class);
        this._converter = converter;
        this._delegateType = null;
        this._delegateSerializer = null;
    }

    public <T> StdDelegatingSerializer(Class<T> clazz, Converter<T, ?> converter) {
        super(clazz, false);
        this._converter = converter;
        this._delegateType = null;
        this._delegateSerializer = null;
    }

    public StdDelegatingSerializer(Converter<Object, ?> converter, JavaType javaType, JsonSerializer<?> jsonSerializer) {
        super(javaType);
        this._converter = converter;
        this._delegateType = javaType;
        this._delegateSerializer = jsonSerializer;
    }

    protected StdDelegatingSerializer withDelegate(Converter<Object, ?> converter, JavaType javaType, JsonSerializer<?> jsonSerializer) {
        if (this.getClass() != StdDelegatingSerializer.class) {
            throw new IllegalStateException("Sub-class " + this.getClass().getName() + " must override 'withDelegate'");
        }
        return new StdDelegatingSerializer(converter, javaType, jsonSerializer);
    }

    @Override
    public void resolve(SerializerProvider serializerProvider) throws JsonMappingException {
        if (this._delegateSerializer != null && this._delegateSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)this._delegateSerializer)).resolve(serializerProvider);
        }
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        if (this._delegateSerializer != null) {
            if (this._delegateSerializer instanceof ContextualSerializer) {
                JsonSerializer<?> jsonSerializer = serializerProvider.handleSecondaryContextualization(this._delegateSerializer, beanProperty);
                if (jsonSerializer == this._delegateSerializer) {
                    return this;
                }
                return this.withDelegate(this._converter, this._delegateType, jsonSerializer);
            }
            return this;
        }
        JavaType javaType = this._delegateType;
        if (javaType == null) {
            javaType = this._converter.getOutputType(serializerProvider.getTypeFactory());
        }
        return this.withDelegate(this._converter, javaType, serializerProvider.findValueSerializer(javaType, beanProperty));
    }

    protected Converter<Object, ?> getConverter() {
        return this._converter;
    }

    @Override
    public JsonSerializer<?> getDelegatee() {
        return this._delegateSerializer;
    }

    @Override
    public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        Object object2 = this.convertValue(object);
        if (object2 == null) {
            serializerProvider.defaultSerializeNull(jsonGenerator);
            return;
        }
        this._delegateSerializer.serialize(object2, jsonGenerator, serializerProvider);
    }

    @Override
    public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
        Object object2 = this.convertValue(object);
        this._delegateSerializer.serializeWithType(object2, jsonGenerator, serializerProvider, typeSerializer);
    }

    @Override
    public boolean isEmpty(Object object) {
        Object object2 = this.convertValue(object);
        return this._delegateSerializer.isEmpty(object2);
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) throws JsonMappingException {
        if (this._delegateSerializer instanceof SchemaAware) {
            return ((SchemaAware)((Object)this._delegateSerializer)).getSchema(serializerProvider, type);
        }
        return super.getSchema(serializerProvider, type);
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type, boolean bl) throws JsonMappingException {
        if (this._delegateSerializer instanceof SchemaAware) {
            return ((SchemaAware)((Object)this._delegateSerializer)).getSchema(serializerProvider, type, bl);
        }
        return super.getSchema(serializerProvider, type);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        this._delegateSerializer.acceptJsonFormatVisitor(jsonFormatVisitorWrapper, javaType);
    }

    protected Object convertValue(Object object) {
        return this._converter.convert(object);
    }
}

