/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.impl;

import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerator;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.io.SerializedString;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.BeanProperty;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JavaType;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonMappingException;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonSerializer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializerProvider;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ObjectNode;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.impl.UnwrappingBeanSerializer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.NameTransformer;
import java.util.Iterator;
import java.util.Map;

public class UnwrappingBeanPropertyWriter
extends BeanPropertyWriter {
    protected final NameTransformer _nameTransformer;

    public UnwrappingBeanPropertyWriter(BeanPropertyWriter beanPropertyWriter, NameTransformer nameTransformer) {
        super(beanPropertyWriter);
        this._nameTransformer = nameTransformer;
    }

    private UnwrappingBeanPropertyWriter(UnwrappingBeanPropertyWriter unwrappingBeanPropertyWriter, NameTransformer nameTransformer, SerializedString serializedString) {
        super(unwrappingBeanPropertyWriter, serializedString);
        this._nameTransformer = nameTransformer;
    }

    @Override
    public UnwrappingBeanPropertyWriter rename(NameTransformer nameTransformer) {
        String string = this._name.getValue();
        String string2 = nameTransformer.transform(string);
        nameTransformer = NameTransformer.chainedTransformer(nameTransformer, this._nameTransformer);
        return new UnwrappingBeanPropertyWriter(this, nameTransformer, new SerializedString(string2));
    }

    @Override
    public boolean isUnwrapping() {
        return true;
    }

    @Override
    public void serializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
        Class<?> clazz;
        PropertySerializerMap propertySerializerMap;
        Object object2 = this.get(object);
        if (object2 == null) {
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._serializer;
        if (jsonSerializer == null && (jsonSerializer = (propertySerializerMap = this._dynamicSerializers).serializerFor(clazz = object2.getClass())) == null) {
            jsonSerializer = this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
        }
        if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? jsonSerializer.isEmpty(object2) : this._suppressableValue.equals(object2))) {
            return;
        }
        if (object2 == object) {
            this._handleSelfReference(object, jsonSerializer);
        }
        if (!jsonSerializer.isUnwrappingSerializer()) {
            jsonGenerator.writeFieldName(this._name);
        }
        if (this._typeSerializer == null) {
            jsonSerializer.serialize(object2, jsonGenerator, serializerProvider);
        } else {
            jsonSerializer.serializeWithType(object2, jsonGenerator, serializerProvider, this._typeSerializer);
        }
    }

    @Override
    public void assignSerializer(JsonSerializer<Object> jsonSerializer) {
        super.assignSerializer(jsonSerializer);
        if (this._serializer != null) {
            NameTransformer nameTransformer = this._nameTransformer;
            if (this._serializer.isUnwrappingSerializer()) {
                nameTransformer = NameTransformer.chainedTransformer(nameTransformer, ((UnwrappingBeanSerializer)this._serializer)._nameTransformer);
            }
            this._serializer = this._serializer.unwrappingSerializer(nameTransformer);
        }
    }

    @Override
    protected void _depositSchemaProperty(ObjectNode objectNode, JsonNode jsonNode) {
        JsonNode jsonNode2 = jsonNode.get("properties");
        if (jsonNode2 != null) {
            Iterator<Map.Entry<String, JsonNode>> iterator = jsonNode2.fields();
            while (iterator.hasNext()) {
                Map.Entry<String, JsonNode> entry = iterator.next();
                String string = entry.getKey();
                if (this._nameTransformer != null) {
                    string = this._nameTransformer.transform(string);
                }
                objectNode.put(string, entry.getValue());
            }
        }
    }

    @Override
    protected JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap propertySerializerMap, Class<?> clazz, SerializerProvider serializerProvider) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer;
        Object object;
        if (this._nonTrivialBaseType != null) {
            object = serializerProvider.constructSpecializedType(this._nonTrivialBaseType, clazz);
            jsonSerializer = serializerProvider.findValueSerializer((JavaType)object, (BeanProperty)this);
        } else {
            jsonSerializer = serializerProvider.findValueSerializer(clazz, (BeanProperty)this);
        }
        object = this._nameTransformer;
        if (jsonSerializer.isUnwrappingSerializer()) {
            object = NameTransformer.chainedTransformer((NameTransformer)object, ((UnwrappingBeanSerializer)jsonSerializer)._nameTransformer);
        }
        jsonSerializer = jsonSerializer.unwrappingSerializer((NameTransformer)object);
        this._dynamicSerializers = this._dynamicSerializers.newWith(clazz, jsonSerializer);
        return jsonSerializer;
    }
}

