/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser;

import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JavaType;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonMappingException;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonSerializer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializerProvider;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.impl.ReadOnlyClassToSerializerMap;
import java.util.HashMap;

public final class SerializerCache {
    private HashMap<TypeKey, JsonSerializer<Object>> _sharedMap = new HashMap(64);
    private volatile ReadOnlyClassToSerializerMap _readOnlyMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadOnlyClassToSerializerMap getReadOnlyLookupMap() {
        ReadOnlyClassToSerializerMap readOnlyClassToSerializerMap = this._readOnlyMap;
        if (readOnlyClassToSerializerMap == null) {
            SerializerCache serializerCache = this;
            synchronized (serializerCache) {
                readOnlyClassToSerializerMap = this._readOnlyMap;
                if (readOnlyClassToSerializerMap == null) {
                    this._readOnlyMap = readOnlyClassToSerializerMap = ReadOnlyClassToSerializerMap.from(this._sharedMap);
                }
            }
        }
        return readOnlyClassToSerializerMap.instance();
    }

    public synchronized int size() {
        return this._sharedMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonSerializer<Object> untypedValueSerializer(Class<?> clazz) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            return this._sharedMap.get(new TypeKey(clazz, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonSerializer<Object> untypedValueSerializer(JavaType javaType) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            return this._sharedMap.get(new TypeKey(javaType, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonSerializer<Object> typedValueSerializer(JavaType javaType) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            return this._sharedMap.get(new TypeKey(javaType, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonSerializer<Object> typedValueSerializer(Class<?> clazz) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            return this._sharedMap.get(new TypeKey(clazz, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTypedSerializer(JavaType javaType, JsonSerializer<Object> jsonSerializer) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            if (this._sharedMap.put(new TypeKey(javaType, true), jsonSerializer) == null) {
                this._readOnlyMap = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTypedSerializer(Class<?> clazz, JsonSerializer<Object> jsonSerializer) {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            if (this._sharedMap.put(new TypeKey(clazz, true), jsonSerializer) == null) {
                this._readOnlyMap = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndResolveNonTypedSerializer(Class<?> clazz, JsonSerializer<Object> jsonSerializer, SerializerProvider serializerProvider) throws JsonMappingException {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            if (this._sharedMap.put(new TypeKey(clazz, false), jsonSerializer) == null) {
                this._readOnlyMap = null;
            }
            if (jsonSerializer instanceof ResolvableSerializer) {
                ((ResolvableSerializer)((Object)jsonSerializer)).resolve(serializerProvider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndResolveNonTypedSerializer(JavaType javaType, JsonSerializer<Object> jsonSerializer, SerializerProvider serializerProvider) throws JsonMappingException {
        SerializerCache serializerCache = this;
        synchronized (serializerCache) {
            if (this._sharedMap.put(new TypeKey(javaType, false), jsonSerializer) == null) {
                this._readOnlyMap = null;
            }
            if (jsonSerializer instanceof ResolvableSerializer) {
                ((ResolvableSerializer)((Object)jsonSerializer)).resolve(serializerProvider);
            }
        }
    }

    public synchronized void flush() {
        this._sharedMap.clear();
    }

    public static final class TypeKey {
        protected int _hashCode;
        protected Class<?> _class;
        protected JavaType _type;
        protected boolean _isTyped;

        public TypeKey(Class<?> clazz, boolean bl) {
            this._class = clazz;
            this._type = null;
            this._isTyped = bl;
            this._hashCode = TypeKey.hash(clazz, bl);
        }

        public TypeKey(JavaType javaType, boolean bl) {
            this._type = javaType;
            this._class = null;
            this._isTyped = bl;
            this._hashCode = TypeKey.hash(javaType, bl);
        }

        private static final int hash(Class<?> clazz, boolean bl) {
            int n = clazz.getName().hashCode();
            if (bl) {
                ++n;
            }
            return n;
        }

        private static final int hash(JavaType javaType, boolean bl) {
            int n = javaType.hashCode() - 1;
            if (bl) {
                --n;
            }
            return n;
        }

        public void resetTyped(Class<?> clazz) {
            this._type = null;
            this._class = clazz;
            this._isTyped = true;
            this._hashCode = TypeKey.hash(clazz, true);
        }

        public void resetUntyped(Class<?> clazz) {
            this._type = null;
            this._class = clazz;
            this._isTyped = false;
            this._hashCode = TypeKey.hash(clazz, false);
        }

        public void resetTyped(JavaType javaType) {
            this._type = javaType;
            this._class = null;
            this._isTyped = true;
            this._hashCode = TypeKey.hash(javaType, true);
        }

        public void resetUntyped(JavaType javaType) {
            this._type = javaType;
            this._class = null;
            this._isTyped = false;
            this._hashCode = TypeKey.hash(javaType, false);
        }

        public final int hashCode() {
            return this._hashCode;
        }

        public final String toString() {
            if (this._class != null) {
                return "{class: " + this._class.getName() + ", typed? " + this._isTyped + "}";
            }
            return "{type: " + this._type + ", typed? " + this._isTyped + "}";
        }

        public final boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            TypeKey typeKey = (TypeKey)object;
            if (typeKey._isTyped == this._isTyped) {
                if (this._class != null) {
                    return typeKey._class == this._class;
                }
                return this._type.equals(typeKey._type);
            }
            return false;
        }
    }
}

