/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.fasterxml.jackson.databind;

import com.snowflake.client.jdbc.internal.fasterxml.jackson.annotation.JsonAutoDetect;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.annotation.JsonInclude;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.annotation.JsonTypeInfo;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.annotation.PropertyAccessor;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.Base64Variant;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.Base64Variants;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.FormatSchema;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonEncoding;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonFactory;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerationException;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerator;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonParseException;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonParser;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonToken;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.ObjectCodec;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.PrettyPrinter;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.TreeNode;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.Version;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.Versioned;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.io.CharacterEscapes;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.io.SerializedString;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.type.ResolvedType;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.type.TypeReference;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.AbstractTypeResolver;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.AnnotationIntrospector;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.DeserializationConfig;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.DeserializationContext;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.DeserializationFeature;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.InjectableValues;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JavaType;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonDeserializer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonMappingException;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.MapperFeature;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.MappingIterator;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.MappingJsonFactory;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.Module;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectReader;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectWriter;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializationConfig;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializationFeature;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializerProvider;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.cfg.BaseSettings;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.cfg.MapperConfigBase;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.cfg.PackageVersion;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.Deserializers;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.KeyDeserializers;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.deser.ValueInstantiators;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.BasicClassIntrospector;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsontype.NamedType;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsontype.impl.StdSubtypeResolver;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ArrayNode;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.NullNode;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ObjectNode;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.FilterProvider;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.SerializerFactory;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ser.Serializers;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.type.ClassKey;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.type.SimpleType;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.type.TypeFactory;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.type.TypeModifier;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.RootNameLookup;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.StdDateFormat;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class ObjectMapper
extends ObjectCodec
implements Versioned,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final JavaType JSON_NODE_TYPE = SimpleType.constructUnsafe(JsonNode.class);
    protected static final ClassIntrospector DEFAULT_INTROSPECTOR = BasicClassIntrospector.instance;
    protected static final AnnotationIntrospector DEFAULT_ANNOTATION_INTROSPECTOR = new JacksonAnnotationIntrospector();
    protected static final VisibilityChecker<?> STD_VISIBILITY_CHECKER = VisibilityChecker.Std.defaultInstance();
    protected static final PrettyPrinter _defaultPrettyPrinter = new DefaultPrettyPrinter();
    protected static final BaseSettings DEFAULT_BASE = new BaseSettings(DEFAULT_INTROSPECTOR, DEFAULT_ANNOTATION_INTROSPECTOR, STD_VISIBILITY_CHECKER, null, TypeFactory.defaultInstance(), null, StdDateFormat.instance, null, Locale.getDefault(), TimeZone.getTimeZone("GMT"), Base64Variants.getDefaultVariant());
    protected final JsonFactory _jsonFactory;
    protected TypeFactory _typeFactory;
    protected InjectableValues _injectableValues;
    protected SubtypeResolver _subtypeResolver;
    protected final RootNameLookup _rootNames;
    protected final HashMap<ClassKey, Class<?>> _mixInAnnotations;
    protected SerializationConfig _serializationConfig;
    protected DefaultSerializerProvider _serializerProvider;
    protected SerializerFactory _serializerFactory;
    protected DeserializationConfig _deserializationConfig;
    protected DefaultDeserializationContext _deserializationContext;
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _rootDeserializers = new ConcurrentHashMap(64, 0.6f, 2);

    public ObjectMapper() {
        this(null, null, null);
    }

    public ObjectMapper(JsonFactory jsonFactory) {
        this(jsonFactory, null, null);
    }

    protected ObjectMapper(ObjectMapper objectMapper) {
        this._jsonFactory = objectMapper._jsonFactory.copy();
        this._jsonFactory.setCodec(this);
        this._subtypeResolver = objectMapper._subtypeResolver;
        this._rootNames = new RootNameLookup();
        this._typeFactory = objectMapper._typeFactory;
        this._serializationConfig = objectMapper._serializationConfig;
        HashMap hashMap = new HashMap(objectMapper._mixInAnnotations);
        this._mixInAnnotations = hashMap;
        this._serializationConfig = new SerializationConfig(objectMapper._serializationConfig, (Map<ClassKey, Class<?>>)hashMap);
        this._deserializationConfig = new DeserializationConfig(objectMapper._deserializationConfig, (Map<ClassKey, Class<?>>)hashMap);
        this._serializerProvider = objectMapper._serializerProvider;
        this._deserializationContext = objectMapper._deserializationContext;
        this._serializerFactory = objectMapper._serializerFactory;
    }

    public ObjectMapper(JsonFactory jsonFactory, DefaultSerializerProvider defaultSerializerProvider, DefaultDeserializationContext defaultDeserializationContext) {
        if (jsonFactory == null) {
            this._jsonFactory = new MappingJsonFactory(this);
        } else {
            this._jsonFactory = jsonFactory;
            if (jsonFactory.getCodec() == null) {
                this._jsonFactory.setCodec(this);
            }
        }
        this._subtypeResolver = new StdSubtypeResolver();
        this._rootNames = new RootNameLookup();
        this._typeFactory = TypeFactory.defaultInstance();
        HashMap hashMap = new HashMap();
        this._mixInAnnotations = hashMap;
        this._serializationConfig = new SerializationConfig(DEFAULT_BASE, this._subtypeResolver, hashMap);
        this._deserializationConfig = new DeserializationConfig(DEFAULT_BASE, this._subtypeResolver, hashMap);
        boolean bl = this._jsonFactory.requiresPropertyOrdering();
        if (bl ^ this._serializationConfig.isEnabled(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY)) {
            this.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, bl);
        }
        this._serializerProvider = defaultSerializerProvider == null ? new DefaultSerializerProvider.Impl() : defaultSerializerProvider;
        this._deserializationContext = defaultDeserializationContext == null ? new DefaultDeserializationContext.Impl(BeanDeserializerFactory.instance) : defaultDeserializationContext;
        this._serializerFactory = BeanSerializerFactory.instance;
    }

    public ObjectMapper copy() {
        this._checkInvalidCopy(ObjectMapper.class);
        return new ObjectMapper(this);
    }

    protected void _checkInvalidCopy(Class<?> clazz) {
        if (this.getClass() != clazz) {
            throw new IllegalStateException("Failed copy(): " + this.getClass().getName() + " (version: " + this.version() + ") does not override copy(); it has to");
        }
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    public ObjectMapper registerModule(Module module) {
        String string = module.getModuleName();
        if (string == null) {
            throw new IllegalArgumentException("Module without defined name");
        }
        Version version = module.version();
        if (version == null) {
            throw new IllegalArgumentException("Module without defined version");
        }
        final ObjectMapper objectMapper = this;
        module.setupModule(new Module.SetupContext(){

            @Override
            public Version getMapperVersion() {
                return ObjectMapper.this.version();
            }

            @Override
            public <C extends ObjectCodec> C getOwner() {
                return (C)objectMapper;
            }

            @Override
            public TypeFactory getTypeFactory() {
                return ObjectMapper.this._typeFactory;
            }

            @Override
            public boolean isEnabled(MapperFeature mapperFeature) {
                return objectMapper.isEnabled(mapperFeature);
            }

            @Override
            public boolean isEnabled(DeserializationFeature deserializationFeature) {
                return objectMapper.isEnabled(deserializationFeature);
            }

            @Override
            public boolean isEnabled(SerializationFeature serializationFeature) {
                return objectMapper.isEnabled(serializationFeature);
            }

            @Override
            public boolean isEnabled(JsonFactory.Feature feature) {
                return objectMapper.isEnabled(feature);
            }

            @Override
            public boolean isEnabled(JsonParser.Feature feature) {
                return objectMapper.isEnabled(feature);
            }

            @Override
            public boolean isEnabled(JsonGenerator.Feature feature) {
                return objectMapper.isEnabled(feature);
            }

            @Override
            public void addDeserializers(Deserializers deserializers) {
                DeserializerFactory deserializerFactory = objectMapper._deserializationContext._factory.withAdditionalDeserializers(deserializers);
                objectMapper._deserializationContext = objectMapper._deserializationContext.with(deserializerFactory);
            }

            @Override
            public void addKeyDeserializers(KeyDeserializers keyDeserializers) {
                DeserializerFactory deserializerFactory = objectMapper._deserializationContext._factory.withAdditionalKeyDeserializers(keyDeserializers);
                objectMapper._deserializationContext = objectMapper._deserializationContext.with(deserializerFactory);
            }

            @Override
            public void addBeanDeserializerModifier(BeanDeserializerModifier beanDeserializerModifier) {
                DeserializerFactory deserializerFactory = objectMapper._deserializationContext._factory.withDeserializerModifier(beanDeserializerModifier);
                objectMapper._deserializationContext = objectMapper._deserializationContext.with(deserializerFactory);
            }

            @Override
            public void addSerializers(Serializers serializers) {
                objectMapper._serializerFactory = objectMapper._serializerFactory.withAdditionalSerializers(serializers);
            }

            @Override
            public void addKeySerializers(Serializers serializers) {
                objectMapper._serializerFactory = objectMapper._serializerFactory.withAdditionalKeySerializers(serializers);
            }

            @Override
            public void addBeanSerializerModifier(BeanSerializerModifier beanSerializerModifier) {
                objectMapper._serializerFactory = objectMapper._serializerFactory.withSerializerModifier(beanSerializerModifier);
            }

            @Override
            public void addAbstractTypeResolver(AbstractTypeResolver abstractTypeResolver) {
                DeserializerFactory deserializerFactory = objectMapper._deserializationContext._factory.withAbstractTypeResolver(abstractTypeResolver);
                objectMapper._deserializationContext = objectMapper._deserializationContext.with(deserializerFactory);
            }

            @Override
            public void addTypeModifier(TypeModifier typeModifier) {
                TypeFactory typeFactory = objectMapper._typeFactory;
                typeFactory = typeFactory.withModifier(typeModifier);
                objectMapper.setTypeFactory(typeFactory);
            }

            @Override
            public void addValueInstantiators(ValueInstantiators valueInstantiators) {
                DeserializerFactory deserializerFactory = objectMapper._deserializationContext._factory.withValueInstantiators(valueInstantiators);
                objectMapper._deserializationContext = objectMapper._deserializationContext.with(deserializerFactory);
            }

            @Override
            public void setClassIntrospector(ClassIntrospector classIntrospector) {
                objectMapper._deserializationConfig = objectMapper._deserializationConfig.with(classIntrospector);
                objectMapper._serializationConfig = objectMapper._serializationConfig.with(classIntrospector);
            }

            @Override
            public void insertAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
                objectMapper._deserializationConfig = objectMapper._deserializationConfig.withInsertedAnnotationIntrospector(annotationIntrospector);
                objectMapper._serializationConfig = objectMapper._serializationConfig.withInsertedAnnotationIntrospector(annotationIntrospector);
            }

            @Override
            public void appendAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
                objectMapper._deserializationConfig = objectMapper._deserializationConfig.withAppendedAnnotationIntrospector(annotationIntrospector);
                objectMapper._serializationConfig = objectMapper._serializationConfig.withAppendedAnnotationIntrospector(annotationIntrospector);
            }

            @Override
            public void registerSubtypes(Class<?> ... classArray) {
                objectMapper.registerSubtypes(classArray);
            }

            @Override
            public void registerSubtypes(NamedType ... namedTypeArray) {
                objectMapper.registerSubtypes(namedTypeArray);
            }

            @Override
            public void setMixInAnnotations(Class<?> clazz, Class<?> clazz2) {
                objectMapper.addMixInAnnotations(clazz, clazz2);
            }

            @Override
            public void addDeserializationProblemHandler(DeserializationProblemHandler deserializationProblemHandler) {
                objectMapper.addHandler(deserializationProblemHandler);
            }

            @Override
            public void setNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
                objectMapper.setPropertyNamingStrategy(propertyNamingStrategy);
            }
        });
        return this;
    }

    public ObjectMapper registerModules(Module ... moduleArray) {
        for (Module module : moduleArray) {
            this.registerModule(module);
        }
        return this;
    }

    public ObjectMapper registerModules(Iterable<Module> iterable) {
        for (Module module : iterable) {
            this.registerModule(module);
        }
        return this;
    }

    public static List<Module> findModules() {
        return ObjectMapper.findModules(null);
    }

    public static List<Module> findModules(ClassLoader classLoader) {
        ArrayList<Module> arrayList = new ArrayList<Module>();
        ServiceLoader<Module> serviceLoader = classLoader == null ? ServiceLoader.load(Module.class) : ServiceLoader.load(Module.class, classLoader);
        for (Module module : serviceLoader) {
            arrayList.add(module);
        }
        return arrayList;
    }

    public ObjectMapper findAndRegisterModules() {
        return this.registerModules(ObjectMapper.findModules());
    }

    public SerializationConfig getSerializationConfig() {
        return this._serializationConfig;
    }

    public DeserializationConfig getDeserializationConfig() {
        return this._deserializationConfig;
    }

    public DeserializationContext getDeserializationContext() {
        return this._deserializationContext;
    }

    public ObjectMapper setSerializerFactory(SerializerFactory serializerFactory) {
        this._serializerFactory = serializerFactory;
        return this;
    }

    public SerializerFactory getSerializerFactory() {
        return this._serializerFactory;
    }

    public ObjectMapper setSerializerProvider(DefaultSerializerProvider defaultSerializerProvider) {
        this._serializerProvider = defaultSerializerProvider;
        return this;
    }

    public SerializerProvider getSerializerProvider() {
        return this._serializerProvider;
    }

    public final void setMixInAnnotations(Map<Class<?>, Class<?>> map) {
        this._mixInAnnotations.clear();
        if (map != null && map.size() > 0) {
            for (Map.Entry<Class<?>, Class<?>> entry : map.entrySet()) {
                this._mixInAnnotations.put(new ClassKey(entry.getKey()), entry.getValue());
            }
        }
    }

    public final void addMixInAnnotations(Class<?> clazz, Class<?> clazz2) {
        this._mixInAnnotations.put(new ClassKey(clazz), clazz2);
    }

    public final Class<?> findMixInClassFor(Class<?> clazz) {
        return this._mixInAnnotations == null ? null : this._mixInAnnotations.get(new ClassKey(clazz));
    }

    public final int mixInCount() {
        return this._mixInAnnotations == null ? 0 : this._mixInAnnotations.size();
    }

    public VisibilityChecker<?> getVisibilityChecker() {
        return this._serializationConfig.getDefaultVisibilityChecker();
    }

    public void setVisibilityChecker(VisibilityChecker<?> visibilityChecker) {
        this._deserializationConfig = this._deserializationConfig.with((VisibilityChecker)visibilityChecker);
        this._serializationConfig = this._serializationConfig.with((VisibilityChecker)visibilityChecker);
    }

    public ObjectMapper setVisibility(PropertyAccessor propertyAccessor, JsonAutoDetect.Visibility visibility) {
        this._deserializationConfig = this._deserializationConfig.withVisibility(propertyAccessor, visibility);
        this._serializationConfig = this._serializationConfig.withVisibility(propertyAccessor, visibility);
        return this;
    }

    public SubtypeResolver getSubtypeResolver() {
        return this._subtypeResolver;
    }

    public ObjectMapper setSubtypeResolver(SubtypeResolver subtypeResolver) {
        this._subtypeResolver = subtypeResolver;
        this._deserializationConfig = this._deserializationConfig.with(subtypeResolver);
        this._serializationConfig = this._serializationConfig.with(subtypeResolver);
        return this;
    }

    public ObjectMapper setAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        this._serializationConfig = this._serializationConfig.with(annotationIntrospector);
        this._deserializationConfig = this._deserializationConfig.with(annotationIntrospector);
        return this;
    }

    public ObjectMapper setAnnotationIntrospectors(AnnotationIntrospector annotationIntrospector, AnnotationIntrospector annotationIntrospector2) {
        this._serializationConfig = this._serializationConfig.with(annotationIntrospector);
        this._deserializationConfig = this._deserializationConfig.with(annotationIntrospector2);
        return this;
    }

    public ObjectMapper setPropertyNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
        this._serializationConfig = this._serializationConfig.with(propertyNamingStrategy);
        this._deserializationConfig = this._deserializationConfig.with(propertyNamingStrategy);
        return this;
    }

    public ObjectMapper setSerializationInclusion(JsonInclude.Include include) {
        this._serializationConfig = this._serializationConfig.withSerializationInclusion(include);
        return this;
    }

    public ObjectMapper enableDefaultTyping() {
        return this.enableDefaultTyping(DefaultTyping.OBJECT_AND_NON_CONCRETE);
    }

    public ObjectMapper enableDefaultTyping(DefaultTyping defaultTyping) {
        return this.enableDefaultTyping(defaultTyping, JsonTypeInfo.As.WRAPPER_ARRAY);
    }

    public ObjectMapper enableDefaultTyping(DefaultTyping defaultTyping, JsonTypeInfo.As as) {
        DefaultTypeResolverBuilder defaultTypeResolverBuilder = new DefaultTypeResolverBuilder(defaultTyping);
        defaultTypeResolverBuilder = defaultTypeResolverBuilder.init(JsonTypeInfo.Id.CLASS, null);
        defaultTypeResolverBuilder = defaultTypeResolverBuilder.inclusion(as);
        return this.setDefaultTyping(defaultTypeResolverBuilder);
    }

    public ObjectMapper enableDefaultTypingAsProperty(DefaultTyping defaultTyping, String string) {
        DefaultTypeResolverBuilder defaultTypeResolverBuilder = new DefaultTypeResolverBuilder(defaultTyping);
        defaultTypeResolverBuilder = defaultTypeResolverBuilder.init(JsonTypeInfo.Id.CLASS, null);
        defaultTypeResolverBuilder = defaultTypeResolverBuilder.inclusion(JsonTypeInfo.As.PROPERTY);
        defaultTypeResolverBuilder = defaultTypeResolverBuilder.typeProperty(string);
        return this.setDefaultTyping(defaultTypeResolverBuilder);
    }

    public ObjectMapper disableDefaultTyping() {
        return this.setDefaultTyping(null);
    }

    public ObjectMapper setDefaultTyping(TypeResolverBuilder<?> typeResolverBuilder) {
        this._deserializationConfig = this._deserializationConfig.with((TypeResolverBuilder)typeResolverBuilder);
        this._serializationConfig = this._serializationConfig.with((TypeResolverBuilder)typeResolverBuilder);
        return this;
    }

    public void registerSubtypes(Class<?> ... classArray) {
        this.getSubtypeResolver().registerSubtypes(classArray);
    }

    public void registerSubtypes(NamedType ... namedTypeArray) {
        this.getSubtypeResolver().registerSubtypes(namedTypeArray);
    }

    public TypeFactory getTypeFactory() {
        return this._typeFactory;
    }

    public ObjectMapper setTypeFactory(TypeFactory typeFactory) {
        this._typeFactory = typeFactory;
        this._deserializationConfig = this._deserializationConfig.with(typeFactory);
        this._serializationConfig = this._serializationConfig.with(typeFactory);
        return this;
    }

    public JavaType constructType(Type type) {
        return this._typeFactory.constructType(type);
    }

    public ObjectMapper setNodeFactory(JsonNodeFactory jsonNodeFactory) {
        this._deserializationConfig = this._deserializationConfig.with(jsonNodeFactory);
        return this;
    }

    public ObjectMapper addHandler(DeserializationProblemHandler deserializationProblemHandler) {
        this._deserializationConfig = this._deserializationConfig.withHandler(deserializationProblemHandler);
        return this;
    }

    public ObjectMapper clearProblemHandlers() {
        this._deserializationConfig = this._deserializationConfig.withNoProblemHandlers();
        return this;
    }

    public void setFilters(FilterProvider filterProvider) {
        this._serializationConfig = this._serializationConfig.withFilters(filterProvider);
    }

    public ObjectMapper setBase64Variant(Base64Variant base64Variant) {
        this._serializationConfig = this._serializationConfig.with(base64Variant);
        this._deserializationConfig = this._deserializationConfig.with(base64Variant);
        return this;
    }

    @Override
    public JsonFactory getFactory() {
        return this._jsonFactory;
    }

    @Override
    @Deprecated
    public JsonFactory getJsonFactory() {
        return this._jsonFactory;
    }

    public ObjectMapper setDateFormat(DateFormat dateFormat) {
        this._deserializationConfig = this._deserializationConfig.with(dateFormat);
        this._serializationConfig = this._serializationConfig.with(dateFormat);
        return this;
    }

    public Object setHandlerInstantiator(HandlerInstantiator handlerInstantiator) {
        this._deserializationConfig = this._deserializationConfig.with(handlerInstantiator);
        this._serializationConfig = this._serializationConfig.with(handlerInstantiator);
        return this;
    }

    public ObjectMapper setInjectableValues(InjectableValues injectableValues) {
        this._injectableValues = injectableValues;
        return this;
    }

    public ObjectMapper setLocale(Locale locale) {
        this._deserializationConfig = this._deserializationConfig.with(locale);
        this._serializationConfig = this._serializationConfig.with(locale);
        return this;
    }

    public ObjectMapper setTimeZone(TimeZone timeZone) {
        this._deserializationConfig = this._deserializationConfig.with(timeZone);
        this._serializationConfig = this._serializationConfig.with(timeZone);
        return this;
    }

    public ObjectMapper configure(MapperFeature mapperFeature, boolean bl) {
        this._serializationConfig = bl ? this._serializationConfig.with(mapperFeature) : this._serializationConfig.without(mapperFeature);
        this._deserializationConfig = bl ? this._deserializationConfig.with(mapperFeature) : this._deserializationConfig.without(mapperFeature);
        return this;
    }

    public ObjectMapper configure(SerializationFeature serializationFeature, boolean bl) {
        this._serializationConfig = bl ? this._serializationConfig.with(serializationFeature) : this._serializationConfig.without(serializationFeature);
        return this;
    }

    public ObjectMapper configure(DeserializationFeature deserializationFeature, boolean bl) {
        this._deserializationConfig = bl ? this._deserializationConfig.with(deserializationFeature) : this._deserializationConfig.without(deserializationFeature);
        return this;
    }

    public ObjectMapper configure(JsonParser.Feature feature, boolean bl) {
        this._jsonFactory.configure(feature, bl);
        return this;
    }

    public ObjectMapper configure(JsonGenerator.Feature feature, boolean bl) {
        this._jsonFactory.configure(feature, bl);
        return this;
    }

    public ObjectMapper enable(MapperFeature ... mapperFeatureArray) {
        this._deserializationConfig = this._deserializationConfig.with(mapperFeatureArray);
        this._serializationConfig = this._serializationConfig.with(mapperFeatureArray);
        return this;
    }

    public ObjectMapper disable(MapperFeature ... mapperFeatureArray) {
        this._deserializationConfig = this._deserializationConfig.without(mapperFeatureArray);
        this._serializationConfig = this._serializationConfig.without(mapperFeatureArray);
        return this;
    }

    public ObjectMapper enable(DeserializationFeature deserializationFeature) {
        this._deserializationConfig = this._deserializationConfig.with(deserializationFeature);
        return this;
    }

    public ObjectMapper enable(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        this._deserializationConfig = this._deserializationConfig.with(deserializationFeature, deserializationFeatureArray);
        return this;
    }

    public ObjectMapper disable(DeserializationFeature deserializationFeature) {
        this._deserializationConfig = this._deserializationConfig.without(deserializationFeature);
        return this;
    }

    public ObjectMapper disable(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        this._deserializationConfig = this._deserializationConfig.without(deserializationFeature, deserializationFeatureArray);
        return this;
    }

    public ObjectMapper enable(SerializationFeature serializationFeature) {
        this._serializationConfig = this._serializationConfig.with(serializationFeature);
        return this;
    }

    public ObjectMapper enable(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        this._serializationConfig = this._serializationConfig.with(serializationFeature, serializationFeatureArray);
        return this;
    }

    public ObjectMapper disable(SerializationFeature serializationFeature) {
        this._serializationConfig = this._serializationConfig.without(serializationFeature);
        return this;
    }

    public ObjectMapper disable(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        this._serializationConfig = this._serializationConfig.without(serializationFeature, serializationFeatureArray);
        return this;
    }

    public boolean isEnabled(MapperFeature mapperFeature) {
        return this._serializationConfig.isEnabled(mapperFeature);
    }

    public boolean isEnabled(SerializationFeature serializationFeature) {
        return this._serializationConfig.isEnabled(serializationFeature);
    }

    public boolean isEnabled(DeserializationFeature deserializationFeature) {
        return this._deserializationConfig.isEnabled(deserializationFeature);
    }

    public boolean isEnabled(JsonFactory.Feature feature) {
        return this._jsonFactory.isEnabled(feature);
    }

    public boolean isEnabled(JsonParser.Feature feature) {
        return this._jsonFactory.isEnabled(feature);
    }

    public boolean isEnabled(JsonGenerator.Feature feature) {
        return this._jsonFactory.isEnabled(feature);
    }

    public JsonNodeFactory getNodeFactory() {
        return this._deserializationConfig.getNodeFactory();
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, Class<T> clazz) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readValue(this.getDeserializationConfig(), jsonParser, this._typeFactory.constructType(clazz));
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, TypeReference<?> typeReference) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readValue(this.getDeserializationConfig(), jsonParser, this._typeFactory.constructType(typeReference));
    }

    @Override
    public final <T> T readValue(JsonParser jsonParser, ResolvedType resolvedType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readValue(this.getDeserializationConfig(), jsonParser, (JavaType)resolvedType);
    }

    public <T> T readValue(JsonParser jsonParser, JavaType javaType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readValue(this.getDeserializationConfig(), jsonParser, javaType);
    }

    @Override
    public <T extends TreeNode> T readTree(JsonParser jsonParser) throws IOException, JsonProcessingException {
        DeserializationConfig deserializationConfig = this.getDeserializationConfig();
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == null && (jsonToken = jsonParser.nextToken()) == null) {
            return null;
        }
        JsonNode jsonNode = (JsonNode)this._readValue(deserializationConfig, jsonParser, JSON_NODE_TYPE);
        if (jsonNode == null) {
            jsonNode = this.getNodeFactory().nullNode();
        }
        JsonNode jsonNode2 = jsonNode;
        return (T)jsonNode2;
    }

    public <T> MappingIterator<T> readValues(JsonParser jsonParser, ResolvedType resolvedType) throws IOException, JsonProcessingException {
        return this.readValues(jsonParser, (JavaType)resolvedType);
    }

    public <T> MappingIterator<T> readValues(JsonParser jsonParser, JavaType javaType) throws IOException, JsonProcessingException {
        DeserializationConfig deserializationConfig = this.getDeserializationConfig();
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, deserializationConfig);
        JsonDeserializer<Object> jsonDeserializer = this._findRootDeserializer(defaultDeserializationContext, javaType);
        return new MappingIterator(javaType, jsonParser, defaultDeserializationContext, jsonDeserializer, false, null);
    }

    public <T> MappingIterator<T> readValues(JsonParser jsonParser, Class<T> clazz) throws IOException, JsonProcessingException {
        return this.readValues(jsonParser, this._typeFactory.constructType(clazz));
    }

    public <T> MappingIterator<T> readValues(JsonParser jsonParser, TypeReference<?> typeReference) throws IOException, JsonProcessingException {
        return this.readValues(jsonParser, this._typeFactory.constructType(typeReference));
    }

    public JsonNode readTree(InputStream inputStream) throws IOException, JsonProcessingException {
        JsonNode jsonNode = (JsonNode)this._readMapAndClose(this._jsonFactory.createParser(inputStream), JSON_NODE_TYPE);
        return jsonNode == null ? NullNode.instance : jsonNode;
    }

    public JsonNode readTree(Reader reader) throws IOException, JsonProcessingException {
        JsonNode jsonNode = (JsonNode)this._readMapAndClose(this._jsonFactory.createParser(reader), JSON_NODE_TYPE);
        return jsonNode == null ? NullNode.instance : jsonNode;
    }

    public JsonNode readTree(String string) throws IOException, JsonProcessingException {
        JsonNode jsonNode = (JsonNode)this._readMapAndClose(this._jsonFactory.createParser(string), JSON_NODE_TYPE);
        return jsonNode == null ? NullNode.instance : jsonNode;
    }

    public JsonNode readTree(byte[] byArray) throws IOException, JsonProcessingException {
        JsonNode jsonNode = (JsonNode)this._readMapAndClose(this._jsonFactory.createParser(byArray), JSON_NODE_TYPE);
        return jsonNode == null ? NullNode.instance : jsonNode;
    }

    public JsonNode readTree(File file) throws IOException, JsonProcessingException {
        JsonNode jsonNode = (JsonNode)this._readMapAndClose(this._jsonFactory.createParser(file), JSON_NODE_TYPE);
        return jsonNode == null ? NullNode.instance : jsonNode;
    }

    public JsonNode readTree(URL uRL) throws IOException, JsonProcessingException {
        JsonNode jsonNode = (JsonNode)this._readMapAndClose(this._jsonFactory.createParser(uRL), JSON_NODE_TYPE);
        return jsonNode == null ? NullNode.instance : jsonNode;
    }

    @Override
    public void writeValue(JsonGenerator jsonGenerator, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        SerializationConfig serializationConfig = this.getSerializationConfig();
        if (serializationConfig.isEnabled(SerializationFeature.INDENT_OUTPUT)) {
            jsonGenerator.useDefaultPrettyPrinter();
        }
        if (serializationConfig.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._writeCloseableValue(jsonGenerator, object, serializationConfig);
        } else {
            this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            if (serializationConfig.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                jsonGenerator.flush();
            }
        }
    }

    @Override
    public void writeTree(JsonGenerator jsonGenerator, TreeNode treeNode) throws IOException, JsonProcessingException {
        SerializationConfig serializationConfig = this.getSerializationConfig();
        this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, treeNode);
        if (serializationConfig.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
            jsonGenerator.flush();
        }
    }

    public void writeTree(JsonGenerator jsonGenerator, JsonNode jsonNode) throws IOException, JsonProcessingException {
        SerializationConfig serializationConfig = this.getSerializationConfig();
        this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, jsonNode);
        if (serializationConfig.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
            jsonGenerator.flush();
        }
    }

    @Override
    public ObjectNode createObjectNode() {
        return this._deserializationConfig.getNodeFactory().objectNode();
    }

    @Override
    public ArrayNode createArrayNode() {
        return this._deserializationConfig.getNodeFactory().arrayNode();
    }

    @Override
    public JsonParser treeAsTokens(TreeNode treeNode) {
        return new TreeTraversingParser((JsonNode)treeNode, this);
    }

    @Override
    public <T> T treeToValue(TreeNode treeNode, Class<T> clazz) throws JsonProcessingException {
        try {
            if (clazz != Object.class && clazz.isAssignableFrom(treeNode.getClass())) {
                return (T)treeNode;
            }
            return this.readValue(this.treeAsTokens(treeNode), clazz);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
    }

    public <T extends JsonNode> T valueToTree(Object object) throws IllegalArgumentException {
        JsonNode jsonNode;
        if (object == null) {
            return null;
        }
        TokenBuffer tokenBuffer = new TokenBuffer(this, false);
        try {
            this.writeValue(tokenBuffer, object);
            JsonParser jsonParser = tokenBuffer.asParser();
            jsonNode = (JsonNode)this.readTree(jsonParser);
            jsonParser.close();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
        return (T)jsonNode;
    }

    public boolean canSerialize(Class<?> clazz) {
        return this._serializerProvider(this.getSerializationConfig()).hasSerializerFor(clazz, null);
    }

    public boolean canSerialize(Class<?> clazz, AtomicReference<Throwable> atomicReference) {
        return this._serializerProvider(this.getSerializationConfig()).hasSerializerFor(clazz, atomicReference);
    }

    public boolean canDeserialize(JavaType javaType) {
        return this.createDeserializationContext(null, this.getDeserializationConfig()).hasValueDeserializerFor(javaType, null);
    }

    public boolean canDeserialize(JavaType javaType, AtomicReference<Throwable> atomicReference) {
        return this.createDeserializationContext(null, this.getDeserializationConfig()).hasValueDeserializerFor(javaType, atomicReference);
    }

    public <T> T readValue(File file, Class<T> clazz) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(file), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(File file, TypeReference typeReference) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(file), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(File file, JavaType javaType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(file), javaType);
    }

    public <T> T readValue(URL uRL, Class<T> clazz) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(uRL), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(URL uRL, TypeReference typeReference) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(uRL), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(URL uRL, JavaType javaType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(uRL), javaType);
    }

    public <T> T readValue(String string, Class<T> clazz) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(string), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(String string, TypeReference typeReference) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(string), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(String string, JavaType javaType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(string), javaType);
    }

    public <T> T readValue(Reader reader, Class<T> clazz) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(reader), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(Reader reader, TypeReference typeReference) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(reader), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(Reader reader, JavaType javaType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(reader), javaType);
    }

    public <T> T readValue(InputStream inputStream, Class<T> clazz) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(inputStream), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(InputStream inputStream, TypeReference typeReference) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(inputStream), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(InputStream inputStream, JavaType javaType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(inputStream), javaType);
    }

    public <T> T readValue(byte[] byArray, Class<T> clazz) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(byArray), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(byte[] byArray, int n, int n2, Class<T> clazz) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(byArray, n, n2), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(byte[] byArray, TypeReference typeReference) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(byArray), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(byte[] byArray, int n, int n2, TypeReference typeReference) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(byArray, n, n2), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(byte[] byArray, JavaType javaType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(byArray), javaType);
    }

    public <T> T readValue(byte[] byArray, int n, int n2, JavaType javaType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createParser(byArray, n, n2), javaType);
    }

    public void writeValue(File file, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        this._configAndWriteValue(this._jsonFactory.createGenerator(file, JsonEncoding.UTF8), object);
    }

    public void writeValue(OutputStream outputStream, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        this._configAndWriteValue(this._jsonFactory.createGenerator(outputStream, JsonEncoding.UTF8), object);
    }

    public void writeValue(Writer writer, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        this._configAndWriteValue(this._jsonFactory.createGenerator(writer), object);
    }

    public String writeValueAsString(Object object) throws JsonProcessingException {
        SegmentedStringWriter segmentedStringWriter = new SegmentedStringWriter(this._jsonFactory._getBufferRecycler());
        try {
            this._configAndWriteValue(this._jsonFactory.createGenerator(segmentedStringWriter), object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw JsonMappingException.fromUnexpectedIOE(iOException);
        }
        return segmentedStringWriter.getAndClear();
    }

    public byte[] writeValueAsBytes(Object object) throws JsonProcessingException {
        ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder(this._jsonFactory._getBufferRecycler());
        try {
            this._configAndWriteValue(this._jsonFactory.createGenerator(byteArrayBuilder, JsonEncoding.UTF8), object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw JsonMappingException.fromUnexpectedIOE(iOException);
        }
        byte[] byArray = byteArrayBuilder.toByteArray();
        byteArrayBuilder.release();
        return byArray;
    }

    public ObjectWriter writer() {
        return new ObjectWriter(this, this.getSerializationConfig());
    }

    public ObjectWriter writer(SerializationFeature serializationFeature) {
        return new ObjectWriter(this, this.getSerializationConfig().with(serializationFeature));
    }

    public ObjectWriter writer(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        return new ObjectWriter(this, this.getSerializationConfig().with(serializationFeature, serializationFeatureArray));
    }

    public ObjectWriter writer(DateFormat dateFormat) {
        return new ObjectWriter(this, this.getSerializationConfig().with(dateFormat));
    }

    public ObjectWriter writerWithView(Class<?> clazz) {
        return new ObjectWriter(this, (SerializationConfig)this.getSerializationConfig().withView((Class)clazz));
    }

    public ObjectWriter writerWithType(Class<?> clazz) {
        return new ObjectWriter(this, this.getSerializationConfig(), clazz == null ? null : this._typeFactory.constructType(clazz), null);
    }

    public ObjectWriter writerWithType(TypeReference<?> typeReference) {
        return new ObjectWriter(this, this.getSerializationConfig(), typeReference == null ? null : this._typeFactory.constructType(typeReference), null);
    }

    public ObjectWriter writerWithType(JavaType javaType) {
        return new ObjectWriter(this, this.getSerializationConfig(), javaType, null);
    }

    public ObjectWriter writer(PrettyPrinter prettyPrinter) {
        if (prettyPrinter == null) {
            prettyPrinter = ObjectWriter.NULL_PRETTY_PRINTER;
        }
        return new ObjectWriter(this, this.getSerializationConfig(), null, prettyPrinter);
    }

    public ObjectWriter writerWithDefaultPrettyPrinter() {
        return new ObjectWriter(this, this.getSerializationConfig(), null, this._defaultPrettyPrinter());
    }

    public ObjectWriter writer(FilterProvider filterProvider) {
        return new ObjectWriter(this, this.getSerializationConfig().withFilters(filterProvider));
    }

    public ObjectWriter writer(FormatSchema formatSchema) {
        this._verifySchemaType(formatSchema);
        return new ObjectWriter(this, this.getSerializationConfig(), formatSchema);
    }

    public ObjectWriter writer(Base64Variant base64Variant) {
        return new ObjectWriter(this, this.getSerializationConfig().with(base64Variant));
    }

    public ObjectWriter writer(CharacterEscapes characterEscapes) {
        return this.writer().with(characterEscapes);
    }

    public ObjectWriter writer(ContextAttributes contextAttributes) {
        return new ObjectWriter(this, this.getSerializationConfig().with(contextAttributes));
    }

    public ObjectReader reader() {
        return new ObjectReader(this, this.getDeserializationConfig()).with(this._injectableValues);
    }

    public ObjectReader reader(DeserializationFeature deserializationFeature) {
        return new ObjectReader(this, this.getDeserializationConfig().with(deserializationFeature));
    }

    public ObjectReader reader(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        return new ObjectReader(this, this.getDeserializationConfig().with(deserializationFeature, deserializationFeatureArray));
    }

    public ObjectReader readerForUpdating(Object object) {
        JavaType javaType = this._typeFactory.constructType(object.getClass());
        return new ObjectReader(this, this.getDeserializationConfig(), javaType, object, null, this._injectableValues);
    }

    public ObjectReader reader(JavaType javaType) {
        return new ObjectReader(this, this.getDeserializationConfig(), javaType, null, null, this._injectableValues);
    }

    public ObjectReader reader(Class<?> clazz) {
        return this.reader(this._typeFactory.constructType(clazz));
    }

    public ObjectReader reader(TypeReference<?> typeReference) {
        return this.reader(this._typeFactory.constructType(typeReference));
    }

    public ObjectReader reader(JsonNodeFactory jsonNodeFactory) {
        return new ObjectReader(this, this.getDeserializationConfig()).with(jsonNodeFactory);
    }

    public ObjectReader reader(FormatSchema formatSchema) {
        this._verifySchemaType(formatSchema);
        return new ObjectReader(this, this.getDeserializationConfig(), null, null, formatSchema, this._injectableValues);
    }

    public ObjectReader reader(InjectableValues injectableValues) {
        return new ObjectReader(this, this.getDeserializationConfig(), null, null, null, injectableValues);
    }

    public ObjectReader readerWithView(Class<?> clazz) {
        return new ObjectReader(this, (DeserializationConfig)this.getDeserializationConfig().withView((Class)clazz));
    }

    public ObjectReader reader(Base64Variant base64Variant) {
        return new ObjectReader(this, this.getDeserializationConfig().with(base64Variant));
    }

    public ObjectReader reader(ContextAttributes contextAttributes) {
        return new ObjectReader(this, this.getDeserializationConfig().with(contextAttributes));
    }

    public <T> T convertValue(Object object, Class<T> clazz) throws IllegalArgumentException {
        if (object == null) {
            return null;
        }
        return (T)this._convert(object, this._typeFactory.constructType(clazz));
    }

    public <T> T convertValue(Object object, TypeReference<?> typeReference) throws IllegalArgumentException {
        return this.convertValue(object, this._typeFactory.constructType(typeReference));
    }

    public <T> T convertValue(Object object, JavaType javaType) throws IllegalArgumentException {
        if (object == null) {
            return null;
        }
        return (T)this._convert(object, javaType);
    }

    protected Object _convert(Object object, JavaType javaType) throws IllegalArgumentException {
        Class<?> clazz = javaType.getRawClass();
        if (clazz != Object.class && !javaType.hasGenericTypes() && clazz.isAssignableFrom(object.getClass())) {
            return object;
        }
        TokenBuffer tokenBuffer = new TokenBuffer(this, false);
        try {
            Object object2;
            SerializationConfig serializationConfig = this.getSerializationConfig().without(SerializationFeature.WRAP_ROOT_VALUE);
            this._serializerProvider(serializationConfig).serializeValue(tokenBuffer, object);
            JsonParser jsonParser = tokenBuffer.asParser();
            DeserializationConfig deserializationConfig = this.getDeserializationConfig();
            JsonToken jsonToken = this._initForReading(jsonParser);
            if (jsonToken == JsonToken.VALUE_NULL) {
                DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, deserializationConfig);
                object2 = this._findRootDeserializer(defaultDeserializationContext, javaType).getNullValue();
            } else if (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) {
                object2 = null;
            } else {
                DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, deserializationConfig);
                JsonDeserializer<Object> jsonDeserializer = this._findRootDeserializer(defaultDeserializationContext, javaType);
                object2 = jsonDeserializer.deserialize(jsonParser, defaultDeserializationContext);
            }
            jsonParser.close();
            return object2;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
    }

    public JsonSchema generateJsonSchema(Class<?> clazz) throws JsonMappingException {
        return this._serializerProvider(this.getSerializationConfig()).generateJsonSchema(clazz);
    }

    public void acceptJsonFormatVisitor(Class<?> clazz, JsonFormatVisitorWrapper jsonFormatVisitorWrapper) throws JsonMappingException {
        this.acceptJsonFormatVisitor(this._typeFactory.constructType(clazz), jsonFormatVisitorWrapper);
    }

    public void acceptJsonFormatVisitor(JavaType javaType, JsonFormatVisitorWrapper jsonFormatVisitorWrapper) throws JsonMappingException {
        if (javaType == null) {
            throw new IllegalArgumentException("type must be provided");
        }
        this._serializerProvider(this.getSerializationConfig()).acceptJsonFormatVisitor(javaType, jsonFormatVisitorWrapper);
    }

    protected DefaultSerializerProvider _serializerProvider(SerializationConfig serializationConfig) {
        return this._serializerProvider.createInstance(serializationConfig, this._serializerFactory);
    }

    protected PrettyPrinter _defaultPrettyPrinter() {
        return _defaultPrettyPrinter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void _configAndWriteValue(JsonGenerator jsonGenerator, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        SerializationConfig serializationConfig = this.getSerializationConfig();
        if (serializationConfig.isEnabled(SerializationFeature.INDENT_OUTPUT)) {
            jsonGenerator.useDefaultPrettyPrinter();
        }
        if (serializationConfig.isEnabled(SerializationFeature.WRITE_BIGDECIMAL_AS_PLAIN)) {
            jsonGenerator.enable(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN);
        }
        if (serializationConfig.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._configAndWriteCloseable(jsonGenerator, object, serializationConfig);
            return;
        }
        boolean bl = false;
        try {
            this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            bl = true;
            jsonGenerator.close();
        }
        finally {
            if (!bl) {
                try {
                    jsonGenerator.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void _configAndWriteValue(JsonGenerator jsonGenerator, Object object, Class<?> clazz) throws IOException, JsonGenerationException, JsonMappingException {
        MapperConfigBase mapperConfigBase = this.getSerializationConfig().withView((Class)clazz);
        if (((SerializationConfig)mapperConfigBase).isEnabled(SerializationFeature.INDENT_OUTPUT)) {
            jsonGenerator.useDefaultPrettyPrinter();
        }
        if (((SerializationConfig)mapperConfigBase).isEnabled(SerializationFeature.WRITE_BIGDECIMAL_AS_PLAIN)) {
            jsonGenerator.enable(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN);
        }
        if (((SerializationConfig)mapperConfigBase).isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._configAndWriteCloseable(jsonGenerator, object, (SerializationConfig)mapperConfigBase);
            return;
        }
        boolean bl = false;
        try {
            this._serializerProvider((SerializationConfig)mapperConfigBase).serializeValue(jsonGenerator, object);
            bl = true;
            jsonGenerator.close();
        }
        finally {
            if (!bl) {
                try {
                    jsonGenerator.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _configAndWriteCloseable(JsonGenerator jsonGenerator, Object object, SerializationConfig serializationConfig) throws IOException, JsonGenerationException, JsonMappingException {
        Closeable closeable = (Closeable)object;
        try {
            this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            JsonGenerator jsonGenerator2 = jsonGenerator;
            jsonGenerator = null;
            jsonGenerator2.close();
            Closeable closeable2 = closeable;
            closeable = null;
            closeable2.close();
        }
        finally {
            if (jsonGenerator != null) {
                try {
                    jsonGenerator.close();
                }
                catch (IOException iOException) {}
            }
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _writeCloseableValue(JsonGenerator jsonGenerator, Object object, SerializationConfig serializationConfig) throws IOException, JsonGenerationException, JsonMappingException {
        Closeable closeable = (Closeable)object;
        try {
            this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            if (serializationConfig.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                jsonGenerator.flush();
            }
            Closeable closeable2 = closeable;
            closeable = null;
            closeable2.close();
        }
        finally {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected DefaultDeserializationContext createDeserializationContext(JsonParser jsonParser, DeserializationConfig deserializationConfig) {
        return this._deserializationContext.createInstance(deserializationConfig, jsonParser, this._injectableValues);
    }

    protected Object _readValue(DeserializationConfig deserializationConfig, JsonParser jsonParser, JavaType javaType) throws IOException, JsonParseException, JsonMappingException {
        Object object;
        JsonToken jsonToken = this._initForReading(jsonParser);
        if (jsonToken == JsonToken.VALUE_NULL) {
            DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, deserializationConfig);
            object = this._findRootDeserializer(defaultDeserializationContext, javaType).getNullValue();
        } else if (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) {
            object = null;
        } else {
            DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, deserializationConfig);
            JsonDeserializer<Object> jsonDeserializer = this._findRootDeserializer(defaultDeserializationContext, javaType);
            object = deserializationConfig.useRootWrapping() ? this._unwrapAndDeserialize(jsonParser, defaultDeserializationContext, deserializationConfig, javaType, jsonDeserializer) : jsonDeserializer.deserialize(jsonParser, defaultDeserializationContext);
        }
        jsonParser.clearCurrentToken();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object _readMapAndClose(JsonParser jsonParser, JavaType javaType) throws IOException, JsonParseException, JsonMappingException {
        try {
            Object object;
            Serializable serializable;
            JsonToken jsonToken = this._initForReading(jsonParser);
            if (jsonToken == JsonToken.VALUE_NULL) {
                serializable = this.createDeserializationContext(jsonParser, this.getDeserializationConfig());
                object = this._findRootDeserializer((DeserializationContext)serializable, javaType).getNullValue();
            } else if (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) {
                object = null;
            } else {
                serializable = this.getDeserializationConfig();
                DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, (DeserializationConfig)serializable);
                JsonDeserializer<Object> jsonDeserializer = this._findRootDeserializer(defaultDeserializationContext, javaType);
                object = ((DeserializationConfig)serializable).useRootWrapping() ? this._unwrapAndDeserialize(jsonParser, defaultDeserializationContext, (DeserializationConfig)serializable, javaType, jsonDeserializer) : jsonDeserializer.deserialize(jsonParser, defaultDeserializationContext);
            }
            jsonParser.clearCurrentToken();
            serializable = object;
            return serializable;
        }
        finally {
            try {
                jsonParser.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected JsonToken _initForReading(JsonParser jsonParser) throws IOException, JsonParseException, JsonMappingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == null && (jsonToken = jsonParser.nextToken()) == null) {
            throw JsonMappingException.from(jsonParser, "No content to map due to end-of-input");
        }
        return jsonToken;
    }

    protected Object _unwrapAndDeserialize(JsonParser jsonParser, DeserializationContext deserializationContext, DeserializationConfig deserializationConfig, JavaType javaType, JsonDeserializer<Object> jsonDeserializer) throws IOException, JsonParseException, JsonMappingException {
        Object object;
        String string = deserializationConfig.getRootName();
        if (string == null) {
            object = this._rootNames.findRootName(javaType, deserializationConfig);
            string = ((SerializedString)object).getValue();
        }
        if (jsonParser.getCurrentToken() != JsonToken.START_OBJECT) {
            throw JsonMappingException.from(jsonParser, "Current token not START_OBJECT (needed to unwrap root name '" + string + "'), but " + (Object)((Object)jsonParser.getCurrentToken()));
        }
        if (jsonParser.nextToken() != JsonToken.FIELD_NAME) {
            throw JsonMappingException.from(jsonParser, "Current token not FIELD_NAME (to contain expected root name '" + string + "'), but " + (Object)((Object)jsonParser.getCurrentToken()));
        }
        object = jsonParser.getCurrentName();
        if (!string.equals(object)) {
            throw JsonMappingException.from(jsonParser, "Root name '" + (String)object + "' does not match expected ('" + string + "') for type " + javaType);
        }
        jsonParser.nextToken();
        Object object2 = jsonDeserializer.deserialize(jsonParser, deserializationContext);
        if (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            throw JsonMappingException.from(jsonParser, "Current token not END_OBJECT (to match wrapper object with root name '" + string + "'), but " + (Object)((Object)jsonParser.getCurrentToken()));
        }
        return object2;
    }

    protected JsonDeserializer<Object> _findRootDeserializer(DeserializationContext deserializationContext, JavaType javaType) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer = this._rootDeserializers.get(javaType);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        jsonDeserializer = deserializationContext.findRootValueDeserializer(javaType);
        if (jsonDeserializer == null) {
            throw new JsonMappingException("Can not find a deserializer for type " + javaType);
        }
        this._rootDeserializers.put(javaType, jsonDeserializer);
        return jsonDeserializer;
    }

    protected void _verifySchemaType(FormatSchema formatSchema) {
        if (formatSchema != null && !this._jsonFactory.canUseSchema(formatSchema)) {
            throw new IllegalArgumentException("Can not use FormatSchema of type " + formatSchema.getClass().getName() + " for format " + this._jsonFactory.getFormatName());
        }
    }

    public static class DefaultTypeResolverBuilder
    extends StdTypeResolverBuilder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final DefaultTyping _appliesFor;

        public DefaultTypeResolverBuilder(DefaultTyping defaultTyping) {
            this._appliesFor = defaultTyping;
        }

        @Override
        public TypeDeserializer buildTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, Collection<NamedType> collection) {
            return this.useForType(javaType) ? super.buildTypeDeserializer(deserializationConfig, javaType, collection) : null;
        }

        @Override
        public TypeSerializer buildTypeSerializer(SerializationConfig serializationConfig, JavaType javaType, Collection<NamedType> collection) {
            return this.useForType(javaType) ? super.buildTypeSerializer(serializationConfig, javaType, collection) : null;
        }

        public boolean useForType(JavaType javaType) {
            switch (this._appliesFor) {
                case NON_CONCRETE_AND_ARRAYS: {
                    while (javaType.isArrayType()) {
                        javaType = javaType.getContentType();
                    }
                }
                case OBJECT_AND_NON_CONCRETE: {
                    return javaType.getRawClass() == Object.class || !javaType.isConcrete();
                }
                case NON_FINAL: {
                    while (javaType.isArrayType()) {
                        javaType = javaType.getContentType();
                    }
                    return !javaType.isFinal();
                }
            }
            return javaType.getRawClass() == Object.class;
        }
    }

    public static enum DefaultTyping {
        JAVA_LANG_OBJECT,
        OBJECT_AND_NON_CONCRETE,
        NON_CONCRETE_AND_ARRAYS,
        NON_FINAL;

    }
}

