/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.fasterxml.jackson.core.io;

public final class NumberOutput {
    private static final char NULL_CHAR = '\u0000';
    private static int MILLION = 1000000;
    private static int BILLION = 1000000000;
    private static long TEN_BILLION_L = 10000000000L;
    private static long THOUSAND_L = 1000L;
    private static long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    private static long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    static final String SMALLEST_LONG = String.valueOf(Long.MIN_VALUE);
    static final char[] LEADING_TRIPLETS = new char[4000];
    static final char[] FULL_TRIPLETS = new char[4000];
    static final byte[] FULL_TRIPLETS_B;
    static final String[] sSmallIntStrs;
    static final String[] sSmallIntStrs2;

    public static int outputInt(int n, char[] cArray, int n2) {
        boolean bl;
        if (n < 0) {
            if (n == Integer.MIN_VALUE) {
                return NumberOutput.outputLong((long)n, cArray, n2);
            }
            cArray[n2++] = 45;
            n = -n;
        }
        if (n < MILLION) {
            if (n < 1000) {
                if (n < 10) {
                    cArray[n2++] = (char)(48 + n);
                } else {
                    n2 = NumberOutput.outputLeadingTriplet(n, cArray, n2);
                }
            } else {
                int n3 = n / 1000;
                n2 = NumberOutput.outputLeadingTriplet(n3, cArray, n2);
                n2 = NumberOutput.outputFullTriplet(n -= n3 * 1000, cArray, n2);
            }
            return n2;
        }
        boolean bl2 = bl = n >= BILLION;
        if (bl) {
            if ((n -= BILLION) >= BILLION) {
                n -= BILLION;
                cArray[n2++] = 50;
            } else {
                cArray[n2++] = 49;
            }
        }
        int n4 = n / 1000;
        int n5 = n - n4 * 1000;
        n = n4;
        int n6 = n - (n4 /= 1000) * 1000;
        n2 = bl ? NumberOutput.outputFullTriplet(n4, cArray, n2) : NumberOutput.outputLeadingTriplet(n4, cArray, n2);
        n2 = NumberOutput.outputFullTriplet(n6, cArray, n2);
        n2 = NumberOutput.outputFullTriplet(n5, cArray, n2);
        return n2;
    }

    public static int outputInt(int n, byte[] byArray, int n2) {
        boolean bl;
        if (n < 0) {
            if (n == Integer.MIN_VALUE) {
                return NumberOutput.outputLong((long)n, byArray, n2);
            }
            byArray[n2++] = 45;
            n = -n;
        }
        if (n < MILLION) {
            if (n < 1000) {
                if (n < 10) {
                    byArray[n2++] = (byte)(48 + n);
                } else {
                    n2 = NumberOutput.outputLeadingTriplet(n, byArray, n2);
                }
            } else {
                int n3 = n / 1000;
                n2 = NumberOutput.outputLeadingTriplet(n3, byArray, n2);
                n2 = NumberOutput.outputFullTriplet(n -= n3 * 1000, byArray, n2);
            }
            return n2;
        }
        boolean bl2 = bl = n >= BILLION;
        if (bl) {
            if ((n -= BILLION) >= BILLION) {
                n -= BILLION;
                byArray[n2++] = 50;
            } else {
                byArray[n2++] = 49;
            }
        }
        int n4 = n / 1000;
        int n5 = n - n4 * 1000;
        n = n4;
        int n6 = n - (n4 /= 1000) * 1000;
        n2 = bl ? NumberOutput.outputFullTriplet(n4, byArray, n2) : NumberOutput.outputLeadingTriplet(n4, byArray, n2);
        n2 = NumberOutput.outputFullTriplet(n6, byArray, n2);
        n2 = NumberOutput.outputFullTriplet(n5, byArray, n2);
        return n2;
    }

    public static int outputLong(long l, char[] cArray, int n) {
        int n2;
        if (l < 0L) {
            if (l > MIN_INT_AS_LONG) {
                return NumberOutput.outputInt((int)l, cArray, n);
            }
            if (l == Long.MIN_VALUE) {
                int n3 = SMALLEST_LONG.length();
                SMALLEST_LONG.getChars(0, n3, cArray, n);
                return n + n3;
            }
            cArray[n++] = 45;
            l = -l;
        } else if (l <= MAX_INT_AS_LONG) {
            return NumberOutput.outputInt((int)l, cArray, n);
        }
        int n4 = n;
        int n5 = n += NumberOutput.calcLongStrLength(l);
        while (l > MAX_INT_AS_LONG) {
            long l2 = l / THOUSAND_L;
            n2 = (int)(l - l2 * THOUSAND_L);
            NumberOutput.outputFullTriplet(n2, cArray, n5 -= 3);
            l = l2;
        }
        int n6 = (int)l;
        while (n6 >= 1000) {
            int n7 = n6 / 1000;
            n2 = n6 - n7 * 1000;
            NumberOutput.outputFullTriplet(n2, cArray, n5 -= 3);
            n6 = n7;
        }
        NumberOutput.outputLeadingTriplet(n6, cArray, n4);
        return n;
    }

    public static int outputLong(long l, byte[] byArray, int n) {
        int n2;
        if (l < 0L) {
            if (l > MIN_INT_AS_LONG) {
                return NumberOutput.outputInt((int)l, byArray, n);
            }
            if (l == Long.MIN_VALUE) {
                int n3 = SMALLEST_LONG.length();
                for (int i = 0; i < n3; ++i) {
                    byArray[n++] = (byte)SMALLEST_LONG.charAt(i);
                }
                return n;
            }
            byArray[n++] = 45;
            l = -l;
        } else if (l <= MAX_INT_AS_LONG) {
            return NumberOutput.outputInt((int)l, byArray, n);
        }
        int n4 = n;
        int n5 = n += NumberOutput.calcLongStrLength(l);
        while (l > MAX_INT_AS_LONG) {
            long l2 = l / THOUSAND_L;
            n2 = (int)(l - l2 * THOUSAND_L);
            NumberOutput.outputFullTriplet(n2, byArray, n5 -= 3);
            l = l2;
        }
        int n6 = (int)l;
        while (n6 >= 1000) {
            int n7 = n6 / 1000;
            n2 = n6 - n7 * 1000;
            NumberOutput.outputFullTriplet(n2, byArray, n5 -= 3);
            n6 = n7;
        }
        NumberOutput.outputLeadingTriplet(n6, byArray, n4);
        return n;
    }

    public static String toString(int n) {
        if (n < sSmallIntStrs.length) {
            if (n >= 0) {
                return sSmallIntStrs[n];
            }
            int n2 = -n - 1;
            if (n2 < sSmallIntStrs2.length) {
                return sSmallIntStrs2[n2];
            }
        }
        return Integer.toString(n);
    }

    public static String toString(long l) {
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            return NumberOutput.toString((int)l);
        }
        return Long.toString(l);
    }

    public static String toString(double d) {
        return Double.toString(d);
    }

    private static int outputLeadingTriplet(int n, char[] cArray, int n2) {
        char c;
        int n3 = n << 2;
        if ((c = LEADING_TRIPLETS[n3++]) != '\u0000') {
            cArray[n2++] = c;
        }
        if ((c = LEADING_TRIPLETS[n3++]) != '\u0000') {
            cArray[n2++] = c;
        }
        cArray[n2++] = LEADING_TRIPLETS[n3];
        return n2;
    }

    private static int outputLeadingTriplet(int n, byte[] byArray, int n2) {
        char c;
        int n3 = n << 2;
        if ((c = LEADING_TRIPLETS[n3++]) != '\u0000') {
            byArray[n2++] = (byte)c;
        }
        if ((c = LEADING_TRIPLETS[n3++]) != '\u0000') {
            byArray[n2++] = (byte)c;
        }
        byArray[n2++] = (byte)LEADING_TRIPLETS[n3];
        return n2;
    }

    private static int outputFullTriplet(int n, char[] cArray, int n2) {
        int n3 = n << 2;
        cArray[n2++] = FULL_TRIPLETS[n3++];
        cArray[n2++] = FULL_TRIPLETS[n3++];
        cArray[n2++] = FULL_TRIPLETS[n3];
        return n2;
    }

    private static int outputFullTriplet(int n, byte[] byArray, int n2) {
        int n3 = n << 2;
        byArray[n2++] = FULL_TRIPLETS_B[n3++];
        byArray[n2++] = FULL_TRIPLETS_B[n3++];
        byArray[n2++] = FULL_TRIPLETS_B[n3];
        return n2;
    }

    private static int calcLongStrLength(long l) {
        int n;
        long l2 = TEN_BILLION_L;
        for (n = 10; l >= l2 && n != 19; ++n) {
            l2 = (l2 << 3) + (l2 << 1);
        }
        return n;
    }

    static {
        int n = 0;
        for (int i = 0; i < 10; ++i) {
            char c = (char)(48 + i);
            char c2 = i == 0 ? (char)'\u0000' : c;
            for (int j = 0; j < 10; ++j) {
                char c3 = (char)(48 + j);
                char c4 = i == 0 && j == 0 ? (char)'\u0000' : c3;
                for (int k = 0; k < 10; ++k) {
                    char c5 = (char)(48 + k);
                    NumberOutput.LEADING_TRIPLETS[n] = c2;
                    NumberOutput.LEADING_TRIPLETS[n + 1] = c4;
                    NumberOutput.LEADING_TRIPLETS[n + 2] = c5;
                    NumberOutput.FULL_TRIPLETS[n] = c;
                    NumberOutput.FULL_TRIPLETS[n + 1] = c3;
                    NumberOutput.FULL_TRIPLETS[n + 2] = c5;
                    n += 4;
                }
            }
        }
        FULL_TRIPLETS_B = new byte[4000];
        for (n = 0; n < 4000; ++n) {
            NumberOutput.FULL_TRIPLETS_B[n] = (byte)FULL_TRIPLETS[n];
        }
        sSmallIntStrs = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        sSmallIntStrs2 = new String[]{"-1", "-2", "-3", "-4", "-5", "-6", "-7", "-8", "-9", "-10"};
    }
}

