/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.apache.tika.io;

import com.snowflake.client.jdbc.internal.apache.tika.io.IOUtils;
import com.snowflake.client.jdbc.internal.apache.tika.io.TaggedInputStream;
import com.snowflake.client.jdbc.internal.apache.tika.io.TemporaryResources;
import com.snowflake.client.jdbc.internal.apache.tika.metadata.Metadata;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.sql.Blob;
import java.sql.SQLException;

public class TikaInputStream
extends TaggedInputStream {
    private static final int BLOB_SIZE_THRESHOLD = 0x100000;
    private File file;
    private final TemporaryResources tmp;
    private long length;
    private long position = 0L;
    private long mark = -1L;
    private Object openContainer;

    public static boolean isTikaInputStream(InputStream stream) {
        return stream instanceof TikaInputStream;
    }

    public static TikaInputStream get(InputStream stream, TemporaryResources tmp) {
        if (stream == null) {
            throw new NullPointerException("The Stream must not be null");
        }
        if (stream instanceof TikaInputStream) {
            return (TikaInputStream)stream;
        }
        if (!(stream instanceof BufferedInputStream) && !(stream instanceof ByteArrayInputStream)) {
            stream = new BufferedInputStream(stream);
        }
        return new TikaInputStream(stream, tmp, -1L);
    }

    public static TikaInputStream get(InputStream stream) {
        return TikaInputStream.get(stream, new TemporaryResources());
    }

    public static TikaInputStream cast(InputStream stream) {
        if (stream instanceof TikaInputStream) {
            return (TikaInputStream)stream;
        }
        return null;
    }

    public static TikaInputStream get(byte[] data) {
        return TikaInputStream.get(data, new Metadata());
    }

    public static TikaInputStream get(byte[] data, Metadata metadata) {
        metadata.set("Content-Length", Integer.toString(data.length));
        return new TikaInputStream(new ByteArrayInputStream(data), new TemporaryResources(), data.length);
    }

    public static TikaInputStream get(File file) throws FileNotFoundException {
        return TikaInputStream.get(file, new Metadata());
    }

    public static TikaInputStream get(File file, Metadata metadata) throws FileNotFoundException {
        metadata.set("resourceName", file.getName());
        metadata.set("Content-Length", Long.toString(file.length()));
        return new TikaInputStream(file);
    }

    public static TikaInputStream get(Blob blob) throws SQLException {
        return TikaInputStream.get(blob, new Metadata());
    }

    public static TikaInputStream get(Blob blob, Metadata metadata) throws SQLException {
        long length = -1L;
        try {
            length = blob.length();
            metadata.set("Content-Length", Long.toString(length));
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        if (0L <= length && length <= 0x100000L) {
            return TikaInputStream.get(blob.getBytes(1L, (int)length), metadata);
        }
        return new TikaInputStream(new BufferedInputStream(blob.getBinaryStream()), new TemporaryResources(), length);
    }

    public static TikaInputStream get(URI uri) throws IOException {
        return TikaInputStream.get(uri, new Metadata());
    }

    public static TikaInputStream get(URI uri, Metadata metadata) throws IOException {
        File file;
        if ("file".equalsIgnoreCase(uri.getScheme()) && (file = new File(uri)).isFile()) {
            return TikaInputStream.get(file, metadata);
        }
        return TikaInputStream.get(uri.toURL(), metadata);
    }

    public static TikaInputStream get(URL url) throws IOException {
        return TikaInputStream.get(url, new Metadata());
    }

    public static TikaInputStream get(URL url, Metadata metadata) throws IOException {
        int length;
        String encoding;
        String type;
        if ("file".equalsIgnoreCase(url.getProtocol())) {
            try {
                File file = new File(url.toURI());
                if (file.isFile()) {
                    return TikaInputStream.get(file, metadata);
                }
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        URLConnection connection = url.openConnection();
        String path = url.getPath();
        int slash = path.lastIndexOf(47);
        if (slash + 1 < path.length()) {
            metadata.set("resourceName", path.substring(slash + 1));
        }
        if ((type = connection.getContentType()) != null) {
            metadata.set("Content-Type", type);
        }
        if ((encoding = connection.getContentEncoding()) != null) {
            metadata.set("Content-Encoding", encoding);
        }
        if ((length = connection.getContentLength()) >= 0) {
            metadata.set("Content-Length", Integer.toString(length));
        }
        return new TikaInputStream(new BufferedInputStream(connection.getInputStream()), new TemporaryResources(), length);
    }

    private TikaInputStream(File file) throws FileNotFoundException {
        super(new BufferedInputStream(new FileInputStream(file)));
        this.file = file;
        this.tmp = new TemporaryResources();
        this.length = file.length();
    }

    private TikaInputStream(InputStream stream, TemporaryResources tmp, long length) {
        super(stream);
        this.file = null;
        this.tmp = tmp;
        this.length = length;
    }

    public int peek(byte[] buffer) throws IOException {
        int n = 0;
        this.mark(buffer.length);
        int m = this.read(buffer);
        while (m != -1) {
            if ((n += m) < buffer.length) {
                m = this.read(buffer, n, buffer.length - n);
                continue;
            }
            m = -1;
        }
        this.reset();
        return n;
    }

    public Object getOpenContainer() {
        return this.openContainer;
    }

    public void setOpenContainer(Object container) {
        this.openContainer = container;
        if (container instanceof Closeable) {
            this.tmp.addResource((Closeable)container);
        }
    }

    public boolean hasFile() {
        return this.file != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFile() throws IOException {
        if (this.file == null) {
            if (this.position > 0L) {
                throw new IOException("Stream is already being read");
            }
            this.file = this.tmp.createTemporaryFile();
            FileOutputStream out = new FileOutputStream(this.file);
            try {
                IOUtils.copy(this.in, (OutputStream)out);
            }
            finally {
                ((OutputStream)out).close();
            }
            FileInputStream newStream = new FileInputStream(this.file);
            this.tmp.addResource(newStream);
            final InputStream oldStream = this.in;
            this.in = new BufferedInputStream(newStream){

                @Override
                public void close() throws IOException {
                    oldStream.close();
                }
            };
            this.length = this.file.length();
        }
        return this.file;
    }

    public FileChannel getFileChannel() throws IOException {
        FileInputStream fis = new FileInputStream(this.getFile());
        this.tmp.addResource(fis);
        FileChannel channel = fis.getChannel();
        this.tmp.addResource(channel);
        return channel;
    }

    public boolean hasLength() {
        return this.length != -1L;
    }

    public long getLength() throws IOException {
        if (this.length == -1L) {
            this.length = this.getFile().length();
        }
        return this.length;
    }

    public long getPosition() {
        return this.position;
    }

    @Override
    public long skip(long ln) throws IOException {
        long n = super.skip(ln);
        this.position += n;
        return n;
    }

    @Override
    public void mark(int readlimit) {
        super.mark(readlimit);
        this.mark = this.position;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.position = this.mark;
        this.mark = -1L;
    }

    @Override
    public void close() throws IOException {
        this.file = null;
        this.mark = -1L;
        this.tmp.addResource(this.in);
        this.tmp.close();
    }

    @Override
    protected void afterRead(int n) {
        if (n != -1) {
            this.position += (long)n;
        }
    }

    @Override
    public String toString() {
        String str = "TikaInputStream of ";
        str = this.hasFile() ? str + this.file.toString() : str + this.in.toString();
        if (this.openContainer != null) {
            str = str + " (in " + this.openContainer + ")";
        }
        return str;
    }
}

