/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.apache.tika.detect;

import com.snowflake.client.jdbc.internal.apache.tika.io.CloseShieldInputStream;
import com.snowflake.client.jdbc.internal.apache.tika.sax.OfflineContentHandler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlRootExtractor {
    public QName extractRootElement(byte[] data) {
        return this.extractRootElement(new ByteArrayInputStream(data));
    }

    public QName extractRootElement(InputStream stream) {
        ExtractorHandler handler = new ExtractorHandler();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            try {
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (SAXNotRecognizedException e) {
                // empty catch block
            }
            factory.newSAXParser().parse((InputStream)new CloseShieldInputStream(stream), (DefaultHandler)new OfflineContentHandler(handler));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return handler.rootElement;
    }

    private static class ExtractorHandler
    extends DefaultHandler {
        private QName rootElement = null;

        private ExtractorHandler() {
        }

        @Override
        public void startElement(String uri, String local, String name, Attributes attributes) throws SAXException {
            this.rootElement = new QName(uri, local);
            throw new SAXException("Aborting: root element received");
        }
    }
}

