/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.amazonaws.services.s3.internal.crypto;

import com.snowflake.client.jdbc.internal.amazonaws.AmazonClientException;
import com.snowflake.client.jdbc.internal.amazonaws.AmazonWebServiceRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.kms.AWSKMSClient;
import com.snowflake.client.jdbc.internal.amazonaws.services.kms.model.DecryptRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.kms.model.DecryptResult;
import com.snowflake.client.jdbc.internal.amazonaws.services.kms.model.EncryptRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.kms.model.EncryptResult;
import com.snowflake.client.jdbc.internal.amazonaws.services.s3.KeyWrapException;
import com.snowflake.client.jdbc.internal.amazonaws.services.s3.internal.crypto.CipherLite;
import com.snowflake.client.jdbc.internal.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import com.snowflake.client.jdbc.internal.amazonaws.services.s3.internal.crypto.KMSSecuredCEK;
import com.snowflake.client.jdbc.internal.amazonaws.services.s3.internal.crypto.S3CryptoScheme;
import com.snowflake.client.jdbc.internal.amazonaws.services.s3.internal.crypto.S3KeyWrapScheme;
import com.snowflake.client.jdbc.internal.amazonaws.services.s3.internal.crypto.SecuredCEK;
import com.snowflake.client.jdbc.internal.amazonaws.services.s3.model.CryptoMode;
import com.snowflake.client.jdbc.internal.amazonaws.services.s3.model.EncryptionMaterials;
import com.snowflake.client.jdbc.internal.amazonaws.services.s3.model.EncryptionMaterialsAccessor;
import com.snowflake.client.jdbc.internal.amazonaws.services.s3.model.ExtraMaterialsDescription;
import com.snowflake.client.jdbc.internal.amazonaws.services.s3.model.KMSEncryptionMaterials;
import com.snowflake.client.jdbc.internal.amazonaws.services.s3.model.ObjectMetadata;
import com.snowflake.client.jdbc.internal.amazonaws.services.s3.model.S3Object;
import com.snowflake.client.jdbc.internal.amazonaws.util.Base64;
import com.snowflake.client.jdbc.internal.amazonaws.util.BinaryUtils;
import com.snowflake.client.jdbc.internal.amazonaws.util.Throwables;
import com.snowflake.client.jdbc.internal.amazonaws.util.json.Jackson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

final class ContentCryptoMaterial {
    private final String keyWrappingAlgorithm;
    private final CipherLite cipherLite;
    private final Map<String, String> kekMaterialsDescription;
    private final byte[] encryptedCEK;

    ContentCryptoMaterial(Map<String, String> kekMaterialsDescription, byte[] encryptedCEK, String keyWrappingAlgorithm, CipherLite cipherLite) {
        this.cipherLite = cipherLite;
        this.keyWrappingAlgorithm = keyWrappingAlgorithm;
        this.encryptedCEK = (byte[])encryptedCEK.clone();
        this.kekMaterialsDescription = kekMaterialsDescription;
    }

    String getKeyWrappingAlgorithm() {
        return this.keyWrappingAlgorithm;
    }

    private boolean usesKMSKey() {
        return KMSSecuredCEK.isKMSKeyWrapped(this.keyWrappingAlgorithm);
    }

    ContentCryptoScheme getContentCryptoScheme() {
        return this.cipherLite.getContentCryptoScheme();
    }

    ObjectMetadata toObjectMetadata(ObjectMetadata metadata, CryptoMode mode) {
        return mode == CryptoMode.EncryptionOnly && !this.usesKMSKey() ? this.toObjectMetadataEO(metadata) : this.toObjectMetadata(metadata);
    }

    private ObjectMetadata toObjectMetadata(ObjectMetadata metadata) {
        String keyWrapAlgo;
        byte[] encryptedCEK = this.getEncryptedCEK();
        metadata.addUserMetadata("x-amz-key-v2", Base64.encodeAsString(encryptedCEK));
        byte[] iv = this.cipherLite.getIV();
        metadata.addUserMetadata("x-amz-iv", Base64.encodeAsString(iv));
        metadata.addUserMetadata("x-amz-matdesc", this.kekMaterialDescAsJson());
        ContentCryptoScheme scheme = this.getContentCryptoScheme();
        metadata.addUserMetadata("x-amz-cek-alg", scheme.getCipherAlgorithm());
        int tagLen = scheme.getTagLengthInBits();
        if (tagLen > 0) {
            metadata.addUserMetadata("x-amz-tag-len", String.valueOf(tagLen));
        }
        if ((keyWrapAlgo = this.getKeyWrappingAlgorithm()) != null) {
            metadata.addUserMetadata("x-amz-wrap-alg", keyWrapAlgo);
        }
        return metadata;
    }

    private ObjectMetadata toObjectMetadataEO(ObjectMetadata metadata) {
        byte[] encryptedCEK = this.getEncryptedCEK();
        metadata.addUserMetadata("x-amz-key", Base64.encodeAsString(encryptedCEK));
        byte[] iv = this.cipherLite.getIV();
        metadata.addUserMetadata("x-amz-iv", Base64.encodeAsString(iv));
        metadata.addUserMetadata("x-amz-matdesc", this.kekMaterialDescAsJson());
        return metadata;
    }

    String toJsonString(CryptoMode mode) {
        return mode == CryptoMode.EncryptionOnly && !this.usesKMSKey() ? this.toJsonStringEO() : this.toJsonString();
    }

    private String toJsonString() {
        String keyWrapAlgo;
        HashMap<String, String> map = new HashMap<String, String>();
        byte[] encryptedCEK = this.getEncryptedCEK();
        map.put("x-amz-key-v2", Base64.encodeAsString(encryptedCEK));
        byte[] iv = this.cipherLite.getIV();
        map.put("x-amz-iv", Base64.encodeAsString(iv));
        map.put("x-amz-matdesc", this.kekMaterialDescAsJson());
        ContentCryptoScheme scheme = this.getContentCryptoScheme();
        map.put("x-amz-cek-alg", scheme.getCipherAlgorithm());
        int tagLen = scheme.getTagLengthInBits();
        if (tagLen > 0) {
            map.put("x-amz-tag-len", String.valueOf(tagLen));
        }
        if ((keyWrapAlgo = this.getKeyWrappingAlgorithm()) != null) {
            map.put("x-amz-wrap-alg", keyWrapAlgo);
        }
        return Jackson.toJsonString(map);
    }

    private String toJsonStringEO() {
        HashMap<String, String> map = new HashMap<String, String>();
        byte[] encryptedCEK = this.getEncryptedCEK();
        map.put("x-amz-key", Base64.encodeAsString(encryptedCEK));
        byte[] iv = this.cipherLite.getIV();
        map.put("x-amz-iv", Base64.encodeAsString(iv));
        map.put("x-amz-matdesc", this.kekMaterialDescAsJson());
        return Jackson.toJsonString(map);
    }

    private String kekMaterialDescAsJson() {
        Map<String, String> kekMaterialDesc = this.getKEKMaterialsDescription();
        if (kekMaterialDesc == null) {
            kekMaterialDesc = Collections.emptyMap();
        }
        return Jackson.toJsonString(kekMaterialDesc);
    }

    private static Map<String, String> matdescFromJson(String json) {
        Map map = Jackson.fromJsonString(json, Map.class);
        return map == null ? null : Collections.unmodifiableMap(map);
    }

    private static SecretKey cek(byte[] cekSecured, String keyWrapAlgo, EncryptionMaterials materials, Provider securityProvider, ContentCryptoScheme contentCryptoScheme, AWSKMSClient kms) {
        Key kek;
        if (KMSSecuredCEK.isKMSKeyWrapped(keyWrapAlgo)) {
            return ContentCryptoMaterial.cekByKMS(cekSecured, keyWrapAlgo, materials, contentCryptoScheme, kms);
        }
        if (materials.getKeyPair() != null ? (kek = materials.getKeyPair().getPrivate()) == null : (kek = materials.getSymmetricKey()) == null) {
            throw new AmazonClientException("Key encrypting key not available");
        }
        try {
            if (keyWrapAlgo != null) {
                Cipher cipher = securityProvider == null ? Cipher.getInstance(keyWrapAlgo) : Cipher.getInstance(keyWrapAlgo, securityProvider);
                cipher.init(4, kek);
                return (SecretKey)cipher.unwrap(cekSecured, keyWrapAlgo, 3);
            }
            Cipher cipher = securityProvider != null ? Cipher.getInstance(kek.getAlgorithm(), securityProvider) : Cipher.getInstance(kek.getAlgorithm());
            cipher.init(2, kek);
            byte[] decryptedSymmetricKeyBytes = cipher.doFinal(cekSecured);
            return new SecretKeySpec(decryptedSymmetricKeyBytes, "AES");
        }
        catch (Exception e) {
            throw Throwables.failure(e, "Unable to decrypt symmetric key from object metadata");
        }
    }

    private static SecretKey cekByKMS(byte[] cekSecured, String keyWrapAlgo, EncryptionMaterials materials, ContentCryptoScheme contentCryptoScheme, AWSKMSClient kms) {
        DecryptRequest kmsreq = new DecryptRequest().withEncryptionContext(materials.getMaterialsDescription()).withCiphertextBlob(ByteBuffer.wrap(cekSecured));
        DecryptResult result = kms.decrypt(kmsreq);
        return new SecretKeySpec(BinaryUtils.copyAllBytesFrom(result.getPlaintext()), contentCryptoScheme.getKeyGeneratorAlgorithm());
    }

    static ContentCryptoMaterial fromObjectMetadata(ObjectMetadata metadata, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, boolean keyWrapExpected, AWSKMSClient kms) {
        return ContentCryptoMaterial.fromObjectMetadata0(metadata, kekMaterialAccessor, securityProvider, null, ExtraMaterialsDescription.NONE, keyWrapExpected, kms);
    }

    static ContentCryptoMaterial fromObjectMetadata(ObjectMetadata metadata, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, long[] range, ExtraMaterialsDescription extra, boolean keyWrapExpected, AWSKMSClient kms) {
        return ContentCryptoMaterial.fromObjectMetadata0(metadata, kekMaterialAccessor, securityProvider, range, extra, keyWrapExpected, kms);
    }

    private static ContentCryptoMaterial fromObjectMetadata0(ObjectMetadata metadata, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, long[] range, ExtraMaterialsDescription extra, boolean keyWrapExpected, AWSKMSClient kms) {
        EncryptionMaterials materials;
        Map<String, String> merged;
        Map<String, String> userMeta = metadata.getUserMetadata();
        String b64key = userMeta.get("x-amz-key-v2");
        if (b64key == null && (b64key = userMeta.get("x-amz-key")) == null) {
            throw new AmazonClientException("Content encrypting key not found.");
        }
        byte[] cekWrapped = Base64.decode(b64key);
        byte[] iv = Base64.decode(userMeta.get("x-amz-iv"));
        if (cekWrapped == null || iv == null) {
            throw new AmazonClientException("Content encrypting key or IV not found.");
        }
        String matdescStr = userMeta.get("x-amz-matdesc");
        String keyWrapAlgo = userMeta.get("x-amz-wrap-alg");
        boolean isKMS = KMSSecuredCEK.isKMSKeyWrapped(keyWrapAlgo);
        Map<String, String> core = ContentCryptoMaterial.matdescFromJson(matdescStr);
        Map<String, String> map = merged = isKMS || extra == null ? core : extra.mergeInto(core);
        if (isKMS) {
            materials = new KMSEncryptionMaterials(core.get("kms_cmk_id"));
            materials.addDescriptions(core);
        } else {
            EncryptionMaterials encryptionMaterials = materials = kekMaterialAccessor == null ? null : kekMaterialAccessor.getEncryptionMaterials(merged);
            if (materials == null) {
                throw new AmazonClientException("Unable to retrieve the client encryption materials");
            }
        }
        String cekAlgo = userMeta.get("x-amz-cek-alg");
        boolean isRangeGet = range != null;
        ContentCryptoScheme contentCryptoScheme = ContentCryptoScheme.fromCEKAlgo(cekAlgo, isRangeGet);
        if (isRangeGet) {
            iv = contentCryptoScheme.adjustIV(iv, range[0]);
        } else {
            String s;
            int tagLenActual;
            int tagLenExpected = contentCryptoScheme.getTagLengthInBits();
            if (tagLenExpected > 0 && tagLenExpected != (tagLenActual = Integer.parseInt(s = userMeta.get("x-amz-tag-len")))) {
                throw new AmazonClientException("Unsupported tag length: " + tagLenActual + ", expected: " + tagLenExpected);
            }
        }
        if (keyWrapExpected && keyWrapAlgo == null) {
            throw ContentCryptoMaterial.newKeyWrapException();
        }
        SecretKey cek = ContentCryptoMaterial.cek(cekWrapped, keyWrapAlgo, materials, securityProvider, contentCryptoScheme, kms);
        return new ContentCryptoMaterial(merged, cekWrapped, keyWrapAlgo, contentCryptoScheme.createCipherLite(cek, iv, 2, securityProvider));
    }

    private static KeyWrapException newKeyWrapException() {
        return new KeyWrapException("Missing key-wrap for the content-encrypting-key");
    }

    static ContentCryptoMaterial fromInstructionFile(Map<String, String> instFile, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, boolean keyWrapExpected, AWSKMSClient kms) {
        return ContentCryptoMaterial.fromInstructionFile0(instFile, kekMaterialAccessor, securityProvider, null, ExtraMaterialsDescription.NONE, keyWrapExpected, kms);
    }

    static ContentCryptoMaterial fromInstructionFile(Map<String, String> instFile, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, long[] range, ExtraMaterialsDescription extra, boolean keyWrapExpected, AWSKMSClient kms) {
        return ContentCryptoMaterial.fromInstructionFile0(instFile, kekMaterialAccessor, securityProvider, range, extra, keyWrapExpected, kms);
    }

    private static ContentCryptoMaterial fromInstructionFile0(Map<String, String> instFile, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, long[] range, ExtraMaterialsDescription extra, boolean keyWrapExpected, AWSKMSClient kms) {
        EncryptionMaterials materials;
        Map<String, String> merged;
        String b64key = instFile.get("x-amz-key-v2");
        if (b64key == null && (b64key = instFile.get("x-amz-key")) == null) {
            throw new AmazonClientException("Content encrypting key not found.");
        }
        byte[] cekWrapped = Base64.decode(b64key);
        byte[] iv = Base64.decode(instFile.get("x-amz-iv"));
        if (cekWrapped == null || iv == null) {
            throw new AmazonClientException("Necessary encryption info not found in the instruction file " + instFile);
        }
        String keyWrapAlgo = instFile.get("x-amz-wrap-alg");
        boolean isKMS = KMSSecuredCEK.isKMSKeyWrapped(keyWrapAlgo);
        String matdescStr = instFile.get("x-amz-matdesc");
        Map<String, String> core = ContentCryptoMaterial.matdescFromJson(matdescStr);
        Map<String, String> map = merged = extra == null || isKMS ? core : extra.mergeInto(core);
        if (isKMS) {
            materials = new KMSEncryptionMaterials(core.get("kms_cmk_id"));
            materials.addDescriptions(core);
        } else {
            EncryptionMaterials encryptionMaterials = materials = kekMaterialAccessor == null ? null : kekMaterialAccessor.getEncryptionMaterials(merged);
            if (materials == null) {
                throw new AmazonClientException("Unable to retrieve the encryption materials that originally encrypted object corresponding to instruction file " + instFile);
            }
        }
        String cekAlgo = instFile.get("x-amz-cek-alg");
        boolean isRangeGet = range != null;
        ContentCryptoScheme contentCryptoScheme = ContentCryptoScheme.fromCEKAlgo(cekAlgo, isRangeGet);
        if (isRangeGet) {
            iv = contentCryptoScheme.adjustIV(iv, range[0]);
        } else {
            String s;
            int tagLenActual;
            int tagLenExpected = contentCryptoScheme.getTagLengthInBits();
            if (tagLenExpected > 0 && tagLenExpected != (tagLenActual = Integer.parseInt(s = instFile.get("x-amz-tag-len")))) {
                throw new AmazonClientException("Unsupported tag length: " + tagLenActual + ", expected: " + tagLenExpected);
            }
        }
        if (keyWrapExpected && keyWrapAlgo == null) {
            throw ContentCryptoMaterial.newKeyWrapException();
        }
        SecretKey cek = ContentCryptoMaterial.cek(cekWrapped, keyWrapAlgo, materials, securityProvider, contentCryptoScheme, kms);
        return new ContentCryptoMaterial(merged, cekWrapped, keyWrapAlgo, contentCryptoScheme.createCipherLite(cek, iv, 2, securityProvider));
    }

    static String parseInstructionFile(S3Object instructionFile) {
        try {
            return ContentCryptoMaterial.convertStreamToString(instructionFile.getObjectContent());
        }
        catch (Exception e) {
            throw Throwables.failure(e, "Error parsing JSON instruction file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        finally {
            inputStream.close();
        }
        return stringBuilder.toString();
    }

    CipherLite getCipherLite() {
        return this.cipherLite;
    }

    Map<String, String> getKEKMaterialsDescription() {
        return this.kekMaterialsDescription;
    }

    byte[] getEncryptedCEK() {
        return (byte[])this.encryptedCEK.clone();
    }

    ContentCryptoMaterial recreate(Map<String, String> newKEKMatDesc, EncryptionMaterialsAccessor accessor, S3CryptoScheme targetScheme, Provider p, AWSKMSClient kms, AmazonWebServiceRequest req) {
        if (!this.usesKMSKey() && newKEKMatDesc.equals(this.kekMaterialsDescription)) {
            throw new SecurityException("Material description of the new KEK must differ from the current one");
        }
        EncryptionMaterials origKEK = this.usesKMSKey() ? new KMSEncryptionMaterials(this.kekMaterialsDescription.get("kms_cmk_id")) : accessor.getEncryptionMaterials(this.kekMaterialsDescription);
        EncryptionMaterials newKEK = accessor.getEncryptionMaterials(newKEKMatDesc);
        if (newKEK == null) {
            throw new AmazonClientException("No material available with the description " + newKEKMatDesc + " from the encryption material provider");
        }
        SecretKey cek = ContentCryptoMaterial.cek(this.encryptedCEK, this.keyWrappingAlgorithm, origKEK, p, this.getContentCryptoScheme(), kms);
        ContentCryptoMaterial output = ContentCryptoMaterial.create(cek, this.cipherLite.getIV(), newKEK, this.getContentCryptoScheme(), targetScheme, p, kms, req);
        if (Arrays.equals(output.encryptedCEK, this.encryptedCEK)) {
            throw new SecurityException("The new KEK must differ from the original");
        }
        return output;
    }

    ContentCryptoMaterial recreate(EncryptionMaterials newKEK, EncryptionMaterialsAccessor accessor, S3CryptoScheme targetScheme, Provider p, AWSKMSClient kms, AmazonWebServiceRequest req) {
        if (!this.usesKMSKey() && newKEK.getMaterialsDescription().equals(this.kekMaterialsDescription)) {
            throw new SecurityException("Material description of the new KEK must differ from the current one");
        }
        EncryptionMaterials origKEK = this.usesKMSKey() ? new KMSEncryptionMaterials(this.kekMaterialsDescription.get("kms_cmk_id")) : accessor.getEncryptionMaterials(this.kekMaterialsDescription);
        SecretKey cek = ContentCryptoMaterial.cek(this.encryptedCEK, this.keyWrappingAlgorithm, origKEK, p, this.getContentCryptoScheme(), kms);
        ContentCryptoMaterial output = ContentCryptoMaterial.create(cek, this.cipherLite.getIV(), newKEK, this.getContentCryptoScheme(), targetScheme, p, kms, req);
        if (Arrays.equals(output.encryptedCEK, this.encryptedCEK)) {
            throw new SecurityException("The new KEK must differ from the original");
        }
        return output;
    }

    static ContentCryptoMaterial create(SecretKey cek, byte[] iv, EncryptionMaterials kekMaterials, ContentCryptoScheme contentCryptoScheme, S3CryptoScheme targetScheme, Provider provider, AWSKMSClient kms, AmazonWebServiceRequest req) {
        return ContentCryptoMaterial.doCreate(cek, iv, kekMaterials, contentCryptoScheme, targetScheme, provider, kms, req);
    }

    static ContentCryptoMaterial create(SecretKey cek, byte[] iv, EncryptionMaterials kekMaterials, S3CryptoScheme scheme, Provider provider, AWSKMSClient kms, AmazonWebServiceRequest req) {
        return ContentCryptoMaterial.doCreate(cek, iv, kekMaterials, scheme.getContentCryptoScheme(), scheme, provider, kms, req);
    }

    private static ContentCryptoMaterial doCreate(SecretKey cek, byte[] iv, EncryptionMaterials kekMaterials, ContentCryptoScheme contentCryptoScheme, S3CryptoScheme targetS3CryptoScheme, Provider provider, AWSKMSClient kms, AmazonWebServiceRequest req) {
        SecuredCEK cekSecured = ContentCryptoMaterial.secureCEK(cek, kekMaterials, targetS3CryptoScheme.getKeyWrapScheme(), targetS3CryptoScheme.getSecureRandom(), provider, kms, req);
        return ContentCryptoMaterial.wrap(cek, iv, kekMaterials, contentCryptoScheme, provider, cekSecured);
    }

    public static ContentCryptoMaterial wrap(SecretKey cek, byte[] iv, EncryptionMaterials kekMaterials, ContentCryptoScheme contentCryptoScheme, Provider provider, SecuredCEK cekSecured) {
        return new ContentCryptoMaterial(kekMaterials.getMaterialsDescription(), cekSecured.getEncrypted(), cekSecured.getKeyWrapAlgorithm(), contentCryptoScheme.createCipherLite(cek, iv, 1, provider));
    }

    private static SecuredCEK secureCEK(SecretKey cek, EncryptionMaterials materials, S3KeyWrapScheme kwScheme, SecureRandom srand, Provider p, AWSKMSClient kms, AmazonWebServiceRequest req) {
        if (materials.isKMSEnabled()) {
            EncryptRequest encryptRequest = new EncryptRequest().withEncryptionContext(materials.getMaterialsDescription()).withKeyId(materials.getCustomerMasterKeyId()).withPlaintext(ByteBuffer.wrap(cek.getEncoded()));
            ((AmazonWebServiceRequest)encryptRequest.withGeneralProgressListener(req.getGeneralProgressListener())).withRequestMetricCollector(req.getRequestMetricCollector());
            EncryptResult encryptResult = kms.encrypt(encryptRequest);
            byte[] keyBlob = BinaryUtils.copyAllBytesFrom(encryptResult.getCiphertextBlob());
            return new KMSSecuredCEK(keyBlob);
        }
        Key kek = materials.getKeyPair() != null ? materials.getKeyPair().getPublic() : materials.getSymmetricKey();
        String keyWrapAlgo = kwScheme.getKeyWrapAlgorithm(kek);
        try {
            if (keyWrapAlgo != null) {
                Cipher cipher = p == null ? Cipher.getInstance(keyWrapAlgo) : Cipher.getInstance(keyWrapAlgo, p);
                cipher.init(3, kek, srand);
                return new SecuredCEK(cipher.wrap(cek), keyWrapAlgo);
            }
            byte[] toBeEncryptedBytes = cek.getEncoded();
            String algo = kek.getAlgorithm();
            Cipher cipher = p != null ? Cipher.getInstance(algo, p) : Cipher.getInstance(algo);
            cipher.init(1, kek);
            return new SecuredCEK(cipher.doFinal(toBeEncryptedBytes), null);
        }
        catch (Exception e) {
            throw Throwables.failure(e, "Unable to encrypt symmetric key");
        }
    }
}

