/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.transform;

import com.snowflake.client.jdbc.internal.amazonaws.AmazonClientException;
import com.snowflake.client.jdbc.internal.amazonaws.DefaultRequest;
import com.snowflake.client.jdbc.internal.amazonaws.Request;
import com.snowflake.client.jdbc.internal.amazonaws.http.HttpMethodName;
import com.snowflake.client.jdbc.internal.amazonaws.internal.ListWithAutoConstructFlag;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.FilterLogEventsRequest;
import com.snowflake.client.jdbc.internal.amazonaws.transform.Marshaller;
import com.snowflake.client.jdbc.internal.amazonaws.util.StringInputStream;
import com.snowflake.client.jdbc.internal.amazonaws.util.StringUtils;
import com.snowflake.client.jdbc.internal.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class FilterLogEventsRequestMarshaller
implements Marshaller<Request<FilterLogEventsRequest>, FilterLogEventsRequest> {
    @Override
    public Request<FilterLogEventsRequest> marshall(FilterLogEventsRequest filterLogEventsRequest) {
        if (filterLogEventsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<FilterLogEventsRequest> request = new DefaultRequest<FilterLogEventsRequest>(filterLogEventsRequest, "AWSLogs");
        String target = "Logs_20140328.FilterLogEvents";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag logStreamNamesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (filterLogEventsRequest.getLogGroupName() != null) {
                jsonWriter.key("logGroupName").value(filterLogEventsRequest.getLogGroupName());
            }
            if (!((logStreamNamesList = (ListWithAutoConstructFlag)filterLogEventsRequest.getLogStreamNames()) == null || logStreamNamesList.isAutoConstruct() && logStreamNamesList.isEmpty())) {
                jsonWriter.key("logStreamNames");
                jsonWriter.array();
                for (String logStreamNamesListValue : logStreamNamesList) {
                    if (logStreamNamesListValue == null) continue;
                    jsonWriter.value(logStreamNamesListValue);
                }
                jsonWriter.endArray();
            }
            if (filterLogEventsRequest.getStartTime() != null) {
                jsonWriter.key("startTime").value(filterLogEventsRequest.getStartTime());
            }
            if (filterLogEventsRequest.getEndTime() != null) {
                jsonWriter.key("endTime").value(filterLogEventsRequest.getEndTime());
            }
            if (filterLogEventsRequest.getFilterPattern() != null) {
                jsonWriter.key("filterPattern").value(filterLogEventsRequest.getFilterPattern());
            }
            if (filterLogEventsRequest.getNextToken() != null) {
                jsonWriter.key("nextToken").value(filterLogEventsRequest.getNextToken());
            }
            if (filterLogEventsRequest.getLimit() != null) {
                jsonWriter.key("limit").value(filterLogEventsRequest.getLimit());
            }
            if (filterLogEventsRequest.isInterleaved() != null) {
                jsonWriter.key("interleaved").value(filterLogEventsRequest.isInterleaved());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

