/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.amazonaws.http;

import com.snowflake.client.jdbc.internal.amazonaws.ClientConfiguration;
import com.snowflake.client.jdbc.internal.amazonaws.http.IdleConnectionReaper;
import com.snowflake.client.jdbc.internal.apache.http.impl.conn.PoolingClientConnectionManager;
import com.snowflake.client.jdbc.internal.apache.http.impl.conn.SchemeRegistryFactory;
import com.snowflake.client.jdbc.internal.apache.http.params.HttpParams;
import java.util.concurrent.TimeUnit;

class ConnectionManagerFactory {
    ConnectionManagerFactory() {
    }

    public static PoolingClientConnectionManager createPoolingClientConnManager(ClientConfiguration config, HttpParams httpClientParams) {
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager(SchemeRegistryFactory.createDefault(), config.getConnectionTTL(), TimeUnit.MILLISECONDS);
        connectionManager.setDefaultMaxPerRoute(config.getMaxConnections());
        connectionManager.setMaxTotal(config.getMaxConnections());
        if (config.useReaper()) {
            IdleConnectionReaper.registerConnectionManager(connectionManager);
        }
        return connectionManager;
    }
}

