/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc;

import com.snowflake.client.core.ResultUtil;
import com.snowflake.client.core.SFBaseResultSet;
import com.snowflake.client.core.SFException;
import com.snowflake.client.core.SFStatement;
import com.snowflake.client.core.SFStatementType;
import com.snowflake.client.jdbc.ErrorCode;
import com.snowflake.client.jdbc.SnowflakeConnectionV1;
import com.snowflake.client.jdbc.SnowflakeResultSetMetaDataV1;
import com.snowflake.client.jdbc.SnowflakeResultSetV1;
import com.snowflake.client.jdbc.SnowflakeSQLException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SnowflakeStatementV1
implements Statement {
    static final Logger logger = Logger.getLogger(SnowflakeStatementV1.class.getName());
    private SnowflakeConnectionV1 connection;
    private int maxRows = 0;
    private ResultSet resultSet = null;
    private ResultSet currentResultSet = null;
    private int fetchSize = 50;
    private Boolean isClosed = false;
    private int updateCount = -1;
    private boolean escapeProcessing = false;
    private int queryTimeout = 0;
    private int maxFieldSize = 0x1000000;
    private SFStatement sfStatement;

    public SnowflakeStatementV1(SnowflakeConnectionV1 conn) {
        logger.log(Level.FINER, " public SnowflakeStatement(SnowflakeConnectionV1 conn)");
        this.connection = conn;
        this.sfStatement = new SFStatement(conn.getSfSession());
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.executeQueryInternal(sql, null);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.executeUpdateInternal(sql, null);
    }

    public int executeUpdateInternal(String sql, Map<String, Map<String, Object>> parameterBindings) throws SQLException {
        if (parameterBindings != null) {
            for (Map.Entry<String, Map<String, Object>> parameterBindingEntry : parameterBindings.entrySet()) {
                if (parameterBindingEntry.getValue().get("value") instanceof String) {
                    this.sfStatement.setValue(parameterBindingEntry.getKey(), (String)parameterBindingEntry.getValue().get("value"), (String)parameterBindingEntry.getValue().get("type"));
                    continue;
                }
                this.sfStatement.setValues(parameterBindingEntry.getKey(), (List)parameterBindingEntry.getValue().get("value"), (String)parameterBindingEntry.getValue().get("type"));
            }
        }
        SFBaseResultSet sfResultSet = null;
        try {
            sfResultSet = this.sfStatement.execute(sql);
            sfResultSet.setSession(this.connection.getSfSession());
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
        SnowflakeResultSetV1 rset = new SnowflakeResultSetV1(sfResultSet, this);
        this.updateCount = ResultUtil.calculateUpdateCount(rset, rset.getStatementTypeId());
        return this.updateCount;
    }

    protected ResultSet executeQueryInternal(String sql, Map<String, Map<String, Object>> parameterBindings) throws SQLException {
        this.resetState();
        if (parameterBindings != null) {
            for (Map.Entry<String, Map<String, Object>> parameterBindingEntry : parameterBindings.entrySet()) {
                if (parameterBindingEntry.getValue().get("value") instanceof String) {
                    this.sfStatement.setValue(parameterBindingEntry.getKey(), (String)parameterBindingEntry.getValue().get("value"), (String)parameterBindingEntry.getValue().get("type"));
                    continue;
                }
                this.sfStatement.setValues(parameterBindingEntry.getKey(), (List)parameterBindingEntry.getValue().get("value"), (String)parameterBindingEntry.getValue().get("type"));
            }
        }
        SFBaseResultSet sfResultSet = null;
        try {
            sfResultSet = this.sfStatement.execute(sql);
            sfResultSet.setSession(this.connection.getSfSession());
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
        this.resultSet = new SnowflakeResultSetV1(sfResultSet, this);
        return this.getResultSet();
    }

    protected ResultSetMetaData describeQueryInternal(String sql, Map<String, Map<String, Object>> parameterBindings) throws SQLException {
        if (parameterBindings != null) {
            for (Map.Entry<String, Map<String, Object>> parameterBindingEntry : parameterBindings.entrySet()) {
                if (parameterBindingEntry.getValue().get("value") instanceof String) {
                    this.sfStatement.setValue(parameterBindingEntry.getKey(), (String)parameterBindingEntry.getValue().get("value"), (String)parameterBindingEntry.getValue().get("type"));
                    continue;
                }
                this.sfStatement.setValues(parameterBindingEntry.getKey(), (List)parameterBindingEntry.getValue().get("value"), (String)parameterBindingEntry.getValue().get("type"));
            }
        }
        try {
            return new SnowflakeResultSetMetaDataV1(this.sfStatement.describe(sql).getResultSetMetaData());
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    public boolean isFileTransfer(String sql) {
        if (sql == null) {
            return false;
        }
        String trimmedSql = sql.trim();
        while (trimmedSql.startsWith("//")) {
            logger.log(Level.FINER, "skipping // comments in: \n" + trimmedSql);
            if (trimmedSql.indexOf(10) <= 0) break;
            trimmedSql = trimmedSql.substring(trimmedSql.indexOf(10));
            trimmedSql = trimmedSql.trim();
            logger.log(Level.FINER, "New sql after skipping // comments: \n" + trimmedSql);
        }
        while (trimmedSql.startsWith("/*")) {
            logger.log(Level.FINER, "skipping /* */ comments in: \n" + trimmedSql);
            if (trimmedSql.indexOf("*/") <= 0) break;
            trimmedSql = trimmedSql.substring(trimmedSql.indexOf("*/") + 2);
            trimmedSql = trimmedSql.trim();
            logger.log(Level.FINER, "New sql after skipping /* */ comments: \n" + trimmedSql);
        }
        return trimmedSql.length() >= 4 && (trimmedSql.toLowerCase().startsWith("put ") || trimmedSql.toLowerCase().startsWith("get "));
    }

    void sanityCheckQuery(String sql) throws SQLException {
        if (sql == null || sql.isEmpty()) {
            throw new SnowflakeSQLException("03000", ErrorCode.INVALID_SQL.getMessageCode(), sql);
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.sanityCheckQuery(sql);
        this.connection.injectedDelay();
        logger.log(Level.FINER, "execute: " + sql);
        String trimmedSql = sql.trim();
        if (trimmedSql.length() >= 20 && trimmedSql.toLowerCase().startsWith("set-sf-property")) {
            this.executeSetProperty(sql);
            return false;
        }
        SnowflakeResultSetV1 rSet = (SnowflakeResultSetV1)this.executeQuery(sql);
        if (this.connection.getSfSession().isExecuteReturnCountForDML() && (SFStatementType.isDML(rSet.getStatementTypeId()) || SFStatementType.isDDL(rSet.getStatementTypeId()))) {
            this.updateCount = ResultUtil.calculateUpdateCount(rSet, rSet.getStatementTypeId());
            this.resultSet = null;
            this.currentResultSet = null;
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        logger.log(Level.FINER, "public boolean execute(String sql, int[] columnIndexes)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        logger.log(Level.FINER, "public boolean execute(String sql, String[] columnNames)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        logger.log(Level.FINER, "public int[] executeBatch()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        logger.log(Level.FINER, "public int executeUpdate(String sql, int autoGeneratedKeys)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        logger.log(Level.FINER, "public int executeUpdate(String sql, int[] columnIndexes)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        logger.log(Level.FINER, "public int executeUpdate(String sql, String[] columnNames)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Connection getConnection() throws SQLException {
        logger.log(Level.FINER, "public Connection getConnection()");
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        logger.log(Level.FINER, "public int getFetchDirection()");
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        logger.log(Level.FINER, "public int getFetchSize()");
        return this.fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        logger.log(Level.FINER, "public ResultSet getGeneratedKeys()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        logger.log(Level.FINER, "public int getMaxFieldSize()");
        return this.maxFieldSize;
    }

    @Override
    public int getMaxRows() throws SQLException {
        logger.log(Level.FINER, "public int getMaxRows()");
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        logger.log(Level.FINER, "public boolean getMoreResults()");
        if (this.currentResultSet != null) {
            this.currentResultSet.close();
            this.currentResultSet = null;
        }
        if (this.resultSet != null) {
            this.currentResultSet = this.resultSet;
            this.resultSet = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        logger.log(Level.FINER, "public boolean getMoreResults(int current)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        logger.log(Level.FINER, "public int getQueryTimeout()");
        return this.queryTimeout;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        logger.log(Level.FINER, "public ResultSet getResultSet()");
        if (this.currentResultSet == null) {
            this.currentResultSet = this.resultSet;
            this.resultSet = null;
        }
        return this.currentResultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        logger.log(Level.FINER, "public int getResultSetConcurrency()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        logger.log(Level.FINER, "public int getResultSetHoldability()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetType() throws SQLException {
        logger.log(Level.FINER, "public int getResultSetType()");
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        logger.log(Level.FINER, "public int getUpdateCount()");
        return this.updateCount;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        logger.log(Level.FINER, "public SQLWarning getWarnings()");
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        logger.log(Level.FINER, "public boolean isClosed()");
        return this.isClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        logger.log(Level.FINER, "public boolean isPoolable()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        logger.log(Level.FINER, "public void setCursorName(String name)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        logger.log(Level.FINER, "public void setEscapeProcessing(boolean enable)");
        this.escapeProcessing = true;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        logger.log(Level.FINER, "public void setFetchDirection(int direction)");
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        logger.log(Level.FINER, "public void setFetchSize(int rows), rows=" + rows);
        this.fetchSize = rows;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        logger.log(Level.FINER, "public void setMaxFieldSize(int max)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        logger.log(Level.FINER, "public void setMaxRows(int max)");
        this.maxRows = max;
        try {
            if (this.sfStatement != null) {
                this.sfStatement.addProperty("rows_per_resultset", max);
            }
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        logger.log(Level.FINER, "public void setPoolable(boolean poolable)");
        if (poolable) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        logger.log(Level.FINER, "public void setQueryTimeout(int seconds)");
        this.queryTimeout = seconds;
        try {
            if (this.sfStatement != null) {
                this.sfStatement.addProperty("query_timeout", seconds);
            }
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        logger.log(Level.FINER, "public boolean isWrapperFor(Class<?> iface)");
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        logger.log(Level.FINER, "public <T> T unwrap(Class<T> iface)");
        if (!iface.isInstance(this)) {
            throw new SQLException(this.getClass().getName() + " not unwrappable from " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        logger.log(Level.FINER, "public void closeOnCompletion()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        logger.log(Level.FINER, "public boolean isCloseOnCompletion()");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void close() throws SQLException {
        logger.log(Level.FINER, "public void close()");
        this.currentResultSet = null;
        this.resultSet = null;
        this.isClosed = true;
        this.sfStatement.close();
    }

    @Override
    public void cancel() throws SQLException {
        logger.log(Level.FINER, "public void cancel()");
        try {
            this.sfStatement.cancel();
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex, ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        logger.log(Level.FINER, "public void clearWarnings()");
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        logger.log(Level.FINER, "public void addBatch(String sql)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearBatch() throws SQLException {
        logger.log(Level.FINER, "public void clearBatch()");
        throw new SQLFeatureNotSupportedException();
    }

    public void executeSetProperty(String sql) {
        logger.log(Level.FINER, "setting property");
        String[] tokens = sql.split("\\s+");
        if (tokens == null || tokens.length < 2) {
            return;
        }
        if ("tracing".equalsIgnoreCase(tokens[1])) {
            if (tokens.length >= 3) {
                this.connection.tracingLevel = Level.parse(tokens[2].toUpperCase());
                if (this.connection.tracingLevel != null) {
                    Logger snowflakeLogger = Logger.getLogger("com.snowflake");
                    snowflakeLogger.setLevel(this.connection.tracingLevel);
                }
            }
        } else {
            this.sfStatement.executeSetProperty(sql);
        }
    }

    public SFStatement getSfStatement() {
        return this.sfStatement;
    }

    public void setUpdateCount(int updateCount) {
        this.updateCount = updateCount;
    }

    private void resetState() {
        this.resultSet = null;
        this.currentResultSet = null;
        this.isClosed = false;
        this.updateCount = -1;
    }
}

