/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.core;

import com.snowflake.client.core.HeartbeatBackground;
import com.snowflake.client.core.HttpUtil;
import com.snowflake.client.core.IncidentUtil;
import com.snowflake.client.core.SFException;
import com.snowflake.client.core.SFSessionProperty;
import com.snowflake.client.core.SessionUtil;
import com.snowflake.client.jdbc.ErrorCode;
import com.snowflake.client.jdbc.SnowflakeSQLException;
import com.snowflake.client.jdbc.SnowflakeUtil;
import com.snowflake.client.jdbc.internal.apache.http.client.HttpClient;
import com.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPost;
import com.snowflake.client.jdbc.internal.apache.http.client.utils.URIBuilder;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import com.snowflake.gscommon.core.ResourceBundleManager;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SFSession {
    static final Logger logger = Logger.getLogger(SFSession.class.getName());
    private static final String SF_PATH_SESSION_HEARTBEAT = "/session/heartbeat";
    private static final String SF_PATH_AUTHENTICATOR_REQUEST = "/session/authenticator-request";
    public static final String SF_QUERY_REQUEST_ID = "requestId";
    public static final String SF_HEADER_AUTHORIZATION = "Authorization";
    public static final String SF_HEADER_BASIC_AUTHTYPE = "Basic";
    public static final String SF_HEADER_SNOWFLAKE_AUTHTYPE = "Snowflake";
    public static final String SF_HEADER_TOKEN_TAG = "Token";
    private static int SF_HEARTBEAT_TIMEOUT = 60;
    private HttpClient httpClient;
    private boolean isClosed = true;
    private String sessionToken;
    private String masterToken;
    private long masterTokenValidityInSeconds;
    private String remMeToken;
    private String samlResponse;
    private String newClientForUpdate;
    private AtomicInteger _injectedDelay = new AtomicInteger(0);
    private String databaseVersion = null;
    private int databaseMajorVersion = 0;
    private int databaseMinorVersion = 0;
    private AtomicInteger sequenceId = new AtomicInteger(0);
    private int loginTimeout = 60;
    private int networkTimeoutInMilli = 0;
    private int queryTimeout = 0;
    private boolean useProxy = false;
    private boolean abortDetachedQuery = true;
    private Map sessionProperties = new HashMap(1);
    private static final ObjectMapper mapper = new ObjectMapper();
    static final ResourceBundleManager errorResourceBundleManager = ResourceBundleManager.getSingleton("com.snowflake.common_error_messages");
    private Properties clientInfo = new Properties();
    private int healthCheckInterval = 45;
    private int httpClientConnectionTimeout = 60000;
    private static int DEFAULT_HTTP_CLIENT_SOCKET_TIMEOUT = 300000;
    private int httpClientSocketTimeout = DEFAULT_HTTP_CLIENT_SOCKET_TIMEOUT;
    private int transactionIsolation = 0;
    private int injectSocketTimeout = 0;
    private int injectClientPause = 0;
    private String injectFileUploadFailure = null;
    private HeartbeatBackground heartbeatBackground;
    Map<SFSessionProperty, Object> connectionPropertiesMap = new HashMap<SFSessionProperty, Object>();
    Map<String, Object> sessionParametersMap = new HashMap<String, Object>();
    private static final int MAX_SESSION_PARAMETERS = 1000;
    private boolean passcodeInPassword = false;
    private boolean executeReturnCountForDML = false;
    private boolean enableHeartbeat = false;
    private AtomicBoolean autoCommit = new AtomicBoolean(true);

    public void addProperty(String propertyName, Object propertyValue) throws SFException {
        block17: {
            block16: {
                SFSessionProperty connectionProperty = SFSessionProperty.lookupByKey(propertyName);
                if (connectionProperty == null) break block16;
                if (propertyValue != null && !connectionProperty.getValueType().isAssignableFrom(propertyValue.getClass())) {
                    throw new SFException(ErrorCode.INVALID_PARAMETER_TYPE, propertyValue.getClass().getName(), connectionProperty.getValueType().getName());
                }
                if (this.connectionPropertiesMap.containsKey((Object)connectionProperty)) {
                    throw new SFException(ErrorCode.DUPLICATE_CONNECTION_PROPERTY_SPECIFIED, propertyName);
                }
                this.connectionPropertiesMap.put(connectionProperty, propertyValue);
                switch (connectionProperty) {
                    case LOGIN_TIMEOUT: {
                        if (propertyValue != null) {
                            this.loginTimeout = (Integer)propertyValue;
                            break;
                        }
                        break block17;
                    }
                    case NETWORK_TIMEOUT: {
                        if (propertyValue != null) {
                            this.networkTimeoutInMilli = (Integer)propertyValue;
                            break;
                        }
                        break block17;
                    }
                    case USE_PROXY: {
                        this.useProxy = propertyValue != null && (Boolean)propertyValue != false;
                        break;
                    }
                    case INJECT_CLIENT_PAUSE: {
                        if (propertyValue != null) {
                            this.injectClientPause = (Integer)propertyValue;
                            break;
                        }
                        break block17;
                    }
                    case INJECT_SOCKET_TIMEOUT: {
                        if (propertyValue != null) {
                            this.injectSocketTimeout = (Integer)propertyValue;
                            break;
                        }
                        break block17;
                    }
                    case PASSCODE_IN_PASSWORD: {
                        this.passcodeInPassword = propertyValue != null && (Boolean)propertyValue != false;
                        break;
                    }
                }
                break block17;
            }
            if (this.sessionParametersMap.containsKey(propertyName)) {
                throw new SFException(ErrorCode.DUPLICATE_CONNECTION_PROPERTY_SPECIFIED, propertyName);
            }
            this.sessionParametersMap.put(propertyName, propertyValue);
            if (this.sessionParametersMap.size() > 1000) {
                throw new SFException(ErrorCode.TOO_MANY_SESSION_PARAMETERS, 1000);
            }
        }
    }

    protected String getServerUrl() {
        if (this.connectionPropertiesMap.containsKey((Object)SFSessionProperty.SERVER_URL)) {
            return (String)this.connectionPropertiesMap.get((Object)SFSessionProperty.SERVER_URL);
        }
        return null;
    }

    public synchronized void open() throws SFException, SnowflakeSQLException {
        this.performSanityCheckOnProperties();
        if (this.httpClient == null) {
            this.httpClient = HttpUtil.getHttpClient();
        }
        SessionUtil.LoginInput loginInput = new SessionUtil.LoginInput();
        loginInput.setServerUrl((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.SERVER_URL)).setDatabaseName((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.DATABASE)).setSchemaName((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.SCHEMA)).setWarehouse((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.WAREHOUSE)).setRole((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.ROLE)).setAuthenticator((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.AUTHENTICATOR)).setHttpClient(this.httpClient).setAccountName((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.ACCOUNT)).setLoginTimeout(this.loginTimeout).setUserName((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.USER)).setPassword((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.PASSWORD)).setClientInfo(this.getClientInfo()).setPasscodeInPassword(this.passcodeInPassword).setPasscode((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.PASSCODE)).setConnectionTimeout(this.httpClientConnectionTimeout).setSocketTimeout(this.httpClientSocketTimeout).setAppId((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.APP_ID)).setAppVersion((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.APP_VERSION)).setAppBuildId((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.APP_BUILD_ID)).setSessionParameters(this.sessionParametersMap);
        SessionUtil.LoginOutput loginOutput = SessionUtil.openSession(loginInput);
        this.sessionToken = loginOutput.getSessionToken();
        this.masterToken = loginOutput.getMasterToken();
        this.remMeToken = loginOutput.getRemMeToken();
        this.databaseVersion = loginOutput.getDatabaseVersion();
        this.databaseMajorVersion = loginOutput.getDatabaseMajorVersion();
        this.databaseMinorVersion = loginOutput.getDatabaseMinorVersion();
        this.healthCheckInterval = loginOutput.getHealthCheckInterval();
        this.httpClientSocketTimeout = loginOutput.getHttpClientSocketTimeout();
        this.masterTokenValidityInSeconds = loginOutput.getMasterTokenValidityInSeconds();
        SessionUtil.updateSfDriverParamValues(loginOutput.getCommonParams(), this);
        this.startHeartbeatForThisSession();
        this.isClosed = false;
    }

    private void performSanityCheckOnProperties() throws SFException {
        if (!this.connectionPropertiesMap.containsKey((Object)SFSessionProperty.SERVER_URL)) {
            throw new SFException(ErrorCode.MISSING_SERVER_URL, new Object[0]);
        }
        if (!this.connectionPropertiesMap.containsKey((Object)SFSessionProperty.USER)) {
            throw new SFException(ErrorCode.MISSING_USERNAME, new Object[0]);
        }
        if (!this.connectionPropertiesMap.containsKey((Object)SFSessionProperty.PASSWORD)) {
            throw new SFException(ErrorCode.MISSING_PASSWORD, new Object[0]);
        }
        for (SFSessionProperty property : SFSessionProperty.values()) {
            if (!property.isRequired() || this.connectionPropertiesMap.containsKey((Object)property)) continue;
            throw new SFException(ErrorCode.MISSING_CONNECTION_PROPERTY, property.getPropertyKey());
        }
        String userName = (String)this.connectionPropertiesMap.get((Object)SFSessionProperty.USER);
        if (userName == null || userName.isEmpty()) {
            throw new SFException(ErrorCode.MISSING_USERNAME, new Object[0]);
        }
        String password = (String)this.connectionPropertiesMap.get((Object)SFSessionProperty.PASSWORD);
        if (password == null || password.isEmpty()) {
            throw new SFException(ErrorCode.MISSING_PASSWORD, new Object[0]);
        }
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getNewClientForUpdate() {
        return this.newClientForUpdate;
    }

    public String getDatabaseVersion() {
        return this.databaseVersion;
    }

    public int getDatabaseMajorVersion() {
        return this.databaseMajorVersion;
    }

    public int getDatabaseMinorVersion() {
        return this.databaseMinorVersion;
    }

    private void setNewClientForUpdate(String newClientForUpdate) {
        this.newClientForUpdate = newClientForUpdate;
    }

    synchronized void renewSession(String prevSessionToken) throws SFException, SnowflakeSQLException {
        if (this.sessionToken != null && !this.sessionToken.equals(prevSessionToken)) {
            return;
        }
        SessionUtil.LoginInput loginInput = new SessionUtil.LoginInput();
        loginInput.setServerUrl((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.SERVER_URL)).setSessionToken(this.sessionToken).setMasterToken(this.masterToken).setHttpClient(this.httpClient).setLoginTimeout(this.loginTimeout);
        SessionUtil.LoginOutput loginOutput = SessionUtil.renewSession(loginInput);
        this.sessionToken = loginOutput.getSessionToken();
        this.masterToken = loginOutput.getMasterToken();
    }

    protected String getSessionToken() {
        return this.sessionToken;
    }

    public void close() throws SFException, SnowflakeSQLException {
        logger.log(Level.FINER, " public void close() throws SFException");
        this.stopHeartbeatForThisSession();
        if (this.isClosed) {
            return;
        }
        SessionUtil.LoginInput loginInput = new SessionUtil.LoginInput();
        loginInput.setServerUrl((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.SERVER_URL)).setSessionToken(this.sessionToken).setHttpClient(this.httpClient).setLoginTimeout(this.loginTimeout);
        try {
            SessionUtil.closeSession(loginInput);
            this.isClosed = true;
        }
        finally {
            if (this.httpClient != null) {
                this.httpClient = null;
            }
        }
    }

    protected void startHeartbeatForThisSession() {
        if (this.enableHeartbeat) {
            logger.log(Level.FINE, "start heartbeat, master token validity: " + this.masterTokenValidityInSeconds);
            HeartbeatBackground.getInstance().addSession(this, this.masterTokenValidityInSeconds);
        } else {
            logger.log(Level.FINE, "heartbeat not enabled for the session");
        }
    }

    protected void stopHeartbeatForThisSession() {
        if (this.enableHeartbeat) {
            logger.log(Level.FINE, "stop heartbeat");
            HeartbeatBackground.getInstance().removeSession(this);
        } else {
            logger.log(Level.FINE, "heartbeat not enabled for the session");
        }
    }

    protected void heartbeat() throws SFException, SQLException {
        logger.log(Level.FINER, " public void heartbeat()");
        if (this.isClosed) {
            return;
        }
        HttpPost postRequest = null;
        String requestId = UUID.randomUUID().toString();
        boolean retry = false;
        do {
            try {
                URIBuilder uriBuilder = new URIBuilder((String)this.connectionPropertiesMap.get((Object)SFSessionProperty.SERVER_URL));
                uriBuilder.addParameter(SF_QUERY_REQUEST_ID, requestId);
                uriBuilder.setPath(SF_PATH_SESSION_HEARTBEAT);
                postRequest = new HttpPost(uriBuilder.build());
                String prevSessionToken = this.sessionToken;
                postRequest.setHeader(SF_HEADER_AUTHORIZATION, "Snowflake Token=\"" + prevSessionToken + "\"");
                logger.log(Level.FINER, "Executing heartbeat request: " + postRequest.toString());
                String theResponse = HttpUtil.executeRequest(postRequest, this.httpClient, SF_HEARTBEAT_TIMEOUT, 0, null);
                logger.log(Level.FINER, "connection heartbeat response: " + theResponse);
                JsonNode rootNode = mapper.readTree(theResponse);
                if (rootNode != null && 390112 == rootNode.path("code").asInt()) {
                    logger.log(Level.FINER, "renew session and retry");
                    this.renewSession(prevSessionToken);
                    retry = true;
                    continue;
                }
                SnowflakeUtil.checkErrorAndThrowException(rootNode);
                retry = false;
            }
            catch (Throwable ex) {
                logger.log(Level.SEVERE, "unexpected exception", ex);
                SFException sfe = IncidentUtil.generateIncidentWithException(this, requestId, null, ex, ErrorCode.INTERNAL_ERROR, "unexpected exception: " + ex.getMessage());
                throw sfe;
            }
        } while (retry);
    }

    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        logger.log(Level.FINER, " public void setClientInfo(Properties properties)");
        if (this.clientInfo == null) {
            this.clientInfo = new Properties();
        }
        this.clientInfo.clear();
        this.clientInfo.putAll((Map<?, ?>)properties);
    }

    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        logger.fine(" public void setClientInfo(String name, String value)");
        if (this.clientInfo == null) {
            this.clientInfo = new Properties();
        }
        this.clientInfo.setProperty(name, value);
    }

    public Properties getClientInfo() {
        logger.log(Level.FINER, " public Properties getClientInfo()");
        if (this.clientInfo != null) {
            Properties copy = new Properties();
            copy.putAll((Map<?, ?>)this.clientInfo);
            return copy;
        }
        return null;
    }

    public String getClientInfo(String name) {
        logger.log(Level.FINER, " public String getClientInfo(String name)");
        if (this.clientInfo != null) {
            return this.clientInfo.getProperty(name);
        }
        return null;
    }

    void setSFSessionProperty(String propertyName, boolean propertyValue) {
        this.sessionProperties.put(propertyName, propertyValue);
    }

    public Object getSFSessionProperty(String propertyName) {
        return this.sessionProperties.get(propertyName);
    }

    public void setInjectedDelay(int delay) {
        this._injectedDelay.set(delay);
    }

    void injectedDelay() {
        int d = this._injectedDelay.get();
        if (d != 0) {
            this._injectedDelay.set(0);
            try {
                logger.log(Level.FINEST, "delayed for " + d);
                Thread.sleep(d);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public int getInjectSocketTimeout() {
        return this.injectSocketTimeout;
    }

    public void setInjectSocketTimeout(int injectSocketTimeout) {
        this.injectSocketTimeout = injectSocketTimeout;
    }

    public void setInjectFileUploadFailure(String fileToFail) {
        this.injectFileUploadFailure = fileToFail;
    }

    public String getInjectFileUploadFailure() {
        return this.injectFileUploadFailure;
    }

    protected int getNetworkTimeoutInMilli() {
        return this.networkTimeoutInMilli;
    }

    protected boolean isClosed() {
        return this.isClosed;
    }

    public int getInjectClientPause() {
        return this.injectClientPause;
    }

    public void setInjectClientPause(int injectClientPause) {
        this.injectClientPause = injectClientPause;
    }

    protected int getHttpClientConnectionTimeout() {
        return this.httpClientConnectionTimeout;
    }

    protected int getHttpClientSocketTimeout() {
        return this.httpClientSocketTimeout;
    }

    protected boolean isUseProxy() {
        return this.useProxy;
    }

    protected int getAndIncrementSequenceId() {
        return this.sequenceId.getAndIncrement();
    }

    public void setExecuteReturnCountForDML(boolean executeReturnCountForDML) {
        this.executeReturnCountForDML = executeReturnCountForDML;
    }

    public boolean isExecuteReturnCountForDML() {
        return this.executeReturnCountForDML;
    }

    public boolean isEnableHeartbeat() {
        return this.enableHeartbeat;
    }

    public void setEnableHeartbeat(boolean enableHeartbeat) {
        this.enableHeartbeat = enableHeartbeat;
    }

    public boolean getAutoCommit() {
        return this.autoCommit.get();
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit.set(autoCommit);
    }
}

