/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.apache.tika.parser.external;

import com.snowflake.client.jdbc.internal.apache.tika.config.ServiceLoader;
import com.snowflake.client.jdbc.internal.apache.tika.config.TikaConfig;
import com.snowflake.client.jdbc.internal.apache.tika.exception.TikaException;
import com.snowflake.client.jdbc.internal.apache.tika.mime.MediaType;
import com.snowflake.client.jdbc.internal.apache.tika.parser.CompositeParser;
import com.snowflake.client.jdbc.internal.apache.tika.parser.Parser;
import com.snowflake.client.jdbc.internal.apache.tika.parser.external.ExternalParser;
import com.snowflake.client.jdbc.internal.apache.tika.parser.external.ExternalParsersConfigReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

public class ExternalParsersFactory {
    public static List<ExternalParser> create() throws IOException, TikaException {
        return ExternalParsersFactory.create(new ServiceLoader());
    }

    public static List<ExternalParser> create(ServiceLoader loader) throws IOException, TikaException {
        return ExternalParsersFactory.create("tika-external-parsers.xml", loader);
    }

    public static List<ExternalParser> create(String filename, ServiceLoader loader) throws IOException, TikaException {
        String filepath = ExternalParsersFactory.class.getPackage().getName().replace('.', '/') + "/" + filename;
        Enumeration<URL> files = loader.findServiceResources(filepath);
        ArrayList<URL> list = Collections.list(files);
        URL[] urls = list.toArray(new URL[list.size()]);
        return ExternalParsersFactory.create(urls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ExternalParser> create(URL ... urls) throws IOException, TikaException {
        ArrayList<ExternalParser> parsers = new ArrayList<ExternalParser>();
        for (URL url : urls) {
            InputStream stream = url.openStream();
            try {
                parsers.addAll(ExternalParsersConfigReader.read(stream));
            }
            finally {
                stream.close();
            }
        }
        return parsers;
    }

    public static void attachExternalParsers(TikaConfig config) throws IOException, TikaException {
        ExternalParsersFactory.attachExternalParsers(ExternalParsersFactory.create(), config);
    }

    public static void attachExternalParsers(List<ExternalParser> parsers, TikaConfig config) {
        Parser parser = config.getParser();
        if (parser instanceof CompositeParser) {
            CompositeParser cParser = (CompositeParser)parser;
            Map<MediaType, Parser> parserMap = cParser.getParsers();
        }
    }
}

