/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.apache.tika.extractor;

import com.snowflake.client.jdbc.internal.apache.tika.config.TikaConfig;
import com.snowflake.client.jdbc.internal.apache.tika.detect.DefaultDetector;
import com.snowflake.client.jdbc.internal.apache.tika.detect.Detector;
import com.snowflake.client.jdbc.internal.apache.tika.exception.TikaException;
import com.snowflake.client.jdbc.internal.apache.tika.extractor.ContainerExtractor;
import com.snowflake.client.jdbc.internal.apache.tika.extractor.EmbeddedResourceHandler;
import com.snowflake.client.jdbc.internal.apache.tika.io.TemporaryResources;
import com.snowflake.client.jdbc.internal.apache.tika.io.TikaInputStream;
import com.snowflake.client.jdbc.internal.apache.tika.metadata.Metadata;
import com.snowflake.client.jdbc.internal.apache.tika.mime.MediaType;
import com.snowflake.client.jdbc.internal.apache.tika.parser.AbstractParser;
import com.snowflake.client.jdbc.internal.apache.tika.parser.AutoDetectParser;
import com.snowflake.client.jdbc.internal.apache.tika.parser.ParseContext;
import com.snowflake.client.jdbc.internal.apache.tika.parser.Parser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ParserContainerExtractor
implements ContainerExtractor {
    private static final long serialVersionUID = 2261131045580861514L;
    private final Parser parser;
    private final Detector detector;

    public ParserContainerExtractor() {
        this(TikaConfig.getDefaultConfig());
    }

    public ParserContainerExtractor(TikaConfig config) {
        this(new AutoDetectParser(config), new DefaultDetector(config.getMimeRepository()));
    }

    public ParserContainerExtractor(Parser parser, Detector detector) {
        this.parser = parser;
        this.detector = detector;
    }

    @Override
    public boolean isSupported(TikaInputStream input) throws IOException {
        MediaType type = this.detector.detect(input, new Metadata());
        return this.parser.getSupportedTypes(new ParseContext()).contains(type);
    }

    @Override
    public void extract(TikaInputStream stream, ContainerExtractor recurseExtractor, EmbeddedResourceHandler handler) throws IOException, TikaException {
        ParseContext context = new ParseContext();
        context.set(Parser.class, new RecursiveParser(recurseExtractor, handler));
        try {
            this.parser.parse(stream, new DefaultHandler(), new Metadata(), context);
        }
        catch (SAXException e) {
            throw new TikaException("Unexpected SAX exception", e);
        }
    }

    private class RecursiveParser
    extends AbstractParser {
        private final ContainerExtractor extractor;
        private final EmbeddedResourceHandler handler;

        private RecursiveParser(ContainerExtractor extractor, EmbeddedResourceHandler handler) {
            this.extractor = extractor;
            this.handler = handler;
        }

        @Override
        public Set<MediaType> getSupportedTypes(ParseContext context) {
            return ParserContainerExtractor.this.parser.getSupportedTypes(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(InputStream stream, ContentHandler ignored, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
            block7: {
                TemporaryResources tmp = new TemporaryResources();
                try {
                    TikaInputStream tis = TikaInputStream.get(stream, tmp);
                    String filename = metadata.get("resourceName");
                    MediaType type = ParserContainerExtractor.this.detector.detect(tis, metadata);
                    if (this.extractor == null) {
                        this.handler.handle(filename, type, tis);
                        break block7;
                    }
                    File file = tis.getFile();
                    TikaInputStream input = TikaInputStream.get(file);
                    try {
                        this.handler.handle(filename, type, input);
                    }
                    finally {
                        ((InputStream)input).close();
                    }
                    this.extractor.extract(tis, this.extractor, this.handler);
                }
                finally {
                    tmp.dispose();
                }
            }
        }
    }
}

