/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.apache.http.protocol;

import com.snowflake.client.jdbc.internal.apache.http.HttpException;
import com.snowflake.client.jdbc.internal.apache.http.HttpRequest;
import com.snowflake.client.jdbc.internal.apache.http.HttpRequestInterceptor;
import com.snowflake.client.jdbc.internal.apache.http.annotation.Immutable;
import com.snowflake.client.jdbc.internal.apache.http.params.HttpParams;
import com.snowflake.client.jdbc.internal.apache.http.protocol.HttpContext;
import com.snowflake.client.jdbc.internal.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestUserAgent
implements HttpRequestInterceptor {
    private final String userAgent;

    public RequestUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public RequestUserAgent() {
        this(null);
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("User-Agent")) {
            String s = null;
            HttpParams params = request.getParams();
            if (params != null) {
                s = (String)params.getParameter("http.useragent");
            }
            if (s == null) {
                s = this.userAgent;
            }
            if (s != null) {
                request.addHeader("User-Agent", s);
            }
        }
    }
}

