/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.apache.http.impl.entity;

import com.snowflake.client.jdbc.internal.apache.http.Header;
import com.snowflake.client.jdbc.internal.apache.http.HttpEntity;
import com.snowflake.client.jdbc.internal.apache.http.HttpException;
import com.snowflake.client.jdbc.internal.apache.http.HttpMessage;
import com.snowflake.client.jdbc.internal.apache.http.annotation.Immutable;
import com.snowflake.client.jdbc.internal.apache.http.entity.BasicHttpEntity;
import com.snowflake.client.jdbc.internal.apache.http.entity.ContentLengthStrategy;
import com.snowflake.client.jdbc.internal.apache.http.impl.io.ChunkedInputStream;
import com.snowflake.client.jdbc.internal.apache.http.impl.io.ContentLengthInputStream;
import com.snowflake.client.jdbc.internal.apache.http.impl.io.IdentityInputStream;
import com.snowflake.client.jdbc.internal.apache.http.io.SessionInputBuffer;
import com.snowflake.client.jdbc.internal.apache.http.util.Args;
import java.io.IOException;

@Deprecated
@Immutable
public class EntityDeserializer {
    private final ContentLengthStrategy lenStrategy;

    public EntityDeserializer(ContentLengthStrategy lenStrategy) {
        this.lenStrategy = Args.notNull(lenStrategy, "Content length strategy");
    }

    protected BasicHttpEntity doDeserialize(SessionInputBuffer inbuffer, HttpMessage message) throws HttpException, IOException {
        Header contentEncodingHeader;
        BasicHttpEntity entity = new BasicHttpEntity();
        long len = this.lenStrategy.determineLength(message);
        if (len == -2L) {
            entity.setChunked(true);
            entity.setContentLength(-1L);
            entity.setContent(new ChunkedInputStream(inbuffer));
        } else if (len == -1L) {
            entity.setChunked(false);
            entity.setContentLength(-1L);
            entity.setContent(new IdentityInputStream(inbuffer));
        } else {
            entity.setChunked(false);
            entity.setContentLength(len);
            entity.setContent(new ContentLengthInputStream(inbuffer, len));
        }
        Header contentTypeHeader = message.getFirstHeader("Content-Type");
        if (contentTypeHeader != null) {
            entity.setContentType(contentTypeHeader);
        }
        if ((contentEncodingHeader = message.getFirstHeader("Content-Encoding")) != null) {
            entity.setContentEncoding(contentEncodingHeader);
        }
        return entity;
    }

    public HttpEntity deserialize(SessionInputBuffer inbuffer, HttpMessage message) throws HttpException, IOException {
        Args.notNull(inbuffer, "Session input buffer");
        Args.notNull(message, "HTTP message");
        return this.doDeserialize(inbuffer, message);
    }
}

