/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.amazonaws.services.logs;

import com.snowflake.client.jdbc.internal.amazonaws.AmazonClientException;
import com.snowflake.client.jdbc.internal.amazonaws.AmazonServiceException;
import com.snowflake.client.jdbc.internal.amazonaws.ClientConfiguration;
import com.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import com.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentialsProvider;
import com.snowflake.client.jdbc.internal.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.snowflake.client.jdbc.internal.amazonaws.handlers.AsyncHandler;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.AWSLogsAsync;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.AWSLogsClient;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.CreateLogGroupRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.CreateLogStreamRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.DeleteDestinationRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.DeleteLogGroupRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.DeleteLogStreamRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.DeleteMetricFilterRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.DeleteRetentionPolicyRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.DeleteSubscriptionFilterRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.DescribeDestinationsRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.DescribeDestinationsResult;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.DescribeLogGroupsRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.DescribeLogGroupsResult;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.DescribeLogStreamsRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.DescribeLogStreamsResult;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.DescribeMetricFiltersRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.DescribeMetricFiltersResult;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.DescribeSubscriptionFiltersRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.DescribeSubscriptionFiltersResult;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.FilterLogEventsRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.FilterLogEventsResult;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.GetLogEventsRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.GetLogEventsResult;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.PutDestinationPolicyRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.PutDestinationRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.PutDestinationResult;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.PutLogEventsRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.PutLogEventsResult;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.PutMetricFilterRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.PutRetentionPolicyRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.PutSubscriptionFilterRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.TestMetricFilterRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.logs.model.TestMetricFilterResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AWSLogsAsyncClient
extends AWSLogsClient
implements AWSLogsAsync {
    private final ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AWSLogsAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AWSLogsAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSLogsAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSLogsAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AWSLogsAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSLogsAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSLogsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AWSLogsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSLogsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<Void> putRetentionPolicyAsync(final PutRetentionPolicyRequest putRetentionPolicyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSLogsAsyncClient.this.putRetentionPolicy(putRetentionPolicyRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putRetentionPolicyAsync(final PutRetentionPolicyRequest putRetentionPolicyRequest, final AsyncHandler<PutRetentionPolicyRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSLogsAsyncClient.this.putRetentionPolicy(putRetentionPolicyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(putRetentionPolicyRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteDestinationAsync(final DeleteDestinationRequest deleteDestinationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSLogsAsyncClient.this.deleteDestination(deleteDestinationRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteDestinationAsync(final DeleteDestinationRequest deleteDestinationRequest, final AsyncHandler<DeleteDestinationRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSLogsAsyncClient.this.deleteDestination(deleteDestinationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteDestinationRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeSubscriptionFiltersResult> describeSubscriptionFiltersAsync(final DescribeSubscriptionFiltersRequest describeSubscriptionFiltersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSubscriptionFiltersResult>(){

            @Override
            public DescribeSubscriptionFiltersResult call() throws Exception {
                return AWSLogsAsyncClient.this.describeSubscriptionFilters(describeSubscriptionFiltersRequest);
            }
        });
    }

    @Override
    public Future<DescribeSubscriptionFiltersResult> describeSubscriptionFiltersAsync(final DescribeSubscriptionFiltersRequest describeSubscriptionFiltersRequest, final AsyncHandler<DescribeSubscriptionFiltersRequest, DescribeSubscriptionFiltersResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeSubscriptionFiltersResult>(){

            @Override
            public DescribeSubscriptionFiltersResult call() throws Exception {
                DescribeSubscriptionFiltersResult result;
                try {
                    result = AWSLogsAsyncClient.this.describeSubscriptionFilters(describeSubscriptionFiltersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeSubscriptionFiltersRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteSubscriptionFilterAsync(final DeleteSubscriptionFilterRequest deleteSubscriptionFilterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSLogsAsyncClient.this.deleteSubscriptionFilter(deleteSubscriptionFilterRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteSubscriptionFilterAsync(final DeleteSubscriptionFilterRequest deleteSubscriptionFilterRequest, final AsyncHandler<DeleteSubscriptionFilterRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSLogsAsyncClient.this.deleteSubscriptionFilter(deleteSubscriptionFilterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteSubscriptionFilterRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeMetricFiltersResult> describeMetricFiltersAsync(final DescribeMetricFiltersRequest describeMetricFiltersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeMetricFiltersResult>(){

            @Override
            public DescribeMetricFiltersResult call() throws Exception {
                return AWSLogsAsyncClient.this.describeMetricFilters(describeMetricFiltersRequest);
            }
        });
    }

    @Override
    public Future<DescribeMetricFiltersResult> describeMetricFiltersAsync(final DescribeMetricFiltersRequest describeMetricFiltersRequest, final AsyncHandler<DescribeMetricFiltersRequest, DescribeMetricFiltersResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeMetricFiltersResult>(){

            @Override
            public DescribeMetricFiltersResult call() throws Exception {
                DescribeMetricFiltersResult result;
                try {
                    result = AWSLogsAsyncClient.this.describeMetricFilters(describeMetricFiltersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeMetricFiltersRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLogStreamsResult> describeLogStreamsAsync(final DescribeLogStreamsRequest describeLogStreamsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLogStreamsResult>(){

            @Override
            public DescribeLogStreamsResult call() throws Exception {
                return AWSLogsAsyncClient.this.describeLogStreams(describeLogStreamsRequest);
            }
        });
    }

    @Override
    public Future<DescribeLogStreamsResult> describeLogStreamsAsync(final DescribeLogStreamsRequest describeLogStreamsRequest, final AsyncHandler<DescribeLogStreamsRequest, DescribeLogStreamsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLogStreamsResult>(){

            @Override
            public DescribeLogStreamsResult call() throws Exception {
                DescribeLogStreamsResult result;
                try {
                    result = AWSLogsAsyncClient.this.describeLogStreams(describeLogStreamsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeLogStreamsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteLogGroupAsync(final DeleteLogGroupRequest deleteLogGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSLogsAsyncClient.this.deleteLogGroup(deleteLogGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteLogGroupAsync(final DeleteLogGroupRequest deleteLogGroupRequest, final AsyncHandler<DeleteLogGroupRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSLogsAsyncClient.this.deleteLogGroup(deleteLogGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteLogGroupRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createLogGroupAsync(final CreateLogGroupRequest createLogGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSLogsAsyncClient.this.createLogGroup(createLogGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createLogGroupAsync(final CreateLogGroupRequest createLogGroupRequest, final AsyncHandler<CreateLogGroupRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSLogsAsyncClient.this.createLogGroup(createLogGroupRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createLogGroupRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putSubscriptionFilterAsync(final PutSubscriptionFilterRequest putSubscriptionFilterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSLogsAsyncClient.this.putSubscriptionFilter(putSubscriptionFilterRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putSubscriptionFilterAsync(final PutSubscriptionFilterRequest putSubscriptionFilterRequest, final AsyncHandler<PutSubscriptionFilterRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSLogsAsyncClient.this.putSubscriptionFilter(putSubscriptionFilterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(putSubscriptionFilterRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<TestMetricFilterResult> testMetricFilterAsync(final TestMetricFilterRequest testMetricFilterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<TestMetricFilterResult>(){

            @Override
            public TestMetricFilterResult call() throws Exception {
                return AWSLogsAsyncClient.this.testMetricFilter(testMetricFilterRequest);
            }
        });
    }

    @Override
    public Future<TestMetricFilterResult> testMetricFilterAsync(final TestMetricFilterRequest testMetricFilterRequest, final AsyncHandler<TestMetricFilterRequest, TestMetricFilterResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<TestMetricFilterResult>(){

            @Override
            public TestMetricFilterResult call() throws Exception {
                TestMetricFilterResult result;
                try {
                    result = AWSLogsAsyncClient.this.testMetricFilter(testMetricFilterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(testMetricFilterRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> putMetricFilterAsync(final PutMetricFilterRequest putMetricFilterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSLogsAsyncClient.this.putMetricFilter(putMetricFilterRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putMetricFilterAsync(final PutMetricFilterRequest putMetricFilterRequest, final AsyncHandler<PutMetricFilterRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSLogsAsyncClient.this.putMetricFilter(putMetricFilterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(putMetricFilterRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteMetricFilterAsync(final DeleteMetricFilterRequest deleteMetricFilterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSLogsAsyncClient.this.deleteMetricFilter(deleteMetricFilterRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteMetricFilterAsync(final DeleteMetricFilterRequest deleteMetricFilterRequest, final AsyncHandler<DeleteMetricFilterRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSLogsAsyncClient.this.deleteMetricFilter(deleteMetricFilterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteMetricFilterRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<FilterLogEventsResult> filterLogEventsAsync(final FilterLogEventsRequest filterLogEventsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<FilterLogEventsResult>(){

            @Override
            public FilterLogEventsResult call() throws Exception {
                return AWSLogsAsyncClient.this.filterLogEvents(filterLogEventsRequest);
            }
        });
    }

    @Override
    public Future<FilterLogEventsResult> filterLogEventsAsync(final FilterLogEventsRequest filterLogEventsRequest, final AsyncHandler<FilterLogEventsRequest, FilterLogEventsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<FilterLogEventsResult>(){

            @Override
            public FilterLogEventsResult call() throws Exception {
                FilterLogEventsResult result;
                try {
                    result = AWSLogsAsyncClient.this.filterLogEvents(filterLogEventsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(filterLogEventsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<PutLogEventsResult> putLogEventsAsync(final PutLogEventsRequest putLogEventsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PutLogEventsResult>(){

            @Override
            public PutLogEventsResult call() throws Exception {
                return AWSLogsAsyncClient.this.putLogEvents(putLogEventsRequest);
            }
        });
    }

    @Override
    public Future<PutLogEventsResult> putLogEventsAsync(final PutLogEventsRequest putLogEventsRequest, final AsyncHandler<PutLogEventsRequest, PutLogEventsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PutLogEventsResult>(){

            @Override
            public PutLogEventsResult call() throws Exception {
                PutLogEventsResult result;
                try {
                    result = AWSLogsAsyncClient.this.putLogEvents(putLogEventsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(putLogEventsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteRetentionPolicyAsync(final DeleteRetentionPolicyRequest deleteRetentionPolicyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSLogsAsyncClient.this.deleteRetentionPolicy(deleteRetentionPolicyRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteRetentionPolicyAsync(final DeleteRetentionPolicyRequest deleteRetentionPolicyRequest, final AsyncHandler<DeleteRetentionPolicyRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSLogsAsyncClient.this.deleteRetentionPolicy(deleteRetentionPolicyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteRetentionPolicyRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<GetLogEventsResult> getLogEventsAsync(final GetLogEventsRequest getLogEventsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetLogEventsResult>(){

            @Override
            public GetLogEventsResult call() throws Exception {
                return AWSLogsAsyncClient.this.getLogEvents(getLogEventsRequest);
            }
        });
    }

    @Override
    public Future<GetLogEventsResult> getLogEventsAsync(final GetLogEventsRequest getLogEventsRequest, final AsyncHandler<GetLogEventsRequest, GetLogEventsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetLogEventsResult>(){

            @Override
            public GetLogEventsResult call() throws Exception {
                GetLogEventsResult result;
                try {
                    result = AWSLogsAsyncClient.this.getLogEvents(getLogEventsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getLogEventsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> createLogStreamAsync(final CreateLogStreamRequest createLogStreamRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSLogsAsyncClient.this.createLogStream(createLogStreamRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createLogStreamAsync(final CreateLogStreamRequest createLogStreamRequest, final AsyncHandler<CreateLogStreamRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSLogsAsyncClient.this.createLogStream(createLogStreamRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createLogStreamRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<PutDestinationResult> putDestinationAsync(final PutDestinationRequest putDestinationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PutDestinationResult>(){

            @Override
            public PutDestinationResult call() throws Exception {
                return AWSLogsAsyncClient.this.putDestination(putDestinationRequest);
            }
        });
    }

    @Override
    public Future<PutDestinationResult> putDestinationAsync(final PutDestinationRequest putDestinationRequest, final AsyncHandler<PutDestinationRequest, PutDestinationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PutDestinationResult>(){

            @Override
            public PutDestinationResult call() throws Exception {
                PutDestinationResult result;
                try {
                    result = AWSLogsAsyncClient.this.putDestination(putDestinationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(putDestinationRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> putDestinationPolicyAsync(final PutDestinationPolicyRequest putDestinationPolicyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSLogsAsyncClient.this.putDestinationPolicy(putDestinationPolicyRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putDestinationPolicyAsync(final PutDestinationPolicyRequest putDestinationPolicyRequest, final AsyncHandler<PutDestinationPolicyRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSLogsAsyncClient.this.putDestinationPolicy(putDestinationPolicyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(putDestinationPolicyRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteLogStreamAsync(final DeleteLogStreamRequest deleteLogStreamRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AWSLogsAsyncClient.this.deleteLogStream(deleteLogStreamRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteLogStreamAsync(final DeleteLogStreamRequest deleteLogStreamRequest, final AsyncHandler<DeleteLogStreamRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AWSLogsAsyncClient.this.deleteLogStream(deleteLogStreamRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteLogStreamRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeLogGroupsResult> describeLogGroupsAsync(final DescribeLogGroupsRequest describeLogGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLogGroupsResult>(){

            @Override
            public DescribeLogGroupsResult call() throws Exception {
                return AWSLogsAsyncClient.this.describeLogGroups(describeLogGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeLogGroupsResult> describeLogGroupsAsync(final DescribeLogGroupsRequest describeLogGroupsRequest, final AsyncHandler<DescribeLogGroupsRequest, DescribeLogGroupsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLogGroupsResult>(){

            @Override
            public DescribeLogGroupsResult call() throws Exception {
                DescribeLogGroupsResult result;
                try {
                    result = AWSLogsAsyncClient.this.describeLogGroups(describeLogGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeLogGroupsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDestinationsResult> describeDestinationsAsync(final DescribeDestinationsRequest describeDestinationsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDestinationsResult>(){

            @Override
            public DescribeDestinationsResult call() throws Exception {
                return AWSLogsAsyncClient.this.describeDestinations(describeDestinationsRequest);
            }
        });
    }

    @Override
    public Future<DescribeDestinationsResult> describeDestinationsAsync(final DescribeDestinationsRequest describeDestinationsRequest, final AsyncHandler<DescribeDestinationsRequest, DescribeDestinationsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDestinationsResult>(){

            @Override
            public DescribeDestinationsResult call() throws Exception {
                DescribeDestinationsResult result;
                try {
                    result = AWSLogsAsyncClient.this.describeDestinations(describeDestinationsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeDestinationsRequest, result);
                return result;
            }
        });
    }
}

