/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.core;

import com.snowflake.client.core.BasicEvent;
import com.snowflake.client.core.IncidentUtil;
import com.snowflake.client.core.ResultUtil;
import com.snowflake.client.core.SFBaseResultSet;
import com.snowflake.client.core.SFException;
import com.snowflake.client.core.SFResultSetMetaData;
import com.snowflake.client.core.SFSession;
import com.snowflake.client.core.SFStatement;
import com.snowflake.client.core.SessionUtil;
import com.snowflake.client.core.StmtUtil;
import com.snowflake.client.jdbc.ErrorCode;
import com.snowflake.client.jdbc.SnowflakeChunkDownloader;
import com.snowflake.client.jdbc.SnowflakeColumnMetadata;
import com.snowflake.client.jdbc.SnowflakeResultChunk;
import com.snowflake.client.jdbc.SnowflakeSQLException;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SFResultSet
extends SFBaseResultSet {
    static final Logger logger = Logger.getLogger(SFResultSet.class.getName());
    private int columnCount = 0;
    private int currentChunkRowCount = 0;
    private int currentChunkRowIndex = -1;
    private JsonNode rootNode = null;
    private JsonNode currentChunkRowset = null;
    private ArrayList<Object[]> currentRowset = null;
    private List<SnowflakeColumnMetadata> resultColumnMetadata = new ArrayList<SnowflakeColumnMetadata>();
    private String queryId;
    private long statementTypeId;
    private boolean totalRowCountTruncated;
    private boolean sortResult = false;
    private Object[][] sortedRowSet;
    private long chunkCount = 0L;
    private long nextChunkIndex = 0L;
    private SnowflakeChunkDownloader chunkDownloader;
    protected SFStatement statement;

    public SFResultSet(JsonNode result, SFStatement statement, boolean sortResult) throws SQLException, SFException {
        this.statement = statement;
        this.columnCount = 0;
        this.sortResult = sortResult;
        this.rootNode = result;
        SFSession session = this.statement.getSession();
        ResultUtil.ResultInput resultInput = new ResultUtil.ResultInput();
        resultInput.setResultJSON(this.rootNode).setConnectionTimeout(session.getHttpClientConnectionTimeout()).setSocketTimeout(session.getHttpClientSocketTimeout()).setNetworkTimeoutInMilli(session.getNetworkTimeoutInMilli()).setUseProxy(session.isUseProxy());
        ResultUtil.ResultOutput resultOutput = ResultUtil.processResult(resultInput);
        this.queryId = resultOutput.getQueryId();
        this.statementTypeId = resultOutput.getStatementTypeId();
        this.totalRowCountTruncated = resultOutput.isTotalRowCountTruncated();
        this.parameters = resultOutput.getParameters();
        this.columnCount = resultOutput.getColumnCount();
        this.resultColumnMetadata = resultOutput.getResultColumnMetadata();
        this.currentChunkRowset = resultOutput.getCurrentChunkRowset();
        this.currentChunkRowCount = resultOutput.getCurrentChunkRowCount();
        this.chunkCount = resultOutput.getChunkCount();
        this.chunkDownloader = resultOutput.getChunkDownloader();
        this.timestampNTZFormatter = resultOutput.getTimestampNTZFormatter();
        this.timestampLTZFormatter = resultOutput.getTimestampLTZFormatter();
        this.timestampTZFormatter = resultOutput.getTimestampTZFormatter();
        this.dateFormatter = resultOutput.getDateFormatter();
        this.timeFormatter = resultOutput.getTimeFormatter();
        this.timeZone = resultOutput.getTimeZone();
        this.honorClientTZForTimestampNTZ = resultOutput.isHonorClientTZForTimestampNTZ();
        this.binaryFormatter = resultOutput.getBinaryFormatter();
        this.resultVersion = resultOutput.getResultVersion();
        this.numberOfBinds = resultOutput.getNumberOfBinds();
        this.nextRow = new Object[this.columnCount];
        SessionUtil.updateSfDriverParamValues(this.parameters, statement.getSession());
        if (sortResult) {
            if (this.chunkCount > 0L) {
                throw new SnowflakeSQLException("0A000", ErrorCode.CLIENT_SIDE_SORTING_NOT_SUPPORTED.getMessageCode());
            }
            this.sortResultSet();
        }
        StmtUtil.eventHandler.triggerStateTransition(BasicEvent.QueryState.CONSUMING_RESULT, String.format(BasicEvent.QueryState.CONSUMING_RESULT.getArgString(), this.queryId, 0));
        this.resultSetMetaData = new SFResultSetMetaData(this.resultColumnMetadata, this.queryId, session, this.timestampNTZFormatter, this.timestampLTZFormatter, this.timestampTZFormatter, this.dateFormatter, this.timeFormatter);
    }

    private boolean fetchNextRow() throws SFException, SnowflakeSQLException {
        if (this.sortResult) {
            return this.fetchNextRowSorted();
        }
        return this.fetchNextRowUnsorted();
    }

    private boolean fetchNextRowSorted() {
        ++this.currentChunkRowIndex;
        if (this.currentChunkRowIndex < this.currentChunkRowCount) {
            this.nextRow = this.sortedRowSet[this.currentChunkRowIndex];
            return true;
        }
        return false;
    }

    private boolean fetchNextRowUnsorted() throws SFException, SnowflakeSQLException {
        logger.log(Level.FINER, "Entering fetchJSONNextRow");
        ++this.currentChunkRowIndex;
        if (this.currentChunkRowIndex < this.currentChunkRowCount) {
            if (this.currentChunkRowset != null) {
                this.extractRow(this.currentChunkRowIndex, this.nextRow);
            } else {
                this.nextRow = this.getRow(this.currentChunkRowIndex);
            }
            return true;
        }
        if (this.nextChunkIndex < this.chunkCount) {
            try {
                StmtUtil.eventHandler.triggerStateTransition(BasicEvent.QueryState.CONSUMING_RESULT, String.format(BasicEvent.QueryState.CONSUMING_RESULT.getArgString(), this.queryId, this.nextChunkIndex));
                SnowflakeResultChunk nextChunk = this.chunkDownloader.getNextChunkToConsume();
                if (nextChunk == null) {
                    throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Expect chunk but got null for chunk index " + this.nextChunkIndex);
                }
                if (this.nextChunkIndex == 0L) {
                    this.rootNode = null;
                }
                this.currentChunkRowset = nextChunk.getResultData();
                this.currentChunkRowIndex = 0;
                this.currentChunkRowCount = nextChunk.getRowCount();
                this.currentRowset = nextChunk.getRowset();
                logger.log(Level.INFO, "Moving to chunk index {0}, row count={1}", new Object[]{this.nextChunkIndex, this.currentChunkRowCount});
                ++this.nextChunkIndex;
                if (this.currentChunkRowset != null) {
                    this.extractRow(this.currentChunkRowIndex, this.nextRow);
                } else {
                    this.nextRow = this.getRow(this.currentChunkRowIndex);
                }
                return true;
            }
            catch (InterruptedException ex) {
                throw new SnowflakeSQLException("57014", ErrorCode.INTERRUPTED.getMessageCode());
            }
        }
        if (this.chunkCount > 0L) {
            logger.log(Level.INFO, "End of chunks");
            this.chunkDownloader.terminate();
        }
        return false;
    }

    private void extractRow(int rowIdx, Object[] rowBuffer) throws SFException {
        try {
            JsonNode currentRow = this.currentChunkRowset.get(rowIdx);
            Integer numColsCurrentRow = currentRow.size();
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Num cols for row {0}: {1}", new Object[]{rowIdx, numColsCurrentRow});
            }
            assert (numColsCurrentRow != null);
            assert (numColsCurrentRow == this.columnCount);
            for (int colIdx = 0; colIdx < this.columnCount; ++colIdx) {
                JsonNode colNode = currentRow.get(colIdx);
                if (colNode.isTextual()) {
                    rowBuffer[colIdx] = colNode.asText();
                } else if (colNode.isNumber()) {
                    rowBuffer[colIdx] = colNode.numberValue();
                } else if (colNode.isNull()) {
                    rowBuffer[colIdx] = null;
                }
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.log(Level.FINER, "Get column {0}:{1}", new Object[]{colIdx, rowBuffer[colIdx]});
            }
        }
        catch (Throwable ex) {
            IncidentUtil.generateIncidentWithException(this.session, null, this.queryId, ex, ErrorCode.INTERNAL_ERROR, "Exception encountered when extracting row");
            throw new SFException(ex, ErrorCode.INTERNAL_ERROR, "Exception encountered when extracting row " + rowIdx);
        }
    }

    private Object[] getRow(int rowIdx) throws SFException {
        return this.currentRowset.get(rowIdx);
    }

    @Override
    public boolean next() throws SFException, SnowflakeSQLException {
        if (this.currentRowset != null) {
            for (int i = 0; i < this.getRow(this.currentChunkRowIndex).length; ++i) {
                this.getRow((int)this.currentChunkRowIndex)[i] = null;
            }
        }
        if (this.fetchNextRow()) {
            ++this.row;
            return true;
        }
        logger.log(Level.FINER, "end of result");
        if (this.totalRowCountTruncated || System.getProperty("snowflake.enable_incident_test2") != null && System.getProperty("snowflake.enable_incident_test2").equals("true")) {
            SFException sfe = IncidentUtil.generateIncidentWithException(this.session, null, this.queryId, ErrorCode.MAX_RESULT_LIMIT_EXCEEDED, new Object[0]);
            throw sfe;
        }
        this.endOfResult = true;
        return false;
    }

    private void sortResultSet() throws SnowflakeSQLException, SFException {
        this.sortedRowSet = new Object[this.currentChunkRowCount][];
        for (int rowIdx = 0; rowIdx < this.currentChunkRowCount; ++rowIdx) {
            this.sortedRowSet[rowIdx] = new Object[this.columnCount];
            if (this.currentChunkRowset != null) {
                this.extractRow(rowIdx, this.sortedRowSet[rowIdx]);
                continue;
            }
            this.sortedRowSet[rowIdx] = this.getRow(rowIdx);
        }
        Arrays.sort(this.sortedRowSet, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] a, Object[] b) {
                int numCols = a.length;
                for (int colIdx = 0; colIdx < numCols; ++colIdx) {
                    if (a[colIdx] == null && b[colIdx] == null) continue;
                    if (a[colIdx] == null) {
                        return 1;
                    }
                    if (b[colIdx] == null) {
                        return -1;
                    }
                    int res = a[colIdx].toString().compareTo(b[colIdx].toString());
                    if (res == 0) continue;
                    return res;
                }
                return 0;
            }
        });
    }

    @Override
    public void close() {
        super.close();
        if (this.chunkCount > 0L) {
            this.chunkDownloader.terminate();
        }
    }

    public long getStatementTypeId() {
        return this.statementTypeId;
    }
}

