/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.type;

import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonGenerator;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JavaType;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonSerializable;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.SerializerProvider;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;

public abstract class TypeBase
extends JavaType
implements JsonSerializable {
    private static final long serialVersionUID = -3581199092426900829L;
    volatile transient String _canonicalName;

    @Deprecated
    protected TypeBase(Class<?> clazz, int n, Object object, Object object2) {
        this(clazz, n, object, object2, false);
    }

    protected TypeBase(Class<?> clazz, int n, Object object, Object object2, boolean bl) {
        super(clazz, n, object, object2, bl);
    }

    @Override
    public String toCanonical() {
        String string = this._canonicalName;
        if (string == null) {
            string = this.buildCanonicalName();
        }
        return string;
    }

    protected abstract String buildCanonicalName();

    @Override
    public abstract StringBuilder getGenericSignature(StringBuilder var1);

    @Override
    public abstract StringBuilder getErasedSignature(StringBuilder var1);

    @Override
    public <T> T getValueHandler() {
        return (T)this._valueHandler;
    }

    @Override
    public <T> T getTypeHandler() {
        return (T)this._typeHandler;
    }

    @Override
    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
        typeSerializer.writeTypePrefixForScalar(this, jsonGenerator);
        this.serialize(jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffixForScalar(this, jsonGenerator);
    }

    @Override
    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        jsonGenerator.writeString(this.toCanonical());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static StringBuilder _classSignature(Class<?> clazz, StringBuilder stringBuilder, boolean bl) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                stringBuilder.append('Z');
                return stringBuilder;
            } else if (clazz == Byte.TYPE) {
                stringBuilder.append('B');
                return stringBuilder;
            } else if (clazz == Short.TYPE) {
                stringBuilder.append('S');
                return stringBuilder;
            } else if (clazz == Character.TYPE) {
                stringBuilder.append('C');
                return stringBuilder;
            } else if (clazz == Integer.TYPE) {
                stringBuilder.append('I');
                return stringBuilder;
            } else if (clazz == Long.TYPE) {
                stringBuilder.append('J');
                return stringBuilder;
            } else if (clazz == Float.TYPE) {
                stringBuilder.append('F');
                return stringBuilder;
            } else if (clazz == Double.TYPE) {
                stringBuilder.append('D');
                return stringBuilder;
            } else {
                if (clazz != Void.TYPE) throw new IllegalStateException("Unrecognized primitive type: " + clazz.getName());
                stringBuilder.append('V');
            }
            return stringBuilder;
        } else {
            stringBuilder.append('L');
            String string = clazz.getName();
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '.') {
                    c = '/';
                }
                stringBuilder.append(c);
            }
            if (!bl) return stringBuilder;
            stringBuilder.append(';');
        }
        return stringBuilder;
    }
}

