/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.amazonaws.transform;

import com.snowflake.client.jdbc.internal.amazonaws.AmazonServiceException;
import com.snowflake.client.jdbc.internal.amazonaws.transform.AbstractErrorUnmarshaller;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.DeserializationFeature;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import com.snowflake.client.jdbc.internal.fasterxml.jackson.databind.PropertyNamingStrategy;

public class JsonErrorUnmarshallerV2
extends AbstractErrorUnmarshaller<JsonNode> {
    public static final JsonErrorUnmarshallerV2 DEFAULT_UNMARSHALLER = new JsonErrorUnmarshallerV2(AmazonServiceException.class, null);
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setPropertyNamingStrategy(new PropertyNamingStrategy.PascalCaseStrategy());
    private final String handledErrorCode;

    public JsonErrorUnmarshallerV2(Class<? extends AmazonServiceException> exceptionClass, String handledErrorCode) {
        super(exceptionClass);
        this.handledErrorCode = handledErrorCode;
    }

    @Override
    public AmazonServiceException unmarshall(JsonNode jsonContent) throws Exception {
        return (AmazonServiceException)MAPPER.treeToValue(jsonContent, this.exceptionClass);
    }

    public boolean matchErrorCode(String actualErrorCode) {
        if (this.handledErrorCode == null) {
            return true;
        }
        return this.handledErrorCode.equals(actualErrorCode);
    }
}

