/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform;

import com.snowflake.client.jdbc.internal.amazonaws.AmazonClientException;
import com.snowflake.client.jdbc.internal.amazonaws.DefaultRequest;
import com.snowflake.client.jdbc.internal.amazonaws.Request;
import com.snowflake.client.jdbc.internal.amazonaws.http.HttpMethodName;
import com.snowflake.client.jdbc.internal.amazonaws.services.kms.model.GenerateRandomRequest;
import com.snowflake.client.jdbc.internal.amazonaws.transform.Marshaller;
import com.snowflake.client.jdbc.internal.amazonaws.util.StringInputStream;
import com.snowflake.client.jdbc.internal.amazonaws.util.StringUtils;
import com.snowflake.client.jdbc.internal.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class GenerateRandomRequestMarshaller
implements Marshaller<Request<GenerateRandomRequest>, GenerateRandomRequest> {
    @Override
    public Request<GenerateRandomRequest> marshall(GenerateRandomRequest generateRandomRequest) {
        if (generateRandomRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GenerateRandomRequest> request = new DefaultRequest<GenerateRandomRequest>(generateRandomRequest, "AWSKMS");
        String target = "TrentService.GenerateRandom";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (generateRandomRequest.getNumberOfBytes() != null) {
                jsonWriter.key("NumberOfBytes").value(generateRandomRequest.getNumberOfBytes());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

