/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.amazonaws.services.config.model.transform;

import com.snowflake.client.jdbc.internal.amazonaws.AmazonClientException;
import com.snowflake.client.jdbc.internal.amazonaws.DefaultRequest;
import com.snowflake.client.jdbc.internal.amazonaws.Request;
import com.snowflake.client.jdbc.internal.amazonaws.http.HttpMethodName;
import com.snowflake.client.jdbc.internal.amazonaws.internal.ListWithAutoConstructFlag;
import com.snowflake.client.jdbc.internal.amazonaws.services.config.model.ConfigurationRecorder;
import com.snowflake.client.jdbc.internal.amazonaws.services.config.model.PutConfigurationRecorderRequest;
import com.snowflake.client.jdbc.internal.amazonaws.services.config.model.RecordingGroup;
import com.snowflake.client.jdbc.internal.amazonaws.transform.Marshaller;
import com.snowflake.client.jdbc.internal.amazonaws.util.StringInputStream;
import com.snowflake.client.jdbc.internal.amazonaws.util.StringUtils;
import com.snowflake.client.jdbc.internal.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class PutConfigurationRecorderRequestMarshaller
implements Marshaller<Request<PutConfigurationRecorderRequest>, PutConfigurationRecorderRequest> {
    @Override
    public Request<PutConfigurationRecorderRequest> marshall(PutConfigurationRecorderRequest putConfigurationRecorderRequest) {
        if (putConfigurationRecorderRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutConfigurationRecorderRequest> request = new DefaultRequest<PutConfigurationRecorderRequest>(putConfigurationRecorderRequest, "AmazonConfig");
        String target = "StarlingDoveService.PutConfigurationRecorder";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            ConfigurationRecorder configurationRecorder = putConfigurationRecorderRequest.getConfigurationRecorder();
            if (configurationRecorder != null) {
                RecordingGroup recordingGroup;
                jsonWriter.key("ConfigurationRecorder");
                jsonWriter.object();
                if (configurationRecorder.getName() != null) {
                    jsonWriter.key("name").value(configurationRecorder.getName());
                }
                if (configurationRecorder.getRoleARN() != null) {
                    jsonWriter.key("roleARN").value(configurationRecorder.getRoleARN());
                }
                if ((recordingGroup = configurationRecorder.getRecordingGroup()) != null) {
                    ListWithAutoConstructFlag resourceTypesList;
                    jsonWriter.key("recordingGroup");
                    jsonWriter.object();
                    if (recordingGroup.isAllSupported() != null) {
                        jsonWriter.key("allSupported").value(recordingGroup.isAllSupported());
                    }
                    if (!((resourceTypesList = (ListWithAutoConstructFlag)recordingGroup.getResourceTypes()) == null || resourceTypesList.isAutoConstruct() && resourceTypesList.isEmpty())) {
                        jsonWriter.key("resourceTypes");
                        jsonWriter.array();
                        for (String resourceTypesListValue : resourceTypesList) {
                            if (resourceTypesListValue == null) continue;
                            jsonWriter.value(resourceTypesListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

