/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.loader;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPOutputStream;
import net.snowflake.client.loader.FileUploader;
import net.snowflake.client.loader.Loader;
import net.snowflake.client.loader.Operation;
import net.snowflake.client.loader.StreamLoader;
import net.snowflake.client.loader.Utils;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class BufferStage {
    private static final SFLogger logger = SFLoggerFactory.getLogger(BufferStage.class);
    public static final int FILE_BUCKET_SIZE = 64;
    public static final long FILE_SIZE = 0x3200000L;
    private State _state;
    private final File _directory;
    private final String _location;
    private final String _stamp;
    private final Operation _op;
    private final long _csvFileBucketSize;
    private final long _csvFileSize;
    private volatile boolean _terminate = false;
    private String _id;
    private int _currentSize = 0;
    private int _rowCount = 0;
    private int _fileCount = 0;
    private static AtomicLong MARK = new AtomicLong(1L);
    private StreamLoader _loader;
    private OutputStream _outstream = null;
    private File _file = null;
    private ArrayList<FileUploader> _uploaders = new ArrayList();
    private static byte[] newLineBytes = "\n".getBytes(StandardCharsets.UTF_8);

    BufferStage(StreamLoader loader, Operation op, long csvFileBucketSize, long csvFileSize) {
        logger.debug("Operation: {}", new Object[]{op});
        this._state = State.CREATED;
        this._loader = loader;
        this._stamp = new SimpleDateFormat("yyyyMMdd'_'HHmmss'_'SSS").format(new Date());
        this._csvFileBucketSize = csvFileBucketSize;
        this._csvFileSize = csvFileSize;
        long mark = MARK.getAndIncrement() % 10000000L;
        this._location = BufferStage.escapeFileSeparatorChar(this._loader.getTable()) + File.separatorChar + op.name() + File.separatorChar + this._stamp + "_" + this._loader.getNoise() + '_' + mark;
        this._id = BufferStage.escapeFileSeparatorChar(this._loader.getTable()) + "_" + this._stamp + '_' + mark;
        String localStageDirectory = this._loader.getBase() + File.separatorChar + this._location;
        this._directory = new File(localStageDirectory);
        if (!this._directory.mkdirs()) {
            RuntimeException ex = new RuntimeException("Could not initialize the local staging area. Make sure the directory is writable and readable: " + localStageDirectory);
            this._loader.abort(ex);
            throw ex;
        }
        this._op = op;
        this.openFile();
    }

    private synchronized void openFile() {
        try {
            String fName = this._directory.getAbsolutePath() + File.separatorChar + "stream_" + this._stamp + this._fileCount;
            if (this._loader._compressDataBeforePut) {
                fName = fName + ".gz";
            }
            logger.debug("openFile: {}", fName);
            FileOutputStream fileStream = new FileOutputStream(fName);
            if (this._loader._compressDataBeforePut) {
                GZIPOutputStream gzipOutputStream = new GZIPOutputStream(fileStream, 65536, true){
                    {
                        this.def.setLevel((int)((BufferStage)BufferStage.this)._loader._compressLevel);
                    }
                };
                this._outstream = new BufferedOutputStream(gzipOutputStream);
            } else {
                this._outstream = new BufferedOutputStream(fileStream);
            }
            this._file = new File(fName);
            ++this._fileCount;
        }
        catch (IOException ex) {
            this._loader.abort(new Loader.ConnectionError(Utils.getCause(ex)));
        }
    }

    boolean stageData(byte[] line) throws IOException {
        if (this._rowCount % 10000 == 0) {
            logger.debug("rowCount: {}, currentSize: {}", this._rowCount, this._currentSize);
        }
        this._outstream.write(line);
        this._currentSize += line.length;
        this._outstream.write(newLineBytes);
        ++this._rowCount;
        if (this._loader._testRemoteBadCSV) {
            this._outstream.write(new byte[]{1, 2});
            this._outstream.write(newLineBytes);
            ++this._rowCount;
        }
        if ((long)this._currentSize >= this._csvFileSize) {
            logger.debug("name: {}, currentSize: {}, Threshold: {}, fileCount: {}, fileBucketSize: {}", this._file.getAbsolutePath(), this._currentSize, this._csvFileSize, this._fileCount, this._csvFileBucketSize);
            this._outstream.flush();
            this._outstream.close();
            this._outstream = null;
            FileUploader fu = new FileUploader(this._loader, this._location, this._file);
            fu.upload();
            this._uploaders.add(fu);
            this.openFile();
            this._currentSize = 0;
        }
        return (long)this._fileCount > this._csvFileBucketSize;
    }

    void completeUploading() throws IOException {
        logger.debug("name: {}, currentSize: {}, Threshold: {}, fileCount: {}, fileBucketSize: {}", this._file.getAbsolutePath(), this._currentSize, this._csvFileSize, this._fileCount, this._csvFileBucketSize);
        this._outstream.flush();
        this._outstream.close();
        if (this._currentSize > 0) {
            FileUploader fu = new FileUploader(this._loader, this._location, this._file);
            fu.upload();
            this._uploaders.add(fu);
        } else {
            this._file.delete();
        }
        for (FileUploader fu : this._uploaders) {
            fu.join();
        }
        this._directory.deleteOnExit();
        if (this._rowCount == 0) {
            this.setState(State.EMPTY);
        }
    }

    String getRemoteLocation() {
        return this.remoteSeparator(this._location);
    }

    Operation getOp() {
        return this._op;
    }

    public boolean isTerminate() {
        return this._terminate;
    }

    public void setTerminate(boolean terminate) {
        this._terminate = terminate;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String _id) {
        this._id = _id;
    }

    public State state() {
        return this._state;
    }

    public void setState(State state) {
        if (this._state != state) {
            this._state = state;
        }
    }

    int getRowCount() {
        return this._rowCount;
    }

    private String remoteSeparator(String fname) {
        if (File.separatorChar == '\\') {
            return fname.replace("\\", "/");
        }
        return fname;
    }

    private static String escapeFileSeparatorChar(String fname) {
        if (File.separatorChar == '\\') {
            return fname.replaceAll(File.separator + File.separator, "_");
        }
        return fname.replaceAll(File.separator, "_");
    }

    public static enum State {
        CREATED,
        LOADING,
        LOADED,
        EMPTY,
        UPLOADED,
        VALIDATED,
        VALIDATED_CLEANED,
        ERROR,
        PROCESSED,
        CLEANED,
        REMOVED;

    }
}

