/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl;

import java.util.HashMap;
import java.util.Map;
import net.snowflake.client.jdbc.internal.apache.arrow.util.Preconditions;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BigIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.DateDayVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.DateMilliVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.Decimal256Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.DecimalVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.DurationVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FixedSizeBinaryVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.Float2Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.Float4Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.Float8Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntervalDayVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntervalMonthDayNanoVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntervalYearVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.LargeVarBinaryVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.LargeVarCharVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.SmallIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeMicroVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeMilliVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeNanoVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeSecVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampMicroTZVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampMicroVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampMilliTZVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampMilliVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampNanoTZVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampNanoVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampSecTZVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampSecVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TinyIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.UInt1Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.UInt2Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.UInt4Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.UInt8Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VarBinaryVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VarCharVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ViewVarBinaryVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ViewVarCharVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.DenseUnionVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.ListVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.MapVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.StructVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.UnionVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.AbstractFieldWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.DenseUnionWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.NullableStructWriterFactory;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.PromotableWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.UnionWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.BaseWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.BigIntWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.BitWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.DateDayWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.DateMilliWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.Decimal256Writer;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.DecimalWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.DurationWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.FieldWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.FixedSizeBinaryWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.Float2Writer;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.Float4Writer;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.Float8Writer;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.IntWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.IntervalDayWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.IntervalMonthDayNanoWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.IntervalYearWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.LargeVarBinaryWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.LargeVarCharWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.SmallIntWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.TimeMicroWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.TimeMilliWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.TimeNanoWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.TimeSecWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.TimeStampMicroTZWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.TimeStampMicroWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.TimeStampMilliTZWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.TimeStampMilliWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.TimeStampNanoTZWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.TimeStampNanoWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.TimeStampSecTZWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.TimeStampSecWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.TinyIntWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.UInt1Writer;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.UInt2Writer;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.UInt4Writer;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.UInt8Writer;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.VarBinaryWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.VarCharWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.ViewVarBinaryWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.ViewVarCharWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.TimeUnit;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.ArrowType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Field;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;

public class NullableStructWriter
extends AbstractFieldWriter {
    protected final StructVector container;
    private int initialCapacity;
    private final Map<String, FieldWriter> fields = new HashMap<String, FieldWriter>();

    public NullableStructWriter(StructVector container) {
        this.container = container;
        this.initialCapacity = 0;
        block46: for (Field child : container.getField().getChildren()) {
            Types.MinorType minorType = Types.getMinorTypeForArrowType(child.getType());
            this.addVectorAsNullable = child.isNullable();
            switch (minorType) {
                case STRUCT: {
                    this.struct(child.getName());
                    continue block46;
                }
                case LIST: {
                    this.list(child.getName());
                    continue block46;
                }
                case MAP: {
                    ArrowType.Map arrowType = (ArrowType.Map)child.getType();
                    this.map(child.getName(), arrowType.getKeysSorted());
                    continue block46;
                }
                case DENSEUNION: {
                    FieldType fieldType = new FieldType(this.addVectorAsNullable, Types.MinorType.DENSEUNION.getType(), null, null);
                    AbstractFieldWriter writer = new DenseUnionWriter(container.addOrGet(child.getName(), fieldType, DenseUnionVector.class), this.getNullableStructWriterFactory());
                    this.fields.put(this.handleCase(child.getName()), writer);
                    continue block46;
                }
                case UNION: {
                    FieldType fieldType = new FieldType(this.addVectorAsNullable, Types.MinorType.UNION.getType(), null, null);
                    AbstractFieldWriter writer = new UnionWriter(container.addOrGet(child.getName(), fieldType, UnionVector.class), this.getNullableStructWriterFactory());
                    this.fields.put(this.handleCase(child.getName()), writer);
                    continue block46;
                }
                case TINYINT: {
                    this.tinyInt(child.getName());
                    continue block46;
                }
                case UINT1: {
                    this.uInt1(child.getName());
                    continue block46;
                }
                case UINT2: {
                    this.uInt2(child.getName());
                    continue block46;
                }
                case SMALLINT: {
                    this.smallInt(child.getName());
                    continue block46;
                }
                case FLOAT2: {
                    this.float2(child.getName());
                    continue block46;
                }
                case INT: {
                    this.integer(child.getName());
                    continue block46;
                }
                case UINT4: {
                    this.uInt4(child.getName());
                    continue block46;
                }
                case FLOAT4: {
                    this.float4(child.getName());
                    continue block46;
                }
                case DATEDAY: {
                    this.dateDay(child.getName());
                    continue block46;
                }
                case INTERVALYEAR: {
                    this.intervalYear(child.getName());
                    continue block46;
                }
                case TIMESEC: {
                    this.timeSec(child.getName());
                    continue block46;
                }
                case TIMEMILLI: {
                    this.timeMilli(child.getName());
                    continue block46;
                }
                case BIGINT: {
                    this.bigInt(child.getName());
                    continue block46;
                }
                case UINT8: {
                    this.uInt8(child.getName());
                    continue block46;
                }
                case FLOAT8: {
                    this.float8(child.getName());
                    continue block46;
                }
                case DATEMILLI: {
                    this.dateMilli(child.getName());
                    continue block46;
                }
                case DURATION: {
                    ArrowType.PrimitiveType arrowType = (ArrowType.Duration)child.getType();
                    this.duration(child.getName(), ((ArrowType.Duration)arrowType).getUnit());
                    continue block46;
                }
                case TIMESTAMPSEC: {
                    this.timeStampSec(child.getName());
                    continue block46;
                }
                case TIMESTAMPMILLI: {
                    this.timeStampMilli(child.getName());
                    continue block46;
                }
                case TIMESTAMPMICRO: {
                    this.timeStampMicro(child.getName());
                    continue block46;
                }
                case TIMESTAMPNANO: {
                    this.timeStampNano(child.getName());
                    continue block46;
                }
                case TIMESTAMPSECTZ: {
                    ArrowType.PrimitiveType arrowType = (ArrowType.Timestamp)child.getType();
                    this.timeStampSecTZ(child.getName(), ((ArrowType.Timestamp)arrowType).getTimezone());
                    continue block46;
                }
                case TIMESTAMPMILLITZ: {
                    ArrowType.PrimitiveType arrowType = (ArrowType.Timestamp)child.getType();
                    this.timeStampMilliTZ(child.getName(), ((ArrowType.Timestamp)arrowType).getTimezone());
                    continue block46;
                }
                case TIMESTAMPMICROTZ: {
                    ArrowType.PrimitiveType arrowType = (ArrowType.Timestamp)child.getType();
                    this.timeStampMicroTZ(child.getName(), ((ArrowType.Timestamp)arrowType).getTimezone());
                    continue block46;
                }
                case TIMESTAMPNANOTZ: {
                    ArrowType.PrimitiveType arrowType = (ArrowType.Timestamp)child.getType();
                    this.timeStampNanoTZ(child.getName(), ((ArrowType.Timestamp)arrowType).getTimezone());
                    continue block46;
                }
                case TIMEMICRO: {
                    this.timeMicro(child.getName());
                    continue block46;
                }
                case TIMENANO: {
                    this.timeNano(child.getName());
                    continue block46;
                }
                case INTERVALDAY: {
                    this.intervalDay(child.getName());
                    continue block46;
                }
                case INTERVALMONTHDAYNANO: {
                    this.intervalMonthDayNano(child.getName());
                    continue block46;
                }
                case DECIMAL256: {
                    ArrowType.PrimitiveType arrowType = (ArrowType.Decimal)child.getType();
                    this.decimal256(child.getName(), ((ArrowType.Decimal)arrowType).getScale(), ((ArrowType.Decimal)arrowType).getPrecision());
                    continue block46;
                }
                case DECIMAL: {
                    ArrowType.PrimitiveType arrowType = (ArrowType.Decimal)child.getType();
                    this.decimal(child.getName(), ((ArrowType.Decimal)arrowType).getScale(), ((ArrowType.Decimal)arrowType).getPrecision());
                    continue block46;
                }
                case FIXEDSIZEBINARY: {
                    ArrowType.PrimitiveType arrowType = (ArrowType.FixedSizeBinary)child.getType();
                    this.fixedSizeBinary(child.getName(), ((ArrowType.FixedSizeBinary)arrowType).getByteWidth());
                    continue block46;
                }
                case VARBINARY: {
                    this.varBinary(child.getName());
                    continue block46;
                }
                case VARCHAR: {
                    this.varChar(child.getName());
                    continue block46;
                }
                case VIEWVARBINARY: {
                    this.viewVarBinary(child.getName());
                    continue block46;
                }
                case VIEWVARCHAR: {
                    this.viewVarChar(child.getName());
                    continue block46;
                }
                case LARGEVARCHAR: {
                    this.largeVarChar(child.getName());
                    continue block46;
                }
                case LARGEVARBINARY: {
                    this.largeVarBinary(child.getName());
                    continue block46;
                }
                case BIT: {
                    this.bit(child.getName());
                    continue block46;
                }
            }
            throw new UnsupportedOperationException("Unknown type: " + (Object)((Object)minorType));
        }
    }

    protected String handleCase(String input) {
        return input.toLowerCase();
    }

    protected NullableStructWriterFactory getNullableStructWriterFactory() {
        return NullableStructWriterFactory.getNullableStructWriterFactoryInstance();
    }

    @Override
    public int getValueCapacity() {
        return this.container.getValueCapacity();
    }

    public void setInitialCapacity(int initialCapacity) {
        this.initialCapacity = initialCapacity;
        this.container.setInitialCapacity(initialCapacity);
    }

    @Override
    public boolean isEmptyStruct() {
        return 0 == this.container.size();
    }

    @Override
    public Field getField() {
        return this.container.getField();
    }

    @Override
    public BaseWriter.StructWriter struct(String name) {
        String finalName = this.handleCase(name);
        FieldWriter writer = this.fields.get(finalName);
        if (writer == null) {
            int vectorCount = this.container.size();
            FieldType fieldType = new FieldType(this.addVectorAsNullable, Types.MinorType.STRUCT.getType(), null, null);
            StructVector vector = this.container.addOrGet(name, fieldType, StructVector.class);
            writer = new PromotableWriter((ValueVector)vector, this.container, this.getNullableStructWriterFactory());
            if (vectorCount != this.container.size()) {
                writer.allocate();
            }
            writer.setPosition(this.idx());
            this.fields.put(finalName, writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.STRUCT);
        }
        return writer;
    }

    @Override
    public void close() throws Exception {
        this.clear();
        this.container.close();
    }

    @Override
    public void allocate() {
        this.container.allocateNew();
        for (FieldWriter w : this.fields.values()) {
            w.allocate();
        }
    }

    @Override
    public void clear() {
        this.container.clear();
        for (FieldWriter w : this.fields.values()) {
            w.clear();
        }
    }

    @Override
    public BaseWriter.ListWriter list(String name) {
        String finalName = this.handleCase(name);
        FieldWriter writer = this.fields.get(finalName);
        int vectorCount = this.container.size();
        if (writer == null) {
            FieldType fieldType = new FieldType(this.addVectorAsNullable, Types.MinorType.LIST.getType(), null, null);
            writer = new PromotableWriter((ValueVector)this.container.addOrGet(name, fieldType, ListVector.class), this.container, this.getNullableStructWriterFactory());
            if (this.container.size() > vectorCount) {
                writer.allocate();
            }
            writer.setPosition(this.idx());
            this.fields.put(finalName, writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.LIST);
        }
        return writer;
    }

    @Override
    public BaseWriter.MapWriter map(String name) {
        return this.map(name, false);
    }

    @Override
    public BaseWriter.MapWriter map(String name, boolean keysSorted) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            MapVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, new ArrowType.Map(keysSorted), null, null), MapVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            MapVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.MAP, new ArrowType.Map(keysSorted));
        }
        return writer;
    }

    public void setValueCount(int count) {
        this.container.setValueCount(count);
    }

    @Override
    public void setPosition(int index) {
        super.setPosition(index);
        for (FieldWriter w : this.fields.values()) {
            w.setPosition(index);
        }
    }

    @Override
    public void writeNull() {
        this.container.setNull(this.idx());
        this.setValueCount(this.idx() + 1);
        super.setPosition(this.idx() + 1);
    }

    @Override
    public void start() {
        this.container.setIndexDefined(this.idx());
    }

    @Override
    public void end() {
        this.setPosition(this.idx() + 1);
    }

    @Override
    public TinyIntWriter tinyInt(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            TinyIntVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.TINYINT.getType(), null, null), TinyIntVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            TinyIntVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.TINYINT);
        }
        return writer;
    }

    @Override
    public UInt1Writer uInt1(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            UInt1Vector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.UINT1.getType(), null, null), UInt1Vector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            UInt1Vector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.UINT1);
        }
        return writer;
    }

    @Override
    public UInt2Writer uInt2(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            UInt2Vector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.UINT2.getType(), null, null), UInt2Vector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            UInt2Vector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.UINT2);
        }
        return writer;
    }

    @Override
    public SmallIntWriter smallInt(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            SmallIntVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.SMALLINT.getType(), null, null), SmallIntVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            SmallIntVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.SMALLINT);
        }
        return writer;
    }

    @Override
    public Float2Writer float2(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            Float2Vector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.FLOAT2.getType(), null, null), Float2Vector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            Float2Vector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.FLOAT2);
        }
        return writer;
    }

    @Override
    public IntWriter integer(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            IntVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.INT.getType(), null, null), IntVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            IntVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.INT);
        }
        return writer;
    }

    @Override
    public UInt4Writer uInt4(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            UInt4Vector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.UINT4.getType(), null, null), UInt4Vector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            UInt4Vector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.UINT4);
        }
        return writer;
    }

    @Override
    public Float4Writer float4(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            Float4Vector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.FLOAT4.getType(), null, null), Float4Vector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            Float4Vector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.FLOAT4);
        }
        return writer;
    }

    @Override
    public DateDayWriter dateDay(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            DateDayVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.DATEDAY.getType(), null, null), DateDayVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            DateDayVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.DATEDAY);
        }
        return writer;
    }

    @Override
    public IntervalYearWriter intervalYear(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            IntervalYearVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.INTERVALYEAR.getType(), null, null), IntervalYearVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            IntervalYearVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.INTERVALYEAR);
        }
        return writer;
    }

    @Override
    public TimeSecWriter timeSec(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            TimeSecVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.TIMESEC.getType(), null, null), TimeSecVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            TimeSecVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.TIMESEC);
        }
        return writer;
    }

    @Override
    public TimeMilliWriter timeMilli(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            TimeMilliVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.TIMEMILLI.getType(), null, null), TimeMilliVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            TimeMilliVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.TIMEMILLI);
        }
        return writer;
    }

    @Override
    public BigIntWriter bigInt(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            BigIntVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.BIGINT.getType(), null, null), BigIntVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            BigIntVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.BIGINT);
        }
        return writer;
    }

    @Override
    public UInt8Writer uInt8(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            UInt8Vector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.UINT8.getType(), null, null), UInt8Vector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            UInt8Vector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.UINT8);
        }
        return writer;
    }

    @Override
    public Float8Writer float8(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            Float8Vector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.FLOAT8.getType(), null, null), Float8Vector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            Float8Vector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.FLOAT8);
        }
        return writer;
    }

    @Override
    public DateMilliWriter dateMilli(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            DateMilliVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.DATEMILLI.getType(), null, null), DateMilliVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            DateMilliVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.DATEMILLI);
        }
        return writer;
    }

    @Override
    public DurationWriter duration(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        Preconditions.checkNotNull(writer);
        return writer;
    }

    @Override
    public DurationWriter duration(String name, TimeUnit unit) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            DurationVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, new ArrowType.Duration(unit), null, null), DurationVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            DurationVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ArrowType.Duration arrowType = new ArrowType.Duration(unit);
            ((PromotableWriter)writer).getWriter(Types.MinorType.DURATION, arrowType);
        }
        return writer;
    }

    @Override
    public TimeStampSecWriter timeStampSec(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            TimeStampSecVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.TIMESTAMPSEC.getType(), null, null), TimeStampSecVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            TimeStampSecVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.TIMESTAMPSEC);
        }
        return writer;
    }

    @Override
    public TimeStampMilliWriter timeStampMilli(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            TimeStampMilliVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.TIMESTAMPMILLI.getType(), null, null), TimeStampMilliVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            TimeStampMilliVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.TIMESTAMPMILLI);
        }
        return writer;
    }

    @Override
    public TimeStampMicroWriter timeStampMicro(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            TimeStampMicroVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.TIMESTAMPMICRO.getType(), null, null), TimeStampMicroVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            TimeStampMicroVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.TIMESTAMPMICRO);
        }
        return writer;
    }

    @Override
    public TimeStampNanoWriter timeStampNano(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            TimeStampNanoVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.TIMESTAMPNANO.getType(), null, null), TimeStampNanoVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            TimeStampNanoVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.TIMESTAMPNANO);
        }
        return writer;
    }

    @Override
    public TimeStampSecTZWriter timeStampSecTZ(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        Preconditions.checkNotNull(writer);
        return writer;
    }

    @Override
    public TimeStampSecTZWriter timeStampSecTZ(String name, String timezone) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            TimeStampSecTZVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, new ArrowType.Timestamp(TimeUnit.SECOND, timezone), null, null), TimeStampSecTZVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            TimeStampSecTZVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ArrowType.Timestamp arrowType = new ArrowType.Timestamp(TimeUnit.SECOND, timezone);
            ((PromotableWriter)writer).getWriter(Types.MinorType.TIMESTAMPSECTZ, arrowType);
        }
        return writer;
    }

    @Override
    public TimeStampMilliTZWriter timeStampMilliTZ(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        Preconditions.checkNotNull(writer);
        return writer;
    }

    @Override
    public TimeStampMilliTZWriter timeStampMilliTZ(String name, String timezone) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            TimeStampMilliTZVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, new ArrowType.Timestamp(TimeUnit.MILLISECOND, timezone), null, null), TimeStampMilliTZVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            TimeStampMilliTZVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ArrowType.Timestamp arrowType = new ArrowType.Timestamp(TimeUnit.MILLISECOND, timezone);
            ((PromotableWriter)writer).getWriter(Types.MinorType.TIMESTAMPMILLITZ, arrowType);
        }
        return writer;
    }

    @Override
    public TimeStampMicroTZWriter timeStampMicroTZ(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        Preconditions.checkNotNull(writer);
        return writer;
    }

    @Override
    public TimeStampMicroTZWriter timeStampMicroTZ(String name, String timezone) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            TimeStampMicroTZVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, new ArrowType.Timestamp(TimeUnit.MICROSECOND, timezone), null, null), TimeStampMicroTZVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            TimeStampMicroTZVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ArrowType.Timestamp arrowType = new ArrowType.Timestamp(TimeUnit.MICROSECOND, timezone);
            ((PromotableWriter)writer).getWriter(Types.MinorType.TIMESTAMPMICROTZ, arrowType);
        }
        return writer;
    }

    @Override
    public TimeStampNanoTZWriter timeStampNanoTZ(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        Preconditions.checkNotNull(writer);
        return writer;
    }

    @Override
    public TimeStampNanoTZWriter timeStampNanoTZ(String name, String timezone) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            TimeStampNanoTZVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, new ArrowType.Timestamp(TimeUnit.NANOSECOND, timezone), null, null), TimeStampNanoTZVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            TimeStampNanoTZVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ArrowType.Timestamp arrowType = new ArrowType.Timestamp(TimeUnit.NANOSECOND, timezone);
            ((PromotableWriter)writer).getWriter(Types.MinorType.TIMESTAMPNANOTZ, arrowType);
        }
        return writer;
    }

    @Override
    public TimeMicroWriter timeMicro(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            TimeMicroVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.TIMEMICRO.getType(), null, null), TimeMicroVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            TimeMicroVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.TIMEMICRO);
        }
        return writer;
    }

    @Override
    public TimeNanoWriter timeNano(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            TimeNanoVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.TIMENANO.getType(), null, null), TimeNanoVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            TimeNanoVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.TIMENANO);
        }
        return writer;
    }

    @Override
    public IntervalDayWriter intervalDay(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            IntervalDayVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.INTERVALDAY.getType(), null, null), IntervalDayVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            IntervalDayVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.INTERVALDAY);
        }
        return writer;
    }

    @Override
    public IntervalMonthDayNanoWriter intervalMonthDayNano(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            IntervalMonthDayNanoVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.INTERVALMONTHDAYNANO.getType(), null, null), IntervalMonthDayNanoVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            IntervalMonthDayNanoVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.INTERVALMONTHDAYNANO);
        }
        return writer;
    }

    @Override
    public Decimal256Writer decimal256(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        Preconditions.checkNotNull(writer);
        return writer;
    }

    @Override
    public Decimal256Writer decimal256(String name, int scale, int precision) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            Decimal256Vector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, new ArrowType.Decimal(precision, scale, 256), null, null), Decimal256Vector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            Decimal256Vector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.DECIMAL256, new ArrowType.Decimal(precision, scale, 256));
        }
        return writer;
    }

    @Override
    public DecimalWriter decimal(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        Preconditions.checkNotNull(writer);
        return writer;
    }

    @Override
    public DecimalWriter decimal(String name, int scale, int precision) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            DecimalVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, new ArrowType.Decimal(precision, scale, 128), null, null), DecimalVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            DecimalVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.DECIMAL, new ArrowType.Decimal(precision, scale, 128));
        }
        return writer;
    }

    @Override
    public FixedSizeBinaryWriter fixedSizeBinary(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        Preconditions.checkNotNull(writer);
        return writer;
    }

    @Override
    public FixedSizeBinaryWriter fixedSizeBinary(String name, int byteWidth) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            FixedSizeBinaryVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, new ArrowType.FixedSizeBinary(byteWidth), null, null), FixedSizeBinaryVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            FixedSizeBinaryVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ArrowType.FixedSizeBinary arrowType = new ArrowType.FixedSizeBinary(byteWidth);
            ((PromotableWriter)writer).getWriter(Types.MinorType.FIXEDSIZEBINARY, arrowType);
        }
        return writer;
    }

    @Override
    public VarBinaryWriter varBinary(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            VarBinaryVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.VARBINARY.getType(), null, null), VarBinaryVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            VarBinaryVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.VARBINARY);
        }
        return writer;
    }

    @Override
    public VarCharWriter varChar(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            VarCharVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.VARCHAR.getType(), null, null), VarCharVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            VarCharVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.VARCHAR);
        }
        return writer;
    }

    @Override
    public ViewVarBinaryWriter viewVarBinary(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            ViewVarBinaryVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.VIEWVARBINARY.getType(), null, null), ViewVarBinaryVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            ViewVarBinaryVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.VIEWVARBINARY);
        }
        return writer;
    }

    @Override
    public ViewVarCharWriter viewVarChar(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            ViewVarCharVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.VIEWVARCHAR.getType(), null, null), ViewVarCharVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            ViewVarCharVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.VIEWVARCHAR);
        }
        return writer;
    }

    @Override
    public LargeVarCharWriter largeVarChar(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            LargeVarCharVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.LARGEVARCHAR.getType(), null, null), LargeVarCharVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            LargeVarCharVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.LARGEVARCHAR);
        }
        return writer;
    }

    @Override
    public LargeVarBinaryWriter largeVarBinary(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            LargeVarBinaryVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.LARGEVARBINARY.getType(), null, null), LargeVarBinaryVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            LargeVarBinaryVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.LARGEVARBINARY);
        }
        return writer;
    }

    @Override
    public BitWriter bit(String name) {
        FieldWriter writer = this.fields.get(this.handleCase(name));
        if (writer == null) {
            FieldVector currentVector = this.container.getChild(name);
            BitVector v = this.container.addOrGet(name, new FieldType(this.addVectorAsNullable, Types.MinorType.BIT.getType(), null, null), BitVector.class);
            writer = new PromotableWriter((ValueVector)v, this.container, this.getNullableStructWriterFactory());
            BitVector vector = v;
            if (currentVector == null || currentVector != vector) {
                if (this.initialCapacity > 0) {
                    vector.setInitialCapacity(this.initialCapacity);
                }
                vector.allocateNewSafe();
            }
            writer.setPosition(this.idx());
            this.fields.put(this.handleCase(name), writer);
        } else if (writer instanceof PromotableWriter) {
            ((PromotableWriter)writer).getWriter(Types.MinorType.BIT);
        }
        return writer;
    }
}

