/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.api.gax.paging.Page;
import com.google.cloud.storage.Blob;
import com.microsoft.azure.storage.blob.ListBlobItem;
import java.util.Iterator;
import java.util.List;
import net.snowflake.client.jdbc.cloud.storage.AzureObjectSummariesIterator;
import net.snowflake.client.jdbc.cloud.storage.GcsObjectSummariesIterator;
import net.snowflake.client.jdbc.cloud.storage.S3ObjectSummariesIterator;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectSummary;

public class StorageObjectSummaryCollection
implements Iterable<StorageObjectSummary> {
    private final storageType sType;
    private List<S3ObjectSummary> s3ObjSummariesList = null;
    private Iterable<ListBlobItem> azCLoudBlobIterable = null;
    private Page<Blob> gcsIterablePage = null;

    public StorageObjectSummaryCollection(List<S3ObjectSummary> s3ObjectSummaries) {
        this.s3ObjSummariesList = s3ObjectSummaries;
        this.sType = storageType.S3;
    }

    public StorageObjectSummaryCollection(Iterable<ListBlobItem> azCLoudBlobIterable) {
        this.azCLoudBlobIterable = azCLoudBlobIterable;
        this.sType = storageType.AZURE;
    }

    public StorageObjectSummaryCollection(Page<Blob> gcsIterablePage) {
        this.gcsIterablePage = gcsIterablePage;
        this.sType = storageType.GCS;
    }

    @Override
    public Iterator<StorageObjectSummary> iterator() {
        switch (this.sType) {
            case S3: {
                return new S3ObjectSummariesIterator(this.s3ObjSummariesList);
            }
            case AZURE: {
                return new AzureObjectSummariesIterator(this.azCLoudBlobIterable);
            }
            case GCS: {
                return new GcsObjectSummariesIterator(this.gcsIterablePage);
            }
        }
        throw new IllegalArgumentException("Unspecified storage provider");
    }

    private static enum storageType {
        S3,
        AZURE,
        GCS;

    }
}

