/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.HashSet;
import java.util.Set;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinary;

public enum SnowflakeType {
    ANY,
    ARRAY,
    BINARY,
    BOOLEAN,
    CHAR,
    DATE,
    FIXED,
    INTEGER,
    OBJECT,
    MAP,
    REAL,
    TEXT,
    TIME,
    TIMESTAMP,
    TIMESTAMP_LTZ,
    TIMESTAMP_NTZ,
    TIMESTAMP_TZ,
    VARIANT,
    GEOGRAPHY,
    GEOMETRY,
    VECTOR;

    public static final String DATE_OR_TIME_FORMAT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    public static final String TIMESTAMP_FORMAT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.";
    public static final String TIMESTAMP_FORMAT_TZ_PATTERN = "XXX";
    public static final String TIME_FORMAT_PATTERN = "HH:mm:ss.SSS";
    private static final byte[] BYTE_ARRAY;
    public static final String BINARY_CLASS_NAME;

    public static SnowflakeType fromString(String name) {
        return SnowflakeType.valueOf(name.toUpperCase());
    }

    @Deprecated
    public static JavaDataType getJavaType(SnowflakeType type) {
        return SnowflakeType.getJavaType(type, false);
    }

    @SnowflakeJdbcInternalApi
    public static JavaDataType getJavaType(SnowflakeType type, boolean isStructuredType) {
        switch (type) {
            case TEXT: {
                return JavaDataType.JAVA_STRING;
            }
            case CHAR: {
                return JavaDataType.JAVA_STRING;
            }
            case INTEGER: {
                return JavaDataType.JAVA_LONG;
            }
            case FIXED: {
                return JavaDataType.JAVA_BIGDECIMAL;
            }
            case REAL: {
                return JavaDataType.JAVA_DOUBLE;
            }
            case TIMESTAMP: 
            case TIME: 
            case TIMESTAMP_LTZ: 
            case TIMESTAMP_NTZ: 
            case TIMESTAMP_TZ: 
            case DATE: {
                return JavaDataType.JAVA_TIMESTAMP;
            }
            case BOOLEAN: {
                return JavaDataType.JAVA_BOOLEAN;
            }
            case ARRAY: 
            case VARIANT: 
            case VECTOR: {
                return JavaDataType.JAVA_STRING;
            }
            case BINARY: {
                return JavaDataType.JAVA_BYTES;
            }
            case ANY: {
                return JavaDataType.JAVA_OBJECT;
            }
            case OBJECT: {
                if (isStructuredType) {
                    return JavaDataType.JAVA_OBJECT;
                }
                return JavaDataType.JAVA_STRING;
            }
        }
        return JavaDataType.JAVA_STRING;
    }

    public static int convertStringToType(String typeName) {
        int retval = 0;
        if (typeName == null || typeName.trim().isEmpty()) {
            return retval;
        }
        String typeNameTrimmed = typeName.trim();
        if (typeNameTrimmed.contains("(")) {
            typeNameTrimmed = typeNameTrimmed.substring(0, typeNameTrimmed.indexOf(40));
        }
        if (typeNameTrimmed.contains(" ")) {
            typeNameTrimmed = typeNameTrimmed.substring(0, typeNameTrimmed.indexOf(32));
        }
        switch (typeNameTrimmed.toLowerCase()) {
            case "number": 
            case "numeric": {
                retval = 2;
                break;
            }
            case "decimal": {
                retval = 3;
                break;
            }
            case "int": 
            case "integer": 
            case "byteint": {
                retval = 4;
                break;
            }
            case "tinyint": {
                retval = -6;
                break;
            }
            case "smallint": {
                retval = 5;
                break;
            }
            case "bigint": {
                retval = -5;
                break;
            }
            case "float": 
            case "float4": 
            case "float8": {
                retval = 6;
                break;
            }
            case "double": 
            case "double precision": {
                retval = 8;
                break;
            }
            case "real": {
                retval = 7;
                break;
            }
            case "char": 
            case "character": {
                retval = 1;
                break;
            }
            case "varchar": 
            case "string": 
            case "text": {
                retval = 12;
                break;
            }
            case "binary": {
                retval = -2;
                break;
            }
            case "varbinary": {
                retval = -3;
                break;
            }
            case "boolean": {
                retval = 16;
                break;
            }
            case "date": {
                retval = 91;
                break;
            }
            case "time": {
                retval = 92;
                break;
            }
            case "timestamp": 
            case "datetime": 
            case "timestamp_ntz": {
                retval = 93;
                break;
            }
            case "timestamp_ltz": 
            case "timestamp_tz": {
                retval = 2014;
                break;
            }
            case "variant": {
                retval = 1111;
                break;
            }
            case "object": {
                retval = 2000;
                break;
            }
            case "vector": {
                retval = 50003;
                break;
            }
            case "array": {
                retval = 2003;
                break;
            }
            default: {
                retval = 1111;
            }
        }
        return retval;
    }

    public static String lexicalValue(Object o, DateFormat dateFormat, DateFormat timeFormat, DateFormat timestampFormat, DateFormat timestampTzFormat) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        if (c == java.util.Date.class || c == Date.class) {
            return SnowflakeType.synchronizeFormat(o, dateFormat);
        }
        if (c == Time.class) {
            return SnowflakeType.synchronizeFormat(o, timeFormat);
        }
        if (c == Timestamp.class) {
            String stdFmt = o.toString();
            String nanos = stdFmt.substring(stdFmt.indexOf(46) + 1);
            String ret1 = SnowflakeType.synchronizeFormat(o, timestampFormat);
            String ret2 = SnowflakeType.synchronizeFormat(o, timestampTzFormat);
            return ret1 + nanos + ret2;
        }
        if (c == Double.class) {
            return Double.toHexString((Double)o);
        }
        if (c == Float.class) {
            return Float.toHexString(((Float)o).floatValue());
        }
        if (c == Integer.class) {
            return o.toString();
        }
        if (c == BigDecimal.class) {
            return o.toString();
        }
        if (c == byte[].class) {
            return new SFBinary((byte[])o).toHex();
        }
        return String.valueOf(o);
    }

    private static synchronized String synchronizeFormat(Object o, DateFormat sdf) {
        return sdf.format(o);
    }

    public static String escapeForCSV(String value) {
        if (value == null) {
            return "";
        }
        if (value.isEmpty()) {
            return "\"\"";
        }
        if (value.indexOf(34) >= 0 || value.indexOf(10) >= 0 || value.indexOf(44) >= 0 || value.indexOf(92) >= 0) {
            return '\"' + value.replaceAll("\"", "\"\"") + '\"';
        }
        return value;
    }

    public static SnowflakeType javaTypeToSFType(int javaType, SFBaseSession session) throws SnowflakeSQLException {
        switch (javaType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return FIXED;
            }
            case 1: 
            case 12: {
                return TEXT;
            }
            case -2: {
                return BINARY;
            }
            case 6: 
            case 8: {
                return REAL;
            }
            case 91: {
                return DATE;
            }
            case 92: {
                return TIME;
            }
            case 93: {
                return TIMESTAMP;
            }
            case 16: {
                return BOOLEAN;
            }
            case 2002: {
                return OBJECT;
            }
            case 2003: {
                return ARRAY;
            }
            case 0: {
                return ANY;
            }
        }
        throw new SnowflakeSQLLoggedException(session, (int)ErrorCode.DATA_TYPE_NOT_SUPPORTED.getMessageCode(), "0A000", javaType);
    }

    public static String javaTypeToClassName(int type) throws SQLException {
        switch (type) {
            case 1: 
            case 12: 
            case 2002: 
            case 2003: {
                return String.class.getName();
            }
            case -2: {
                return BINARY_CLASS_NAME;
            }
            case 4: {
                return Integer.class.getName();
            }
            case 3: {
                return BigDecimal.class.getName();
            }
            case 8: {
                return Double.class.getName();
            }
            case 93: 
            case 2014: {
                return Timestamp.class.getName();
            }
            case 91: {
                return Date.class.getName();
            }
            case 92: {
                return Time.class.getName();
            }
            case 16: {
                return Boolean.class.getName();
            }
            case -5: {
                return Long.class.getName();
            }
            case 5: {
                return Short.class.getName();
            }
        }
        throw new SQLFeatureNotSupportedException(String.format("No corresponding Java type is found for java.sql.Type: %d", type));
    }

    public static boolean isJavaTypeSigned(int type) {
        return type == 4 || type == 3 || type == 8;
    }

    static {
        BYTE_ARRAY = new byte[0];
        BINARY_CLASS_NAME = BYTE_ARRAY.getClass().getName();
    }

    public static enum JavaSQLType {
        ARRAY(2003),
        DATALINK(70),
        BIGINT(-5),
        BINARY(-2),
        BIT(-7),
        BLOB(2004),
        BOOLEAN(16),
        CHAR(1),
        CLOB(2005),
        DATE(91),
        DECIMAL(3),
        DISTINCT(2001),
        DOUBLE(8),
        FLOAT(6),
        INTEGER(4),
        JAVA_OBJECT(2000),
        LONGNVARCHAR(-16),
        LONGVARBINARY(-4),
        LONGVARCHAR(-1),
        NCHAR(-15),
        NCLOB(2011),
        NULL(0),
        NUMERIC(2),
        NVARCHAR(-9),
        OTHER(1111),
        REAL(7),
        REF(2006),
        REF_CURSOR(2012),
        ROWID(-8),
        SMALLINT(5),
        SQLXML(2009),
        STRUCT(2002),
        TIME(92),
        TIME_WITH_TIMEZONE(2013),
        TIMESTAMP(93),
        TIMESTAMP_WITH_TIMEZONE(2014),
        TINYINT(-6),
        VARBINARY(-3),
        VARCHAR(12),
        VECTOR(2003);

        private final int type;
        public static final Set<JavaSQLType> ALL_TYPES;

        private JavaSQLType(int type) {
            this.type = type;
        }

        int getType() {
            return this.type;
        }

        public static JavaSQLType find(int type) {
            for (JavaSQLType t : ALL_TYPES) {
                if (t.type != type) continue;
                return t;
            }
            return null;
        }

        static {
            ALL_TYPES = new HashSet<JavaSQLType>();
            ALL_TYPES.add(ARRAY);
            ALL_TYPES.add(DATALINK);
            ALL_TYPES.add(BIGINT);
            ALL_TYPES.add(BINARY);
            ALL_TYPES.add(BIT);
            ALL_TYPES.add(BLOB);
            ALL_TYPES.add(BOOLEAN);
            ALL_TYPES.add(CHAR);
            ALL_TYPES.add(CLOB);
            ALL_TYPES.add(DATE);
            ALL_TYPES.add(DECIMAL);
            ALL_TYPES.add(DISTINCT);
            ALL_TYPES.add(DOUBLE);
            ALL_TYPES.add(FLOAT);
            ALL_TYPES.add(INTEGER);
            ALL_TYPES.add(JAVA_OBJECT);
            ALL_TYPES.add(LONGNVARCHAR);
            ALL_TYPES.add(LONGVARBINARY);
            ALL_TYPES.add(LONGVARCHAR);
            ALL_TYPES.add(NCHAR);
            ALL_TYPES.add(NCLOB);
            ALL_TYPES.add(NULL);
            ALL_TYPES.add(NUMERIC);
            ALL_TYPES.add(NVARCHAR);
            ALL_TYPES.add(OTHER);
            ALL_TYPES.add(REAL);
            ALL_TYPES.add(REF);
            ALL_TYPES.add(REF_CURSOR);
            ALL_TYPES.add(ROWID);
            ALL_TYPES.add(SMALLINT);
            ALL_TYPES.add(SQLXML);
            ALL_TYPES.add(STRUCT);
            ALL_TYPES.add(TIME);
            ALL_TYPES.add(TIME_WITH_TIMEZONE);
            ALL_TYPES.add(TIMESTAMP);
            ALL_TYPES.add(TIMESTAMP_WITH_TIMEZONE);
            ALL_TYPES.add(TINYINT);
            ALL_TYPES.add(VARBINARY);
            ALL_TYPES.add(VARCHAR);
            ALL_TYPES.add(VECTOR);
        }
    }

    public static enum JavaDataType {
        JAVA_STRING(String.class),
        JAVA_LONG(Long.class),
        JAVA_DOUBLE(Double.class),
        JAVA_BIGDECIMAL(BigDecimal.class),
        JAVA_TIMESTAMP(Timestamp.class),
        JAVA_BYTES(byte[].class),
        JAVA_BOOLEAN(Boolean.class),
        JAVA_OBJECT(Object.class);

        private Class<?> _class;

        private JavaDataType(Class<?> c) {
            this._class = c;
        }
    }
}

