/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.auth.wif;

import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.auth.wif.WorkloadIdentityAttestation;
import net.snowflake.client.core.auth.wif.WorkloadIdentityAttestationCreator;
import net.snowflake.client.core.auth.wif.WorkloadIdentityProviderType;
import net.snowflake.client.core.auth.wif.WorkloadIdentityUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

@SnowflakeJdbcInternalApi
public class OidcIdentityAttestationCreator
implements WorkloadIdentityAttestationCreator {
    private static final SFLogger logger = SFLoggerFactory.getLogger(OidcIdentityAttestationCreator.class);
    private final String token;

    public OidcIdentityAttestationCreator(String token) {
        this.token = token;
    }

    @Override
    public WorkloadIdentityAttestation createAttestation() {
        logger.debug("Creating OIDC identity attestation...", new Object[0]);
        if (this.token == null) {
            logger.debug("No OIDC token was specified", new Object[0]);
            return null;
        }
        WorkloadIdentityUtil.SubjectAndIssuer claims = WorkloadIdentityUtil.extractClaimsWithoutVerifyingSignature(this.token);
        if (claims == null) {
            logger.error("Could not extract claims from token", new Object[0]);
            return null;
        }
        return new WorkloadIdentityAttestation(WorkloadIdentityProviderType.OIDC, this.token, claims.toMap());
    }
}

