/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.security.cert.CertificateException;
import net.minidev.json.JSONObject;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;

public class OCSPTelemetryData {
    private String certId;
    private String sfcPeerHost;
    private String ocspUrl;
    private String ocspReq;
    private Boolean cacheEnabled = true;
    private Boolean cacheHit;
    private OCSPMode ocspMode = OCSPMode.FAIL_OPEN;

    public void setCertId(String certId) {
        this.certId = certId;
    }

    public void setSfcPeerHost(String sfcPeerHost) {
        this.sfcPeerHost = sfcPeerHost;
    }

    public void setOcspUrl(String ocspUrl) {
        this.ocspUrl = ocspUrl;
    }

    public void setOcspReq(String ocspReq) {
        this.ocspReq = ocspReq;
    }

    public void setCacheEnabled(Boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
        if (!cacheEnabled.booleanValue()) {
            this.cacheHit = false;
        }
    }

    public void setCacheHit(Boolean cacheHit) {
        this.cacheHit = this.cacheEnabled == false ? Boolean.valueOf(false) : cacheHit;
    }

    public void setOCSPMode(OCSPMode ocspMode) {
        this.ocspMode = ocspMode;
    }

    public String generateTelemetry(String eventType, CertificateException ex) {
        JSONObject value = new JSONObject();
        value.put((Object)"eventType", (Object)eventType);
        value.put((Object)"sfcPeerHost", (Object)this.sfcPeerHost);
        value.put((Object)"certId", (Object)this.certId);
        value.put((Object)"ocspResponderURL", (Object)this.ocspUrl);
        value.put((Object)"ocspReqBase64", (Object)this.ocspReq);
        value.put((Object)"ocspMode", (Object)this.ocspMode.name());
        value.put((Object)"cacheEnabled", (Object)this.cacheEnabled);
        value.put((Object)"cacheHit", (Object)this.cacheHit);
        String valueStr = value.toString();
        TelemetryService.getInstance().logOCSPExceptionTelemetryEvent(eventType, value, ex);
        return valueStr;
    }
}

