/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.common.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class ComponentInfo {
    public static final String VERSION_FORMAT_PATTERN = "[0-9]+(\\.[0-9]+)(\\.[0-9]+)(\\.[0-9a-zA-Z_-]+)?";
    private static final String VERSION_DELIMITER = "\\.";
    private static Version theVersion;
    private static boolean initialized;

    public static Version getVersion() {
        if (!initialized) {
            throw new IllegalStateException("ComponentInfo not initialized");
        }
        return theVersion;
    }

    public static void initialize() throws Exception {
        ComponentInfo.initialize(ComponentInfo.class);
    }

    public static void initialize(Class<?> klass) throws Exception {
        String buildId;
        String implVersion;
        URI jarURI = klass.getProtectionDomain().getCodeSource().getLocation().toURI();
        if (!jarURI.toString().endsWith(".jar")) {
            theVersion = new Version(-1, -1, -1, null);
            initialized = true;
            return;
        }
        try (InputStream is = null;){
            is = jarURI.toURL().openStream();
            if (is == null) {
                throw new RuntimeException("Couldn't open jar:" + jarURI);
            }
            JarInputStream jarStream = new JarInputStream(is);
            Manifest mf = jarStream.getManifest();
            if (mf == null) {
                throw new IllegalStateException("Couldn't find manifest in:" + jarURI.toURL());
            }
            Attributes mainAttribs = mf.getMainAttributes();
            implVersion = mainAttribs.getValue("Snowflake-Version");
            buildId = mainAttribs.getValue("Snowflake-BuildId");
        }
        int major = -1;
        int minor = -1;
        int patch = -1;
        if (implVersion != null) {
            try {
                String[] majorMinorPatch = implVersion.split(VERSION_DELIMITER);
                if (majorMinorPatch != null && majorMinorPatch.length >= 2) {
                    major = Integer.parseInt(majorMinorPatch[0]);
                    minor = Integer.parseInt(majorMinorPatch[1]);
                    patch = majorMinorPatch.length >= 3 ? Integer.parseInt(majorMinorPatch[2]) : 0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        theVersion = new Version(major, minor, patch, buildId);
        initialized = true;
    }

    public static void initialize(Version version) {
        theVersion = version;
        initialized = version != null;
    }

    static {
        initialized = false;
    }

    public static class Version
    implements Comparable<Version> {
        private final int majorVersion;
        private final int minorVersion;
        private final int patchVersion;
        private String buildId;

        public Version() {
            this.majorVersion = 0;
            this.minorVersion = 0;
            this.patchVersion = 0;
            this.buildId = null;
        }

        public Version(int majorVersion, int minorVersion, int patchVersion, String buildId) {
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
            this.patchVersion = patchVersion;
            this.buildId = buildId;
        }

        public Version(String version) {
            List<String> versionDecomposed;
            if (version != null && version.matches(ComponentInfo.VERSION_FORMAT_PATTERN) && (versionDecomposed = Arrays.asList(version.split(ComponentInfo.VERSION_DELIMITER, -1))).size() >= 3) {
                this.majorVersion = Integer.parseInt(versionDecomposed.get(0));
                this.minorVersion = Integer.parseInt(versionDecomposed.get(1));
                this.patchVersion = Integer.parseInt(versionDecomposed.get(2));
                return;
            }
            this.majorVersion = 0;
            this.minorVersion = 0;
            this.patchVersion = 0;
        }

        public static final Version fromRank(long versionRank) {
            return new Version((int)(versionRank >> 32), (int)(versionRank >> 16 & 0x7FFFL), (int)(versionRank & 0x7FFFL), "");
        }

        @JsonIgnore
        public long getVersionRank() {
            return (long)this.majorVersion << 32 | (long)this.minorVersion << 16 | (long)this.patchVersion;
        }

        public int getMajorVersion() {
            return this.majorVersion;
        }

        public int getMinorVersion() {
            return this.minorVersion;
        }

        public int getPatchVersion() {
            return this.patchVersion;
        }

        public String getBuildId() {
            return this.buildId;
        }

        @JsonIgnore
        public int getSvnRevisionObsolete() {
            try {
                return this.buildId != null ? Integer.parseInt(this.buildId) : -1;
            }
            catch (NumberFormatException ex) {
                return 0;
            }
        }

        public String getVersionAsString(boolean showBuildNumber) {
            return this.getVersionAsString(showBuildNumber, true);
        }

        public String getVersionAsString(boolean showBuildNumber, boolean includePatchVersion) {
            String versionStr;
            if (this.majorVersion == -1) {
                versionStr = "Dev";
            } else {
                versionStr = (this.majorVersion > -1 ? this.majorVersion : 0) + "." + (this.minorVersion > -1 ? this.minorVersion : 0);
                if (includePatchVersion) {
                    versionStr = versionStr + "." + (this.patchVersion > -1 ? this.patchVersion : 0);
                }
                if (this.majorVersion == 0) {
                    versionStr = versionStr + " (Beta)";
                }
            }
            if (showBuildNumber && this.buildId != null) {
                versionStr = versionStr + " b" + this.buildId;
            }
            return versionStr;
        }

        public void setSvnRevision(int svnRevision) {
            this.buildId = String.valueOf(svnRevision);
        }

        @Override
        public int compareTo(Version other) {
            if (this == other) {
                return 0;
            }
            return Comparator.comparingInt(Version::getMajorVersion).thenComparingInt(Version::getMinorVersion).thenComparingInt(Version::getPatchVersion).thenComparing(Version::getBuildId, Comparator.nullsLast(Comparator.naturalOrder())).compare(this, other);
        }

        public String toString() {
            return "majorVersion=" + this.majorVersion + ", minorVersion=" + this.minorVersion + ", patchVersion=" + this.patchVersion + ", buildId=" + this.buildId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Version)) {
                return false;
            }
            Version version = (Version)o;
            return this.majorVersion == version.majorVersion && this.minorVersion == version.minorVersion && this.patchVersion == version.patchVersion && Objects.equals(this.buildId, version.buildId);
        }

        public int hashCode() {
            return Objects.hash(this.majorVersion, this.minorVersion, this.patchVersion, this.buildId);
        }
    }
}

