/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.common.core;

import java.text.SimpleDateFormat;
import net.snowflake.common.core.CalendarCache;
import net.snowflake.common.core.SFInstant;
import net.snowflake.common.core.SFTimestamp;

public class SFTime
extends SFInstant {
    private final long nanos;
    private static final long NS_IN_SECOND = 1000000000L;
    private static final long NS_IN_MILLIS = 1000000L;
    private static final long NS_IN_DAY = 86400000000000L;

    public static SFTime fromNanoseconds(long nanos) {
        return new SFTime(nanos);
    }

    public static SFTime fromFractionalSeconds(long value, int scale) {
        assert (scale >= 0 && scale <= 9);
        int powerOfTen = SFInstant.POWERS_OF_TEN[9 - scale];
        return new SFTime(value * (long)powerOfTen);
    }

    public static SFTime fromTimestamp(SFTimestamp ts) {
        long secondsSinceMidnight = ts.extract(11) * 3600 + ts.extract(12) * 60 + ts.extract(13);
        long nsSinceMidnight = secondsSinceMidnight * 1000000000L;
        long additionalNs = ts.getNanos();
        return new SFTime(nsSinceMidnight + additionalNs);
    }

    private SFTime(long nanos) {
        assert (nanos >= 0L && nanos < 86400000000000L);
        this.nanos = nanos;
    }

    public long getNanoseconds() {
        return this.nanos;
    }

    public int getNanosecondsWithinSecond() {
        return (int)(this.nanos % (long)SFInstant.POWERS_OF_TEN[9]);
    }

    public long getFractionalSeconds(int scale) {
        assert (scale >= 0 && scale <= 9);
        return this.nanos / (long)SFInstant.POWERS_OF_TEN[9 - scale];
    }

    public SFTime addComponent(int component, long increment) {
        switch (component) {
            case 11: {
                increment = 3600000000000L * (increment % 24L);
                break;
            }
            case 12: {
                increment = 60000000000L * (increment % 1440L);
                break;
            }
            case 13: {
                increment = 1000000000L * (increment % 86400L);
                break;
            }
            case 14: {
                increment = 1000000L * (increment % 86400000L);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid component " + component);
            }
        }
        long newNanos = ((this.nanos + increment) % 86400000000000L + 86400000000000L) % 86400000000000L;
        return new SFTime(newNanos);
    }

    public SFTime adjustScale(int scale) {
        long powerOfTen = SFInstant.POWERS_OF_TEN[9 - scale];
        long extraDigits = this.nanos % powerOfTen;
        return extraDigits == 0L ? this : new SFTime(this.nanos - extraDigits);
    }

    public String toUTCString() {
        long nanoPart = this.nanos % 1000000000L;
        String nanoStr = String.format(".%1$09d", nanoPart);
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss" + nanoStr);
        df.setCalendar(CalendarCache.get(SFInstant.GMT));
        return df.format(this.nanos / 1000000L);
    }

    public String toSecondsString(int decimalPlaces) {
        StringBuilder result = new StringBuilder();
        result.append(this.nanos / 1000000000L);
        if (decimalPlaces > 0) {
            long nanoPart = this.nanos % 1000000000L;
            long powerOfTen = SFInstant.POWERS_OF_TEN[9 - decimalPlaces];
            long afterDecimal = nanoPart / powerOfTen;
            result.append('.');
            String fmt = "%0" + decimalPlaces + "d";
            result.append(String.format(fmt, afterDecimal));
        }
        return result.toString();
    }

    public int compareTo(SFTime other) {
        return Long.compare(this.nanos, other.nanos);
    }

    @Override
    public int extract(int field) {
        return this.extract(field, SFInstant.GMT, this.nanos / 1000000L);
    }

    public int hashCode() {
        return (int)(this.nanos % Integer.MAX_VALUE);
    }

    public boolean equals(Object other) {
        return other instanceof SFTime && this.nanos == ((SFTime)other).nanos;
    }

    public String toString() {
        return "SFTime(nanos=" + this.nanos + ")";
    }
}

