/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.common.core;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceBundleManager {
    private static Map<String, ResourceBundleManager> resourceManagers = new HashMap<String, ResourceBundleManager>();
    private static final Object lockObject = new Object();
    private final String bundleName;
    private ResourceBundle resourceBundle;

    private ResourceBundleManager(String bundleName) {
        this.bundleName = bundleName;
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(this.bundleName, Locale.getDefault());
        }
        catch (Throwable ex1) {
            try {
                bundle = ResourceBundle.getBundle(this.bundleName);
            }
            catch (Throwable ex2) {
                throw new RuntimeException("Can't load localized resource bundle due to " + ex1.toString() + " and can't load default resource bundle due to " + ex2.toString());
            }
        }
        finally {
            this.resourceBundle = bundle;
        }
    }

    public String getLocalizedMessage(String key) {
        if (this.resourceBundle == null) {
            throw new RuntimeException("Localized messages from resource bundle '" + this.bundleName + "' not loaded.");
        }
        try {
            if (key == null) {
                throw new IllegalArgumentException("Message key cannot be null");
            }
            String message = this.resourceBundle.getString(key);
            if (message == null) {
                message = "!!" + key + "!!";
            }
            return message;
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public String getLocalizedMessage(String key, Object ... args) {
        return MessageFormat.format(this.getLocalizedMessage(key), args);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBundleManager getSingleton(String bundleName) {
        if (resourceManagers.get(bundleName) != null) {
            return resourceManagers.get(bundleName);
        }
        Object object = lockObject;
        synchronized (object) {
            if (resourceManagers.get(bundleName) != null) {
                return resourceManagers.get(bundleName);
            }
            resourceManagers.put(bundleName, new ResourceBundleManager(bundleName));
        }
        return resourceManagers.get(bundleName);
    }
}

