/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.common.core;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.TimeZone;

public class CalendarCache {
    private static final ThreadLocal<CalendarCacheState> localState = new ThreadLocal<CalendarCacheState>(){

        @Override
        protected CalendarCacheState initialValue() {
            return new CalendarCacheState();
        }
    };

    public static void setEnabled(boolean enabled) {
        CalendarCache.localState.get().enabled = enabled;
    }

    public static void setAlwaysGregorian(boolean alwaysGregorian) {
        CalendarCache.localState.get().alwaysGregorian = alwaysGregorian;
        CalendarCache.localState.get().map.clear();
    }

    public static GregorianCalendar get(TimeZone timezone, String tzId, String calId) {
        GregorianCalendar res;
        CalendarCacheState state = localState.get();
        if (state.enabled) {
            res = state.map.get(calId);
            if (res == null) {
                if (timezone == null) {
                    timezone = TimeZone.getTimeZone(tzId);
                }
                res = new GregorianCalendar(timezone);
                state.map.put(calId, res);
            } else if (timezone != null & !res.getTimeZone().hasSameRules(timezone)) {
                throw new IllegalArgumentException("Cached timezone is not equivalent to the requested one:" + timezone + "  VS  " + res.getTimeZone());
            }
        } else {
            if (timezone == null) {
                timezone = TimeZone.getTimeZone(tzId);
            }
            res = new GregorianCalendar(timezone);
        }
        res.clear();
        if (state.alwaysGregorian) {
            res.setGregorianChange(new Date(Long.MIN_VALUE));
        }
        return res;
    }

    public static GregorianCalendar get(TimeZone timezone, String calId) {
        return CalendarCache.get(timezone, null, calId);
    }

    public static GregorianCalendar get(TimeZone timezone) {
        return CalendarCache.get(timezone, null, timezone.getID());
    }

    public static GregorianCalendar get(String tzId) {
        return CalendarCache.get(null, tzId, tzId);
    }

    private static class CalendarCacheState {
        HashMap<String, GregorianCalendar> map = new HashMap();
        boolean enabled = false;
        boolean alwaysGregorian = false;
    }
}

