/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.common.core;

import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.TimeZone;

public class CalendarCache {
    private static final ThreadLocal<CalendarCacheState> localState = new ThreadLocal<CalendarCacheState>(){

        @Override
        protected CalendarCacheState initialValue() {
            return new CalendarCacheState();
        }
    };

    public static void setEnabled(boolean enabled) {
        CalendarCache.localState.get().enabled = enabled;
    }

    public static GregorianCalendar get(TimeZone timezone, String id) {
        GregorianCalendar res;
        CalendarCacheState state = localState.get();
        if (state.enabled) {
            res = state.map.get(id);
            if (res == null) {
                res = new GregorianCalendar(timezone);
                state.map.put(id, res);
            }
        } else {
            res = new GregorianCalendar(timezone);
        }
        res.clear();
        return res;
    }

    public static GregorianCalendar get(TimeZone timezone) {
        return CalendarCache.get(timezone, timezone.getID());
    }

    private static class CalendarCacheState {
        HashMap<String, GregorianCalendar> map = new HashMap();
        boolean enabled = false;
    }
}

