/*
 * Decompiled with CFR 0.152.
 */
package net.smartlab.web.test;

import com.mchange.v2.c3p0.DataSources;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.sql.DataSource;
import net.smartlab.web.BusinessObjectFactory;
import net.smartlab.web.config.FactoryConfigurationStrategy;
import net.smartlab.web.test.BusinessObjectFactoryTestSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbunit.DatabaseTestCase;
import org.dbunit.DefaultDatabaseTester;
import org.dbunit.IDatabaseTester;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.QueryDataSet;
import org.dbunit.dataset.DefaultDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectFactory;
import org.mockejb.jndi.MockContextFactory;

public abstract class BusinessObjectFactoryTestCase
extends DatabaseTestCase {
    protected static final Map factories = new HashMap();
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Dialect dialect;
    private DataSource datasource;
    static /* synthetic */ Class class$java$lang$Object;

    public BusinessObjectFactoryTestCase() {
    }

    public BusinessObjectFactoryTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"setUp() - start");
        }
        MockContextFactory.setAsInitial();
        BusinessObjectFactoryTestSupport support = new BusinessObjectFactoryTestSupport(this.getFactoryConfiguration());
        BusinessObjectFactory.setConfigurationStrategy((FactoryConfigurationStrategy)support);
        InitialContext context = new InitialContext();
        try {
            this.datasource = (DataSource)context.lookup(((Object)((Object)this)).getClass().getCanonicalName() + "/ds");
            this.dialect = (Dialect)context.lookup(((Object)((Object)this)).getClass().getCanonicalName() + "/hd");
        }
        catch (NameNotFoundException nnfe) {
            Configuration configuration = new Configuration().configure(this.getFactoryConfiguration());
            try {
                Properties props = new Properties();
                props.load((class$java$lang$Object == null ? (class$java$lang$Object = BusinessObjectFactoryTestCase.class$("java.lang.Object")) : class$java$lang$Object).getResourceAsStream("/hibernate.properties"));
                configuration.addProperties(props);
            }
            catch (FileNotFoundException fne) {
                this.logger.warn((Object)"hibernate.properties file not found");
            }
            this.dialect = DialectFactory.buildDialect((String)configuration.getProperty("hibernate.dialect"));
            Class.forName(configuration.getProperty("hibernate.connection.driver_class"));
            this.datasource = DataSources.unpooledDataSource((String)configuration.getProperty("hibernate.connection.url"), (String)configuration.getProperty("hibernate.connection.username"), (String)configuration.getProperty("hibernate.connection.password"));
            if (configuration.getProperty("connection.datasource") != null) {
                context.bind(configuration.getProperty("connection.datasource"), (Object)this.datasource);
            }
            context.bind(((Object)((Object)this)).getClass().getCanonicalName() + "/ds", (Object)this.datasource);
            context.bind(((Object)((Object)this)).getClass().getCanonicalName() + "/hd", (Object)this.dialect);
        }
        super.setUp();
    }

    protected void tearDown() throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"tearDown() - start");
        }
        BusinessObjectFactory.flush();
        super.tearDown();
    }

    protected IDatabaseTester newDatabaseTester() throws Exception {
        return new DefaultDatabaseTester(null){

            public IDatabaseConnection getConnection() throws Exception {
                return BusinessObjectFactoryTestCase.this.getConnection();
            }
        };
    }

    protected URL getFactoryConfiguration() throws Exception {
        return new File("res/smartweb.jar.hcf").toURI().toURL();
    }

    protected URL getConfigurationFile() throws Exception {
        return this.getFactoryConfiguration();
    }

    protected IDatabaseConnection getConnection() throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"getConnection() - start");
        }
        if (this.datasource == null || this.dialect == null) {
            this.setUp();
        }
        DatabaseConnection connection = new DatabaseConnection(this.datasource.getConnection());
        connection.getConfig().setFeature("http://www.dbunit.org/features/qualifiedTableNames", this.dialect.qualifyIndexName());
        connection.getConfig().setProperty("http://www.dbunit.org/properties/escapePattern", (Object)(this.dialect.openQuote() + "?" + this.dialect.closeQuote()));
        return connection;
    }

    protected IDataSet getDataSet() throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"getDataSet() - start");
            this.logger.trace((Object)("  res = " + this.getDataSetFile()));
        }
        try {
            return new FlatXmlDataSet((InputStream)new FileInputStream(this.getDataSetFile()));
        }
        catch (Exception e) {
            this.logger.warn((Object)"getDataSet() - not found");
            return new DefaultDataSet();
        }
    }

    protected abstract String getDataSetFile();

    public void export(String[][] tables) throws Exception {
        QueryDataSet dataSet = new QueryDataSet(this.getConnection());
        for (int i = 0; i < tables.length; ++i) {
            if (tables[i][1] == null) {
                dataSet.addTable(tables[i][0]);
                continue;
            }
            dataSet.addTable(tables[i][0], tables[i][1]);
        }
        FlatXmlDataSet.write((IDataSet)dataSet, (OutputStream)new FileOutputStream(this.getDataSetFile()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

