/*
 * Decompiled with CFR 0.152.
 */
package net.skoumal.fragmentback;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.skoumal.fragmentback.BackFragment;

public class BackFragmentHelper {
    private BackFragmentHelper() {
    }

    public static boolean fireOnBackPressedEvent(FragmentActivity gActivity) {
        List<Fragment> fragmentList = BackFragmentHelper.getAllActivityFragments(gActivity);
        return BackFragmentHelper.fireOnBackPressedEvent(fragmentList);
    }

    private static List<Fragment> getAllActivityFragments(FragmentActivity gActivity) {
        List fragmentList = gActivity.getSupportFragmentManager().getFragments();
        if (fragmentList != null && fragmentList.size() > 0) {
            ArrayList<Fragment> result = new ArrayList<Fragment>(fragmentList);
            for (Fragment f : fragmentList) {
                List nestedFragmentList = f.getChildFragmentManager().getFragments();
                if (nestedFragmentList == null || nestedFragmentList.size() <= 0) continue;
                result.addAll(nestedFragmentList);
            }
            return result;
        }
        return new ArrayList<Fragment>(0);
    }

    private static boolean fireOnBackPressedEvent(List<?> gFragmentList) {
        BackFragment f;
        ArrayList<BackFragment> backFragmentList = new ArrayList<BackFragment>(gFragmentList.size());
        for (Object f2 : gFragmentList) {
            if (!(f2 instanceof BackFragment)) continue;
            backFragmentList.add((BackFragment)f2);
        }
        Collections.sort(backFragmentList, new Comparator<BackFragment>(){

            @Override
            public int compare(BackFragment lhs, BackFragment rhs) {
                return rhs.getBackPriority() - lhs.getBackPriority();
            }
        });
        boolean handled = false;
        Iterator i$ = backFragmentList.iterator();
        while (i$.hasNext() && !(handled = (f = (BackFragment)i$.next()).onBackPressed())) {
        }
        return handled;
    }
}

