/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.xml;

import java.util.HashMap;
import javax.xml.namespace.NamespaceContext;
import net.shibboleth.utilities.java.support.xml.SimpleNamespaceContext;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SimpleNamespaceContextTest {
    private static final String PREFIX_A = "a";
    private static final String URI_A = "value:of:a";
    private static final String PREFIX_B = "b";
    private static final String URI_B = "value:of:b";
    private NamespaceContext stdContext;

    @BeforeClass
    public void createStandardMappings() {
        HashMap<String, String> prefixMappings = new HashMap<String, String>();
        prefixMappings.put(PREFIX_A, URI_A);
        prefixMappings.put(PREFIX_B, URI_B);
        this.stdContext = new SimpleNamespaceContext(prefixMappings);
    }

    @Test
    public void testGetNamespaceURI() {
        Assert.assertEquals((String)this.stdContext.getNamespaceURI(PREFIX_A), (String)URI_A);
        Assert.assertEquals((String)this.stdContext.getNamespaceURI(PREFIX_B), (String)URI_B);
        Assert.assertEquals((String)this.stdContext.getNamespaceURI("xml"), (String)"http://www.w3.org/XML/1998/namespace");
        Assert.assertEquals((String)this.stdContext.getNamespaceURI("xmlns"), (String)"http://www.w3.org/2000/xmlns/");
        Assert.assertEquals((String)this.stdContext.getNamespaceURI("c"), (String)"");
    }

    @Test
    public void testGetPrefix() {
        Assert.assertEquals((String)this.stdContext.getPrefix(URI_A), (String)PREFIX_A);
        Assert.assertEquals((String)this.stdContext.getPrefix(URI_B), (String)PREFIX_B);
        Assert.assertEquals((String)this.stdContext.getPrefix("http://www.w3.org/XML/1998/namespace"), (String)"xml");
        Assert.assertEquals((String)this.stdContext.getPrefix("http://www.w3.org/2000/xmlns/"), (String)"xmlns");
        Assert.assertNull((Object)this.stdContext.getPrefix("value:of:c"));
    }

    @Test
    public void testGetPrefixes() {
        Assert.assertEquals((String)this.stdContext.getPrefixes(URI_A).next(), (String)PREFIX_A);
        Assert.assertEquals((String)this.stdContext.getPrefixes(URI_B).next(), (String)PREFIX_B);
        Assert.assertEquals((String)this.stdContext.getPrefixes("http://www.w3.org/XML/1998/namespace").next(), (String)"xml");
        Assert.assertEquals((String)this.stdContext.getPrefixes("http://www.w3.org/2000/xmlns/").next(), (String)"xmlns");
        Assert.assertFalse((boolean)this.stdContext.getPrefixes("value:of:c").hasNext());
    }
}

