/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.springframework.core.io.ClassPathResource;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public class SerializeSupportTest {
    private Element parent;
    private BasicParserPool parserPool;

    private int countNonNamespaceAttributes(NamedNodeMap attrs) {
        int n = 0;
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().startsWith("xmlns")) continue;
            ++n;
        }
        return n;
    }

    private void assertEquals(Node expected, Node actual) {
        Assert.assertEquals((short)expected.getNodeType(), (short)actual.getNodeType(), (String)("Different types of nodes: " + expected + " " + actual));
        if (expected instanceof Document) {
            Document expectedDoc = (Document)expected;
            Document actualDoc = (Document)actual;
            this.assertEquals(expectedDoc.getDocumentElement(), actualDoc.getDocumentElement());
        } else if (expected instanceof Element) {
            Element expectedElement = (Element)expected;
            Element actualElement = (Element)actual;
            Assert.assertEquals((String)expectedElement.getLocalName(), (String)actualElement.getLocalName(), (String)("Element names do not match: " + expectedElement.getLocalName() + " " + actualElement.getLocalName()));
            String expectedNS = expectedElement.getNamespaceURI();
            String actualNS = actualElement.getNamespaceURI();
            Assert.assertFalse((expectedNS == null && actualNS != null || expectedNS != null && !expectedNS.equals(actualNS) ? 1 : 0) != 0, (String)("Element namespaces names do not match: " + expectedNS + " " + actualNS));
            String elementName = "{" + expectedElement.getNamespaceURI() + "}" + actualElement.getLocalName();
            NamedNodeMap expectedAttrs = expectedElement.getAttributes();
            NamedNodeMap actualAttrs = actualElement.getAttributes();
            Assert.assertEquals((int)this.countNonNamespaceAttributes(expectedAttrs), (int)this.countNonNamespaceAttributes(actualAttrs), (String)(": Number of attributes do not match up: " + this.countNonNamespaceAttributes(expectedAttrs) + " " + this.countNonNamespaceAttributes(actualAttrs)));
            for (int i = 0; i < expectedAttrs.getLength(); ++i) {
                Attr expectedAttr = (Attr)expectedAttrs.item(i);
                if (expectedAttr.getName().startsWith("xmlns")) continue;
                Attr actualAttr = null;
                actualAttr = expectedAttr.getNamespaceURI() == null ? (Attr)actualAttrs.getNamedItem(expectedAttr.getName()) : (Attr)actualAttrs.getNamedItemNS(expectedAttr.getNamespaceURI(), expectedAttr.getLocalName());
                Assert.assertNotNull((Object)actualAttr, (String)(elementName + ": No attribute found:" + expectedAttr));
                Assert.assertEquals((String)expectedAttr.getValue(), (String)actualAttr.getValue(), (String)(elementName + ": Attribute values do not match: " + expectedAttr.getValue() + " " + actualAttr.getValue()));
            }
            NodeList expectedChildren = expectedElement.getChildNodes();
            NodeList actualChildren = actualElement.getChildNodes();
            Assert.assertEquals((int)expectedChildren.getLength(), (int)actualChildren.getLength(), (String)(elementName + ": Number of children do not match up: " + expectedChildren.getLength() + " " + actualChildren.getLength()));
            for (int i = 0; i < expectedChildren.getLength(); ++i) {
                Node expectedChild = expectedChildren.item(i);
                Node actualChild = actualChildren.item(i);
                this.assertEquals(expectedChild, actualChild);
            }
        } else if (expected instanceof Text) {
            String expectedData = ((Text)expected).getData().trim();
            String actualData = ((Text)actual).getData().trim();
            Assert.assertEquals((String)expectedData, (String)actualData, (String)("Text does not match: " + expectedData + " " + actualData));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public void setup() throws XMLParserException, ComponentInitializationException, SAXException, IOException {
        this.parserPool = new BasicParserPool();
        this.parserPool.initialize();
        DocumentBuilder builder = this.parserPool.getBuilder();
        try {
            ClassPathResource resource = new ClassPathResource("/net/shibboleth/utilities/java/support/xml/serializeSupportTest.xml");
            Document testFile = builder.parse(resource.getInputStream());
            this.parent = (Element)testFile.getFirstChild();
        }
        finally {
            this.parserPool.returnBuilder(builder);
        }
    }

    @Test
    public void testNodeToString() throws Exception {
        String s = SerializeSupport.nodeToString((Node)this.parent);
        Document dom = this.parserPool.parse((Reader)new StringReader(s));
        Assert.assertEquals((String)SerializeSupport.nodeToString((Node)dom.getFirstChild()), (String)s, (String)"Should serialize to same output");
        this.assertEquals(this.parent, dom.getFirstChild());
    }

    @Test(dependsOnMethods={"testNodeToString"})
    public void testWriteNode() throws XMLParserException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        SerializeSupport.writeNode((Node)this.parent, (OutputStream)output);
        byte[] data = output.toByteArray();
        Document dom = this.parserPool.parse((InputStream)new ByteArrayInputStream(data));
        Assert.assertEquals((String)SerializeSupport.nodeToString((Node)dom.getFirstChild()), (String)SerializeSupport.nodeToString((Node)this.parent), (String)"Should serialize to same output");
        this.assertEquals(dom.getFirstChild(), this.parent);
    }

    @Test(dependsOnMethods={"testNodeToString"})
    public void testPrettyPrintXML() throws XMLParserException {
        String s = SerializeSupport.prettyPrintXML((Node)this.parent);
        Document dom = this.parserPool.parse((Reader)new StringReader(s));
        Assert.assertTrue((boolean)SerializeSupport.nodeToString((Node)dom.getFirstChild()).equals(SerializeSupport.nodeToString((Node)this.parent)), (String)"Should serialize to same output");
        this.assertEquals(dom.getFirstChild(), this.parent);
        Assert.assertEquals((String)SerializeSupport.prettyPrintXML((Node)dom.getFirstChild()), (String)s, (String)"Pretty print should match");
    }

    @Test(dependsOnMethods={"testNodeToString"})
    public void testLSOps() throws XMLParserException {
        DOMImplementationLS domLS = SerializeSupport.getDOMImplementationLS((Node)this.parent);
        LSSerializer serializer = SerializeSupport.getLSSerializer((DOMImplementationLS)domLS, null);
        LSOutput serializerOut = domLS.createLSOutput();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        serializerOut.setByteStream(output);
        serializer.write(this.parent, serializerOut);
        Document dom = this.parserPool.parse((InputStream)new ByteArrayInputStream(output.toByteArray()));
        Assert.assertEquals((String)SerializeSupport.nodeToString((Node)dom.getFirstChild()), (String)SerializeSupport.nodeToString((Node)this.parent), (String)"Should serialize to same output");
        this.assertEquals(dom.getFirstChild(), this.parent);
    }

    @Test(enabled=false)
    public void testXMLVersion() throws XMLParserException {
        Document doc = this.parserPool.newDocument();
        Element root = doc.createElementNS(null, "test");
        doc.appendChild(root);
        StringBuilder data = new StringBuilder("foo");
        data.append('\u0019');
        data.append("bar");
        Text text = doc.createTextNode(data.toString());
        root.appendChild(text);
        DOMImplementationLS domLS = SerializeSupport.getDOMImplementationLS((Node)this.parent);
        LSSerializer serializer = SerializeSupport.getLSSerializer((DOMImplementationLS)domLS, null);
        LSOutput serializerOut = domLS.createLSOutput();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        serializerOut.setByteStream(output);
        try {
            serializer.write(doc, serializerOut);
            Assert.fail((String)"Should have thrown a DOM error.");
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
    }
}

