/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.xml;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import net.shibboleth.utilities.java.support.xml.NamespaceSupport;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.springframework.core.io.ClassPathResource;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class NamespaceSupportTest {
    private Element parent;
    private Element child;
    private Element grandchild;
    private BasicParserPool parserPool;
    private static final String NAMESPACE_1 = "http://example.org/NameSpace1";
    private static final String NAMESPACE_2 = "http://example.org/NameSpace2";
    private static final String NAMESPACE_3 = "http://example.org/NameSpace3";
    private static final String NAMESPACE_4 = "http://example.org/NameSpace4";
    private static final String DEFAULT_NAMESPACE_1 = "http://example.org/DefaultSpace1";
    private static final String DEFAULT_NAMESPACE_2 = "http://example.org/DefaultSpace2";
    private static final String PREFIX_1 = "myns1";
    private static final String PREFIX_2 = "myns2";
    private static final String PREFIX_3 = "myns3";
    private static final String PREFIX_4 = "myns4";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeMethod
    public void setup() throws XMLParserException, ComponentInitializationException, SAXException, IOException {
        this.parserPool = new BasicParserPool();
        this.parserPool.initialize();
        DocumentBuilder builder = this.parserPool.getBuilder();
        try {
            ClassPathResource resource = new ClassPathResource("/net/shibboleth/utilities/java/support/xml/namespaceSupportTest.xml");
            Document testFile = builder.parse(resource.getInputStream());
            this.parent = (Element)testFile.getFirstChild();
            this.child = ElementSupport.getFirstChildElement((Node)this.parent);
            this.grandchild = ElementSupport.getFirstChildElement((Node)this.child);
        }
        finally {
            this.parserPool.returnBuilder(builder);
        }
    }

    @Test
    public void testLookupNamespaceURI() {
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.parent, null, (String)PREFIX_1), (String)NAMESPACE_1, (String)"lookupNamespaceURI(parent)");
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.parent, null, (String)PREFIX_2), (String)NAMESPACE_2, (String)"lookupNamespaceURI(parent)");
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.parent, null, (String)PREFIX_3), (String)NAMESPACE_3, (String)"lookupNamespaceURI(parent)");
        Assert.assertNull((Object)NamespaceSupport.lookupNamespaceURI((Element)this.parent, null, (String)PREFIX_4), (String)"lookupNamespaceURI(parent)");
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.parent, null, null), (String)DEFAULT_NAMESPACE_1, (String)"lookupNamespaceURI(parent)");
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, null, (String)PREFIX_1), (String)NAMESPACE_2, (String)"lookupNamespaceURI(child)");
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, null, (String)PREFIX_2), (String)NAMESPACE_2, (String)"lookupNamespaceURI(child)");
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, null, (String)PREFIX_3), (String)NAMESPACE_3, (String)"lookupNamespaceURI(child)");
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, null, (String)PREFIX_4), (String)NAMESPACE_4, (String)"lookupNamespaceURI(child)");
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, null, null), (String)DEFAULT_NAMESPACE_1, (String)"lookupNamespaceURI(child)");
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, null, (String)PREFIX_1), (String)NAMESPACE_2, (String)"lookupNamespaceURI(grandchild)");
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, null, (String)PREFIX_2), (String)NAMESPACE_2, (String)"lookupNamespaceURI(grandchild)");
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, null, (String)PREFIX_3), (String)NAMESPACE_3, (String)"lookupNamespaceURI(grandchild)");
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, null, (String)PREFIX_4), (String)NAMESPACE_4, (String)"lookupNamespaceURI(grandchild)");
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, null, null), (String)DEFAULT_NAMESPACE_2, (String)"lookupNamespaceURI(grandchild)");
        Assert.assertNull((Object)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, (Element)this.grandchild, (String)PREFIX_1), (String)"lookupNamespaceURI(grandchild, grandchild)");
        Assert.assertNull((Object)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, (Element)this.grandchild, (String)PREFIX_2), (String)"lookupNamespaceURI(grandchild, grandchild)");
        Assert.assertNull((Object)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, (Element)this.grandchild, (String)PREFIX_3), (String)"lookupNamespaceURI(grandchild, grandchild)");
        Assert.assertNull((Object)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, (Element)this.grandchild, (String)PREFIX_4), (String)"lookupNamespaceURI(grandchild, grandchild)");
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, (Element)this.grandchild, null), (String)DEFAULT_NAMESPACE_2, (String)"lookupNamespaceURI(grandchild, grandchild)");
        Assert.assertNull((Object)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, (Element)this.child, (String)PREFIX_2), (String)"lookupNamespaceURI(grandchild, child)");
        Assert.assertNull((Object)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, (Element)this.child, (String)PREFIX_3), (String)"lookupNamespaceURI(grandchild, child)");
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, (Element)this.child, (String)PREFIX_1), (String)NAMESPACE_2, (String)"lookupNamespaceURI(grandchild, child)");
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, (Element)this.child, (String)PREFIX_4), (String)NAMESPACE_4, (String)"lookupNamespaceURI(grandchild, child)");
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, (Element)this.child, null), (String)DEFAULT_NAMESPACE_2, (String)"lookupNamespaceURI(grandchild, grandchild)");
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, (Element)this.parent, (String)PREFIX_1), (String)NAMESPACE_2, (String)"lookupNamespaceURI(child, parent)");
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, (Element)this.parent, (String)PREFIX_2), (String)NAMESPACE_2, (String)"lookupNamespaceURI(child, parent)");
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, (Element)this.parent, (String)PREFIX_3), (String)NAMESPACE_3, (String)"lookupNamespaceURI(child, parent)");
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, (Element)this.parent, (String)PREFIX_4), (String)NAMESPACE_4, (String)"lookupNamespaceURI(child, parent)");
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, (Element)this.parent, null), (String)DEFAULT_NAMESPACE_1, (String)"lookupNamespaceURI(child, parent)");
        Element element = ElementSupport.constructElement((Document)this.parent.getOwnerDocument(), (String)DEFAULT_NAMESPACE_1, (String)"Element", (String)PREFIX_1);
        Assert.assertEquals((String)element.lookupNamespaceURI(PREFIX_1), (String)DEFAULT_NAMESPACE_1, (String)"Default namespace correct");
        Assert.assertNull((Object)NamespaceSupport.lookupNamespaceURI((Element)element, null, (String)PREFIX_1), (String)"Default namespace correct");
    }

    @Test
    public void testLookupPrefix() {
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.parent, null, (String)NAMESPACE_1), (String)PREFIX_1, (String)"lookupPrefix(parent)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.parent, null, (String)NAMESPACE_2), (String)PREFIX_2, (String)"lookupPrefix(parent)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.parent, null, (String)NAMESPACE_3), (String)PREFIX_3, (String)"lookupPrefix(parent)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.parent, null, (String)NAMESPACE_4), null, (String)"lookupPrefix(parent)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.parent, null, (String)DEFAULT_NAMESPACE_1), null, (String)"lookupPrefix(parent)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.parent, null, (String)DEFAULT_NAMESPACE_2), null, (String)"lookupPrefix(parent)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.child, null, (String)NAMESPACE_1), (String)PREFIX_1, (String)"lookupPrefix(child)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.child, null, (String)NAMESPACE_2), (String)PREFIX_1, (String)"lookupPrefix(child)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.child, null, (String)NAMESPACE_3), (String)PREFIX_3, (String)"lookupPrefix(child)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.child, null, (String)NAMESPACE_4), (String)PREFIX_4, (String)"lookupPrefix(child)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.parent, null, (String)DEFAULT_NAMESPACE_1), null, (String)"lookupPrefix(parent)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.parent, null, (String)DEFAULT_NAMESPACE_2), null, (String)"lookupPrefix(parent)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.grandchild, null, (String)NAMESPACE_1), (String)PREFIX_1, (String)"lookupPrefix(grandchild)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.grandchild, null, (String)NAMESPACE_2), (String)PREFIX_1, (String)"lookupPrefix(grandchild)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.grandchild, null, (String)NAMESPACE_3), (String)PREFIX_3, (String)"lookupPrefix(grandchild)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.grandchild, null, (String)NAMESPACE_4), (String)PREFIX_4, (String)"lookupPrefix(grandchild)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.parent, null, (String)DEFAULT_NAMESPACE_1), null, (String)"lookupPrefix(parent)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.parent, null, (String)DEFAULT_NAMESPACE_2), null, (String)"lookupPrefix(parent)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.grandchild, (Element)this.child, (String)NAMESPACE_1), null, (String)"lookupPrefix(grandchild)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.grandchild, (Element)this.child, (String)NAMESPACE_2), (String)PREFIX_1, (String)"lookupPrefix(grandchild)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.grandchild, (Element)this.child, (String)NAMESPACE_3), null, (String)"lookupPrefix(grandchild)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.grandchild, (Element)this.child, (String)NAMESPACE_4), (String)PREFIX_4, (String)"lookupPrefix(grandchild)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.parent, null, (String)DEFAULT_NAMESPACE_1), null, (String)"lookupPrefix(parent)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.parent, null, (String)DEFAULT_NAMESPACE_2), null, (String)"lookupPrefix(parent)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.child, (Element)this.parent, (String)NAMESPACE_1), (String)PREFIX_1, (String)"lookupPrefix(child)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.child, (Element)this.parent, (String)NAMESPACE_2), (String)PREFIX_1, (String)"lookupPrefix(child)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.child, (Element)this.parent, (String)NAMESPACE_3), (String)PREFIX_3, (String)"lookupPrefix(child)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.child, (Element)this.parent, (String)NAMESPACE_4), (String)PREFIX_4, (String)"lookupPrefix(child)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.parent, null, (String)DEFAULT_NAMESPACE_1), null, (String)"lookupPrefix(parent)");
        Assert.assertEquals((String)NamespaceSupport.lookupPrefix((Element)this.parent, null, (String)DEFAULT_NAMESPACE_2), null, (String)"lookupPrefix(parent)");
        Element element = ElementSupport.constructElement((Document)this.parent.getOwnerDocument(), (String)DEFAULT_NAMESPACE_1, (String)"Element", (String)PREFIX_1);
        Assert.assertEquals((String)element.lookupPrefix(DEFAULT_NAMESPACE_1), (String)PREFIX_1, (String)"Default namespace correct");
        Assert.assertNull((Object)NamespaceSupport.lookupPrefix((Element)element, null, (String)DEFAULT_NAMESPACE_1), (String)"Default namespace correct");
    }

    @Test(dependsOnMethods={"testLookupPrefix", "testLookupNamespaceURI"})
    public void testAppendNamespaceDeclaration() {
        Element element = ElementSupport.constructElement((Document)this.parent.getOwnerDocument(), null, (String)"Element", null);
        NamespaceSupport.appendNamespaceDeclaration((Element)element, (String)NAMESPACE_1, (String)PREFIX_1);
        Assert.assertEquals((String)element.lookupNamespaceURI(PREFIX_1), (String)NAMESPACE_1, (String)"appendNamespaceDeclaration - simple add");
        NamespaceSupport.appendNamespaceDeclaration((Element)element, (String)NAMESPACE_2, (String)PREFIX_1);
        Assert.assertEquals((String)element.lookupPrefix(NAMESPACE_2), (String)PREFIX_1, (String)"appendNamespaceDeclaration - simple replace");
        Assert.assertEquals((String)element.lookupNamespaceURI(PREFIX_1), (String)NAMESPACE_2, (String)"appendNamespaceDeclaration - simple replace");
        boolean thrown = false;
        try {
            NamespaceSupport.appendNamespaceDeclaration((Element)element, (String)DEFAULT_NAMESPACE_1, null);
        }
        catch (DOMException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"cannot change default namespace");
        Assert.assertEquals((String)element.lookupPrefix(null), null, (String)"appendNamespaceDeclaration - default NS cannot be changed");
        Assert.assertEquals((String)element.lookupNamespaceURI(null), null, (String)"appendNamespaceDeclaration - default NS cannot be changed");
        element = ElementSupport.constructElement((Document)this.parent.getOwnerDocument(), (String)DEFAULT_NAMESPACE_1, (String)"Element", (String)PREFIX_1);
        NamespaceSupport.appendNamespaceDeclaration((Element)element, (String)NAMESPACE_2, null);
        thrown = false;
        try {
            NamespaceSupport.appendNamespaceDeclaration((Element)element, (String)DEFAULT_NAMESPACE_2, (String)PREFIX_1);
        }
        catch (DOMException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"cannot change that namespace");
        Assert.assertEquals((String)element.lookupNamespaceURI(PREFIX_1), (String)DEFAULT_NAMESPACE_1, (String)"appendNamespaceDeclaration - default NS can be changed");
        Assert.assertEquals((String)element.lookupPrefix(DEFAULT_NAMESPACE_1), (String)PREFIX_1, (String)"appendNamespaceDeclaration - that NS cannot be changed");
        element = ElementSupport.constructElement((Document)this.parent.getOwnerDocument(), (String)DEFAULT_NAMESPACE_1, (String)"Element", null);
        thrown = false;
        try {
            NamespaceSupport.appendNamespaceDeclaration((Element)element, (String)DEFAULT_NAMESPACE_2, null);
        }
        catch (DOMException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"cannot change default namespace");
        Assert.assertEquals((String)element.lookupNamespaceURI(null), (String)DEFAULT_NAMESPACE_1, (String)"appendNamespaceDeclaration - default NS cannot be changed");
        Assert.assertEquals((String)element.lookupPrefix(null), null, (String)"appendNamespaceDeclaration - default NS cannot be changed");
        NamespaceSupport.appendNamespaceDeclaration((Element)this.grandchild, (String)DEFAULT_NAMESPACE_1, null);
        Assert.assertEquals((String)this.grandchild.lookupNamespaceURI(null), (String)DEFAULT_NAMESPACE_1, (String)"Change default name space");
        NamespaceSupport.appendNamespaceDeclaration((Element)this.child, (String)NAMESPACE_3, (String)PREFIX_2);
        Assert.assertEquals((String)this.child.lookupNamespaceURI(PREFIX_2), (String)NAMESPACE_3, (String)"Change default name space");
    }

    @Test(dependsOnMethods={"testLookupPrefix", "testLookupNamespaceURI", "testAppendNamespaceDeclaration"})
    public void testRootNamespaces() {
        Assert.assertEquals((String)this.child.lookupNamespaceURI(null), (String)DEFAULT_NAMESPACE_1);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, null, null), (String)DEFAULT_NAMESPACE_1);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, (Element)this.child, null), null);
        Assert.assertEquals((String)this.child.lookupNamespaceURI(PREFIX_1), (String)NAMESPACE_2);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, null, (String)PREFIX_1), (String)NAMESPACE_2);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, (Element)this.child, (String)PREFIX_1), (String)NAMESPACE_2);
        Assert.assertEquals((String)this.child.lookupNamespaceURI(PREFIX_2), (String)NAMESPACE_2);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, null, (String)PREFIX_2), (String)NAMESPACE_2);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, (Element)this.child, (String)PREFIX_2), null);
        Assert.assertEquals((String)this.child.lookupNamespaceURI(PREFIX_3), (String)NAMESPACE_3);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, null, (String)PREFIX_3), (String)NAMESPACE_3);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, (Element)this.child, (String)PREFIX_3), null);
        Assert.assertEquals((String)this.child.lookupNamespaceURI(PREFIX_4), (String)NAMESPACE_4);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, null, (String)PREFIX_4), (String)NAMESPACE_4);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, (Element)this.child, (String)PREFIX_4), (String)NAMESPACE_4);
        Assert.assertEquals((String)this.grandchild.lookupNamespaceURI(null), (String)DEFAULT_NAMESPACE_2);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, null, null), (String)DEFAULT_NAMESPACE_2);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, (Element)this.grandchild, null), (String)DEFAULT_NAMESPACE_2);
        Assert.assertEquals((String)this.grandchild.lookupNamespaceURI(PREFIX_1), (String)NAMESPACE_2);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, null, (String)PREFIX_1), (String)NAMESPACE_2);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, (Element)this.grandchild, (String)PREFIX_1), null);
        Assert.assertEquals((String)this.grandchild.lookupNamespaceURI(PREFIX_2), (String)NAMESPACE_2);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, null, (String)PREFIX_2), (String)NAMESPACE_2);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, (Element)this.grandchild, (String)PREFIX_2), null);
        Assert.assertEquals((String)this.grandchild.lookupNamespaceURI(PREFIX_3), (String)NAMESPACE_3);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, null, (String)PREFIX_3), (String)NAMESPACE_3);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, (Element)this.grandchild, (String)PREFIX_3), null);
        Assert.assertEquals((String)this.grandchild.lookupNamespaceURI(PREFIX_4), (String)NAMESPACE_4);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, null, (String)PREFIX_4), (String)NAMESPACE_4);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, (Element)this.grandchild, (String)PREFIX_4), null);
        NamespaceSupport.rootNamespaces((Element)this.child);
        Assert.assertEquals((String)this.child.lookupNamespaceURI(null), (String)DEFAULT_NAMESPACE_1);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, null, null), (String)DEFAULT_NAMESPACE_1);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, (Element)this.child, null), (String)DEFAULT_NAMESPACE_1);
        Assert.assertEquals((String)this.child.lookupNamespaceURI(PREFIX_1), (String)NAMESPACE_2);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, null, (String)PREFIX_1), (String)NAMESPACE_2);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, (Element)this.child, (String)PREFIX_1), (String)NAMESPACE_2);
        Assert.assertEquals((String)this.child.lookupNamespaceURI(PREFIX_2), (String)NAMESPACE_2);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, null, (String)PREFIX_2), (String)NAMESPACE_2);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, (Element)this.child, (String)PREFIX_2), null);
        Assert.assertEquals((String)this.child.lookupNamespaceURI(PREFIX_3), (String)NAMESPACE_3);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, null, (String)PREFIX_3), (String)NAMESPACE_3);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, (Element)this.child, (String)PREFIX_3), null);
        Assert.assertEquals((String)this.child.lookupNamespaceURI(PREFIX_4), (String)NAMESPACE_4);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, null, (String)PREFIX_4), (String)NAMESPACE_4);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.child, (Element)this.child, (String)PREFIX_4), (String)NAMESPACE_4);
        Assert.assertEquals((String)this.grandchild.lookupNamespaceURI(null), (String)DEFAULT_NAMESPACE_2);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, null, null), (String)DEFAULT_NAMESPACE_2);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, (Element)this.grandchild, null), (String)DEFAULT_NAMESPACE_2);
        Assert.assertEquals((String)this.grandchild.lookupNamespaceURI(PREFIX_1), (String)NAMESPACE_2);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, null, (String)PREFIX_1), (String)NAMESPACE_2);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, (Element)this.grandchild, (String)PREFIX_1), null);
        Assert.assertEquals((String)this.grandchild.lookupNamespaceURI(PREFIX_2), (String)NAMESPACE_2);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, null, (String)PREFIX_2), (String)NAMESPACE_2);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, (Element)this.grandchild, (String)PREFIX_2), (String)NAMESPACE_2);
        Assert.assertEquals((String)this.grandchild.lookupNamespaceURI(PREFIX_3), (String)NAMESPACE_3);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, null, (String)PREFIX_3), (String)NAMESPACE_3);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, (Element)this.grandchild, (String)PREFIX_3), (String)NAMESPACE_3);
        Assert.assertEquals((String)this.grandchild.lookupNamespaceURI(PREFIX_4), (String)NAMESPACE_4);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, null, (String)PREFIX_4), (String)NAMESPACE_4);
        Assert.assertEquals((String)NamespaceSupport.lookupNamespaceURI((Element)this.grandchild, (Element)this.grandchild, (String)PREFIX_4), null);
    }
}

